/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.LoopInvariantsWriter;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateAbstractionsWriter;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateMapWriter;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="cpa.predicate")
class PredicateCPAStatistics
implements Statistics {
    @Option(secure=true, description="generate statistics about precisions (may be slow)")
    private boolean precisionStatistics = true;
    @Option(secure=true, description="export final predicate map", name="predmap.export")
    private boolean exportPredmap = true;
    @Option(secure=true, description="file for exporting final predicate map", name="predmap.file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path predmapFile = Path.of("predmap.txt", new String[0]);
    @Option(secure=true, description="export final loop invariants", name="invariants.export")
    private boolean exportInvariants = true;
    @Option(secure=true, description="export invariants as precision file?", name="invariants.exportAsPrecision")
    private boolean exportInvariantsAsPrecision = true;
    @Option(secure=true, description="file for exporting final loop invariants", name="invariants.file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path invariantsFile = Path.of("invariants.txt", new String[0]);
    @Option(secure=true, description="file for precision that consists of invariants.", name="invariants.precisionFile")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path invariantPrecisionsFile = Path.of("invariantPrecs.txt", new String[0]);
    @Option(description="Export one abstraction formula for each abstraction state into a file?", name="abstractions.export")
    private boolean abstractionsExport = true;
    @Option(secure=true, description="file that consists of one abstraction formula for each abstraction state", name="abstractions.file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path abstractionsFile = Path.of("abstractions.txt", new String[0]);
    private final LogManager logger;
    private final Solver solver;
    private final PathFormulaManager pfmgr;
    private final BlockOperator blk;
    private final RegionManager rmgr;
    private final AbstractionManager absmgr;
    private final PredicateAbstractionStatistics abstractionStats;
    private final PredicateStatistics statistics;
    private final PredicateMapWriter precisionWriter;
    private final LoopInvariantsWriter loopInvariantsWriter;
    private final PredicateAbstractionsWriter abstractionsWriter;

    public PredicateCPAStatistics(Configuration pConfig, LogManager pLogger, CFA pCfa, Solver pSolver, PathFormulaManager pPfmgr, BlockOperator pBlk, RegionManager pRmgr, AbstractionManager pAbsmgr, PredicateAbstractionStatistics pAbstractionStats, PredicateStatistics pStatistics) throws InvalidConfigurationException {
        pConfig.inject((Object)this, PredicateCPAStatistics.class);
        this.logger = pLogger;
        this.solver = pSolver;
        this.pfmgr = pPfmgr;
        this.blk = pBlk;
        this.rmgr = pRmgr;
        this.absmgr = pAbsmgr;
        this.abstractionStats = pAbstractionStats;
        this.statistics = pStatistics;
        FormulaManagerView fmgr = pSolver.getFormulaManager();
        this.loopInvariantsWriter = new LoopInvariantsWriter(pCfa, pLogger, pAbsmgr, fmgr, pRmgr);
        this.abstractionsWriter = new PredicateAbstractionsWriter(pLogger, fmgr);
        this.precisionWriter = this.exportPredmap && this.predmapFile != null ? new PredicateMapWriter(pConfig, fmgr) : null;
    }

    @Override
    public String getName() {
        return "PredicateCPA";
    }

    private void exportPredmapToFile(Path targetFile, MutablePredicateSets predicates) {
        Preconditions.checkNotNull((Object)targetFile);
        Preconditions.checkNotNull((Object)predicates);
        LinkedHashSet<AbstractionPredicate> allPredicates = new LinkedHashSet<AbstractionPredicate>(predicates.global);
        allPredicates.addAll(predicates.function.values());
        allPredicates.addAll(predicates.location.values());
        allPredicates.addAll(predicates.locationInstance.values());
        try (Writer w = IO.openOutputFile((Path)targetFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            this.precisionWriter.writePredicateMap(predicates.locationInstance, predicates.location, predicates.function, predicates.global, allPredicates, w);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write predicate map to file");
        }
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        int maxPredsPerLocation = -1;
        int allLocs = -1;
        int avgPredsPerLocation = -1;
        if (this.precisionStatistics) {
            MutablePredicateSets predicates = new MutablePredicateSets();
            Set seenPrecisions = Collections.newSetFromMap(new IdentityHashMap());
            for (Precision precision : reached.getPrecisions()) {
                PredicatePrecision preds = Precisions.extractPrecisionByType(precision, PredicatePrecision.class);
                if (preds == null || !seenPrecisions.add(preds)) continue;
                predicates.locationInstance.putAll(preds.getLocationInstancePredicates());
                predicates.location.putAll(preds.getLocalPredicates());
                predicates.function.putAll(preds.getFunctionPredicates());
                predicates.global.addAll((Collection<AbstractionPredicate>)preds.getGlobalPredicates());
            }
            if (this.exportPredmap && this.predmapFile != null) {
                this.exportPredmapToFile(this.predmapFile, predicates);
            }
            maxPredsPerLocation = 0;
            for (Collection p : predicates.location.asMap().values()) {
                maxPredsPerLocation = Math.max(maxPredsPerLocation, p.size());
            }
            allLocs = predicates.location.keySet().size();
            int totPredsUsed = predicates.location.size();
            avgPredsPerLocation = allLocs > 0 ? totPredsUsed / allLocs : 0;
        }
        int allDistinctPreds = this.absmgr.getNumberOfPredicates();
        if (this.exportInvariants && this.invariantsFile != null) {
            this.loopInvariantsWriter.exportLoopInvariants(this.invariantsFile, reached);
        }
        if (this.abstractionsExport && this.abstractionsFile != null) {
            this.abstractionsWriter.writeAbstractions(this.abstractionsFile, reached);
        }
        if (this.exportInvariantsAsPrecision && this.invariantPrecisionsFile != null) {
            this.loopInvariantsWriter.exportLoopInvariantsAsPrecision(this.invariantPrecisionsFile, reached);
        }
        PredicateAbstractionStatistics as = this.abstractionStats;
        int numAbstractions = this.statistics.numAbstractions.getUpdateCount();
        out.println("Number of abstractions:            " + numAbstractions + " (" + StatisticsUtils.toPercent(numAbstractions, this.statistics.postTimer.getNumberOfIntervals()) + " of all post computations)");
        if (numAbstractions > 0) {
            out.println("  Times abstraction was reused:    " + as.numAbstractionReuses);
            out.println("  Because of function entry/exit:  " + StatisticsUtils.valueWithPercentage(this.blk.numBlkFunctions.getValue(), numAbstractions));
            out.println("  Because of loop head:            " + StatisticsUtils.valueWithPercentage(this.blk.numBlkLoops.getValue(), numAbstractions));
            out.println("  Because of join nodes:           " + StatisticsUtils.valueWithPercentage(this.blk.numBlkJoins.getValue(), numAbstractions));
            out.println("  Because of threshold:            " + StatisticsUtils.valueWithPercentage(this.blk.numBlkThreshold.getValue(), numAbstractions));
            out.println("  Because of target state:         " + StatisticsUtils.valueWithPercentage(this.statistics.numTargetAbstractions.getUpdateCount(), numAbstractions));
            out.println("  Times precision was empty:       " + StatisticsUtils.valueWithPercentage(as.numSymbolicAbstractions, as.numCallsAbstraction));
            out.println("  Times precision was {false}:     " + StatisticsUtils.valueWithPercentage(as.numSatCheckAbstractions, as.numCallsAbstraction));
            out.println("  Times result was cached:         " + StatisticsUtils.valueWithPercentage(as.numCallsAbstractionCached, as.numCallsAbstraction));
            out.println("  Times cartesian abs was used:    " + StatisticsUtils.valueWithPercentage(as.cartesianAbstractionTime.getNumberOfIntervals(), as.numCallsAbstraction));
            out.println("  Times boolean abs was used:      " + StatisticsUtils.valueWithPercentage(as.booleanAbstractionTime.getNumberOfIntervals(), as.numCallsAbstraction));
            out.println("  Times result was 'false':        " + StatisticsUtils.valueWithPercentage(this.statistics.numAbstractionsFalse.getUpdateCount(), numAbstractions));
            if (as.inductivePredicatesTime.getNumberOfIntervals() > 0) {
                out.println("  Times inductive cache was used:  " + StatisticsUtils.valueWithPercentage(as.numInductivePathFormulaCacheUsed, as.numCallsAbstraction));
            }
        }
        if (this.statistics.satCheckTimer.getNumberOfIntervals() > 0) {
            out.println("Number of satisfiability checks:   " + this.statistics.satCheckTimer.getNumberOfIntervals());
            out.println("  Times result was 'false':        " + this.statistics.numSatChecksFalse + " (" + StatisticsUtils.toPercent(this.statistics.numSatChecksFalse.getUpdateCount(), this.statistics.satCheckTimer.getNumberOfIntervals()) + ")");
        }
        out.println("Number of strengthen sat checks:   " + this.statistics.strengthenCheckTimer.getNumberOfIntervals());
        if (this.statistics.strengthenCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Times result was 'false':        " + this.statistics.numStrengthenChecksFalse + " (" + StatisticsUtils.toPercent(this.statistics.numStrengthenChecksFalse.getUpdateCount(), this.statistics.strengthenCheckTimer.getNumberOfIntervals()) + ")");
        }
        out.println("Number of coverage checks:         " + this.statistics.coverageCheckTimer.getNumberOfIntervals());
        out.println("  BDD entailment checks:           " + this.statistics.bddCoverageCheckTimer.getNumberOfIntervals());
        if (this.statistics.symbolicCoverageCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Symbolic coverage check:         " + this.statistics.symbolicCoverageCheckTimer.getNumberOfIntervals());
        }
        out.println("Number of SMT sat checks:          " + this.solver.satChecks);
        out.println("  trivial:                         " + this.solver.trivialSatChecks);
        out.println("  cached:                          " + this.solver.cachedSatChecks);
        out.println();
        out.println("Max ABE block size:                       " + this.statistics.blockSize.getMaxValue());
        this.put(out, 0, this.statistics.blockSize);
        out.println("Number of predicates discovered:          " + allDistinctPreds);
        if (this.precisionStatistics && allDistinctPreds > 0) {
            out.println("Number of abstraction locations:          " + allLocs);
            out.println("Max number of predicates per location:    " + maxPredsPerLocation);
            out.println("Avg number of predicates per location:    " + avgPredsPerLocation);
        }
        if (as.numCallsAbstraction.get() > as.numSymbolicAbstractions.get()) {
            int numRealAbstractions = as.numCallsAbstraction.get() - as.numSymbolicAbstractions.get() - as.numCallsAbstractionCached.get();
            out.println("Total predicates per abstraction:         " + as.numTotalPredicates);
            out.println("Max number of predicates per abstraction: " + as.maxPredicates);
            out.println("Avg number of predicates per abstraction: " + StatisticsUtils.div(as.numTotalPredicates.get(), numRealAbstractions));
            out.println("Number of irrelevant predicates:          " + StatisticsUtils.valueWithPercentage(as.numIrrelevantPredicates, as.numTotalPredicates));
            if (as.trivialPredicatesTime.getNumberOfIntervals() > 0) {
                out.println("Number of trivially used predicates:      " + StatisticsUtils.valueWithPercentage(as.numTrivialPredicates, as.numTotalPredicates));
            }
            if (as.inductivePredicatesTime.getNumberOfIntervals() > 0) {
                out.println("Number of inductive predicates:           " + StatisticsUtils.valueWithPercentage(as.numInductivePredicates, as.numTotalPredicates));
            }
            if (as.cartesianAbstractionTime.getNumberOfIntervals() > 0) {
                out.println("Number of preds cached for cartesian abs: " + StatisticsUtils.valueWithPercentage(as.numCartesianAbsPredicatesCached, as.numTotalPredicates));
                out.println("Number of preds solved by cartesian abs:  " + StatisticsUtils.valueWithPercentage(as.numCartesianAbsPredicates, as.numTotalPredicates));
            }
            if (as.booleanAbstractionTime.getNumberOfIntervals() > 0) {
                out.println("Number of preds handled by boolean abs:   " + StatisticsUtils.valueWithPercentage(as.numBooleanAbsPredicates, as.numTotalPredicates));
                out.println("  Total number of models for allsat:      " + as.allSatCount);
                out.println("  Max number of models for allsat:        " + as.maxAllSatCount);
                out.println("  Avg number of models for allsat:        " + StatisticsUtils.div(as.allSatCount, as.booleanAbstractionTime.getNumberOfIntervals()));
            }
        }
        out.println();
        this.put(out, 0, this.statistics.postTimer);
        this.put(out, 1, this.statistics.pathFormulaTimer);
        if (this.statistics.satCheckTimer.getNumberOfIntervals() > 0) {
            this.put(out, 1, this.statistics.satCheckTimer);
        }
        this.put(out, 0, this.statistics.strengthenTimer);
        if (this.statistics.strengthenCheckTimer.getNumberOfIntervals() > 0) {
            this.put(out, 1, this.statistics.strengthenCheckTimer);
        }
        this.put(out, 0, this.statistics.totalPrecTime);
        if (numAbstractions > 0) {
            out.println("  Time for abstraction:              " + this.statistics.computingAbstractionTime + " (Max: " + this.statistics.computingAbstractionTime.getMaxTime().formatAs(TimeUnit.SECONDS) + ", Count: " + this.statistics.computingAbstractionTime.getNumberOfIntervals() + ")");
            if (as.trivialPredicatesTime.getNumberOfIntervals() > 0) {
                out.println("    Relevant predicate analysis:     " + as.trivialPredicatesTime);
            }
            if (as.inductivePredicatesTime.getNumberOfIntervals() > 0) {
                out.println("    Inductive predicate analysis:    " + as.inductivePredicatesTime);
            }
            if (as.cartesianAbstractionTime.getNumberOfIntervals() > 0) {
                out.println("    Cartesian abstraction:           " + as.cartesianAbstractionTime);
            }
            if (as.booleanAbstractionTime.getNumberOfIntervals() > 0) {
                out.println("    Boolean abstraction:             " + as.booleanAbstractionTime);
            }
            if (as.abstractionReuseTime.getNumberOfIntervals() > 0) {
                out.println("    Abstraction reuse:              " + as.abstractionReuseTime);
                out.println("    Abstraction reuse implication:  " + as.abstractionReuseImplicationTime);
            }
            out.println("    Solving time:                    " + as.abstractionSolveTime + " (Max: " + as.abstractionSolveTime.getMaxTime().formatAs(TimeUnit.SECONDS) + ")");
            out.println("    Model enumeration time:          " + as.abstractionModelEnumTime.getSumTime().formatAs(TimeUnit.SECONDS));
            out.println("    Time for BDD construction:       " + as.abstractionBddConstructionTime.getSumTime().formatAs(TimeUnit.SECONDS) + " (Max: " + as.abstractionBddConstructionTime.getMaxTime().formatAs(TimeUnit.SECONDS) + ")");
        }
        if (this.statistics.totalMergeTime.getNumberOfIntervals() != 0) {
            this.put(out, 0, this.statistics.totalMergeTime);
        }
        this.put(out, 0, this.statistics.coverageCheckTimer);
        if (this.statistics.bddCoverageCheckTimer.getNumberOfIntervals() > 0) {
            this.put(out, 1, this.statistics.bddCoverageCheckTimer);
        }
        if (this.statistics.symbolicCoverageCheckTimer.getNumberOfIntervals() > 0) {
            this.put(out, 1, this.statistics.symbolicCoverageCheckTimer);
        }
        out.println("Total time for SMT solver (w/o itp): " + TimeSpan.sum((TimeSpan[])new TimeSpan[]{this.solver.solverTime.getSumTime(), as.abstractionSolveTime.getSumTime(), as.abstractionModelEnumTime.getSumTime()}).formatAs(TimeUnit.SECONDS));
        if (this.statistics.abstractionCheckTimer.getNumberOfIntervals() > 0) {
            this.put(out, 0, this.statistics.abstractionCheckTimer);
            out.println("Time for unsat checks:             " + this.statistics.satCheckTimer + " (Calls: " + this.statistics.satCheckTimer.getNumberOfIntervals() + ")");
        }
        out.println();
        this.pfmgr.printStatistics(out);
        out.println();
        this.rmgr.printStatistics(out);
        this.solver.printStatistics(out);
    }

    private static class MutablePredicateSets {
        private final SetMultimap<PredicatePrecision.LocationInstance, AbstractionPredicate> locationInstance = MultimapBuilder.treeKeys().linkedHashSetValues().build();
        private final SetMultimap<CFANode, AbstractionPredicate> location = MultimapBuilder.treeKeys().linkedHashSetValues().build();
        private final SetMultimap<String, AbstractionPredicate> function = MultimapBuilder.treeKeys().linkedHashSetValues().build();
        private final Set<AbstractionPredicate> global = new LinkedHashSet<AbstractionPredicate>();

        private MutablePredicateSets() {
        }
    }
}

