/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.reflect.Invokable;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.Test;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class PredicateCPATest {
    private static final Pattern PREDICATECPA_CLASSES = Pattern.compile("org\\.sosy_lab\\.cpachecker\\..*(predicate|bdd|BDD|FormulaReportingState|InvariantSupplier).*");
    private static final Pattern BDD_CLASS_PATTERN = Pattern.compile("(BDD|bdd)");

    @Test
    public void dontLoadBDDLibraryIfNotNecessary() throws Exception {
        Configuration config = TestDataTools.configurationForTest().setOption("cpa.predicate.blk.alwaysAtFunctions", "false").setOption("cpa.predicate.blk.alwaysAtLoops", "false").build();
        FluentIterable<String> loadedClasses = this.loadPredicateCPA(config);
        Truth.assertThat((Iterable)loadedClasses.filter(Predicates.contains((Pattern)BDD_CLASS_PATTERN))).isEmpty();
    }

    @Test
    public void loadBDDLibraryIfNecessary() throws Exception {
        Configuration config = TestDataTools.configurationForTest().build();
        FluentIterable<String> loadedClasses = this.loadPredicateCPA(config);
        Truth.assertThat((Iterable)loadedClasses.filter(Predicates.contains((Pattern)BDD_CLASS_PATTERN))).isNotEmpty();
    }

    @SuppressForbidden(value="reflection only in test")
    private FluentIterable<String> loadPredicateCPA(Configuration config) throws Exception {
        ClassLoader myClassLoader = PredicateCPATest.class.getClassLoader();
        TruthJUnit.assume().that((Object)myClassLoader).isInstanceOf(URLClassLoader.class);
        LogManager logger = LogManager.createTestLogManager();
        try (URLClassLoader cl = Classes.makeExtendedURLClassLoader().setParent(myClassLoader).setUrls(((URLClassLoader)myClassLoader).getURLs()).setDirectLoadClasses(PREDICATECPA_CLASSES).build();){
            Class<?> cpaClass = cl.loadClass(PredicateCPATest.class.getPackage().getName() + ".PredicateCPA");
            Invokable factoryMethod = Invokable.from((Method)cpaClass.getDeclaredMethod("factory", new Class[0])).returning(CPAFactory.class);
            CPAFactory factory = (CPAFactory)factoryMethod.invoke(null, new Object[0]);
            factory.setConfiguration(config);
            factory.setLogger(logger);
            factory.setShutdownNotifier(ShutdownNotifier.createDummy());
            factory.set(AggregatedReachedSets.empty(), AggregatedReachedSets.class);
            factory.set(TestDataTools.makeCFA(config, "void main() { }"), CFA.class);
            factory.set(new ReachedSetFactory(config, logger), ReachedSetFactory.class);
            factory.set(Specification.alwaysSatisfied(), Specification.class);
            ConfigurableProgramAnalysis cpa = factory.createInstance();
            if (cpa instanceof AutoCloseable) {
                ((AutoCloseable)((Object)cpa)).close();
            }
            Field classesField = ClassLoader.class.getDeclaredField("classes");
            classesField.setAccessible(true);
            List classes = (List)classesField.get(cl);
            FluentIterable fluentIterable = FluentIterable.from((Iterable)classes).transform(Class::getName);
            return fluentIterable;
        }
    }
}

