/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCovering;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCoveringStopOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.ImpactUtility;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class PredicateForcedCovering
implements ForcedCovering,
StatisticsProvider {
    private final FCStatistics stats = new FCStatistics();
    private final LogManager logger;
    private final ARGCPA argCpa;
    private final ForcedCoveringStopOperator stop;
    private final FormulaManagerView fmgr;
    private final InterpolationManager imgr;
    private final PredicateAbstractionManager predAbsMgr;
    private final ImpactUtility impact;

    public PredicateForcedCovering(Configuration config, LogManager pLogger, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        this.logger = pLogger;
        if (!(pCpa instanceof ARGCPA)) {
            throw new InvalidConfigurationException(PredicateForcedCovering.class.getSimpleName() + " needs an ARGCPA");
        }
        this.argCpa = (ARGCPA)pCpa;
        this.stop = this.argCpa.getStopOperator();
        PredicateCPA predicateCpa = CPAs.retrieveCPAOrFail(pCpa, PredicateCPA.class, PredicateForcedCovering.class);
        this.imgr = new InterpolationManager(predicateCpa.getPathFormulaManager(), predicateCpa.getSolver(), predicateCpa.getCfa().getLoopStructure(), predicateCpa.getCfa().getVarClassification(), config, predicateCpa.getShutdownNotifier(), pLogger);
        this.fmgr = predicateCpa.getSolver().getFormulaManager();
        this.predAbsMgr = predicateCpa.getPredicateManager();
        this.impact = new ImpactUtility(config, this.fmgr, this.predAbsMgr);
    }

    @Override
    public boolean tryForcedCovering(AbstractState pState, Precision pPrecision, ReachedSet pReached) throws CPAException, InterruptedException {
        ARGState argState = (ARGState)pState;
        if (argState.isCovered()) {
            return false;
        }
        if (pReached.getReached(pState).size() <= 1) {
            return false;
        }
        PredicateAbstractState predicateElement = PredicateAbstractState.getPredicateState(pState);
        if (!predicateElement.isAbstractionState()) {
            return false;
        }
        BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
        this.logger.log(Level.FINER, new Object[]{"Starting interpolation-based forced covering."});
        this.logger.log(Level.ALL, new Object[]{"Attempting to force-cover", argState});
        ARGReachedSet arg = new ARGReachedSet(pReached, this.argCpa);
        ImmutableList<ARGState> parentList = this.getAbstractionPathTo(argState);
        for (AbstractState coveringCandidate : pReached.getReached(pState)) {
            if (pState == coveringCandidate) continue;
            if (this.stop.stop(argState, Collections.singleton(coveringCandidate), pPrecision) || argState.isCovered()) {
                ++this.stats.wasAlreadyCovered;
                this.logger.log(Level.FINER, new Object[]{"State was covered by another state without strengthening"});
                return true;
            }
            if (!this.stop.isForcedCoveringPossible(pState, coveringCandidate, pPrecision)) continue;
            ++this.stats.attemptedForcedCoverings;
            this.logger.log(Level.ALL, new Object[]{"Candidate for forced-covering is", coveringCandidate});
            ImmutableList<ARGState> candidateParentList = this.getAbstractionPathTo((ARGState)coveringCandidate);
            int commonParentIdx = PredicateForcedCovering.findLengthOfCommonPrefix(parentList, candidateParentList) - 1;
            assert (commonParentIdx >= 0) : "States do not have common parent, but are in the same reached set";
            assert (((ARGState)parentList.get(commonParentIdx)).equals(candidateParentList.get(commonParentIdx))) : "Common prefix does not end with same element";
            ARGState commonParent = (ARGState)parentList.get(commonParentIdx);
            List path = parentList.subList(commonParentIdx + 1, parentList.size());
            ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>(path.size() + 1);
            formulas.add(PredicateAbstractState.getPredicateState(commonParent).getAbstractionFormula().asInstantiatedFormula());
            for (AbstractState pathElement : path) {
                formulas.add(PredicateAbstractState.getPredicateState(pathElement).getAbstractionFormula().getBlockFormula().getFormula());
            }
            SSAMap ssaMap = PredicateAbstractState.getPredicateState(argState).getPathFormula().getSsa().withDefault(1);
            BooleanFormula stateFormula = PredicateAbstractState.getPredicateState(coveringCandidate).getAbstractionFormula().asFormula();
            assert (!bfmgr.isTrue(stateFormula)) : "Existing state with abstraction true would cover anyway, no forced covering needed";
            formulas.add(bfmgr.not(this.fmgr.instantiate(stateFormula, ssaMap)));
            assert (formulas.size() == path.size() + 2);
            Optional<ImmutableList<BooleanFormula>> interpolantInfo = this.imgr.interpolate(formulas);
            if (interpolantInfo.isEmpty()) {
                this.logger.log(Level.FINER, new Object[]{"Forced covering unsuccessful."});
                continue;
            }
            ++this.stats.successfulForcedCoverings;
            this.logger.log(Level.FINER, new Object[]{"Forced covering successful."});
            List interpolants = (List)interpolantInfo.orElseThrow();
            assert (interpolants.size() == formulas.size() - 1) : "Number of interpolants is wrong";
            interpolants = interpolants.subList(1, interpolants.size());
            AbstractionFormula lastAbstraction = PredicateAbstractState.getPredicateState(commonParent).getAbstractionFormula();
            for (Pair interpolationPoint : Pair.zipList(interpolants, path)) {
                boolean stateChanged;
                BooleanFormula itp = (BooleanFormula)interpolationPoint.getFirst();
                ARGState element = (ARGState)interpolationPoint.getSecond();
                try {
                    stateChanged = this.impact.strengthenStateWithInterpolant(itp, element, lastAbstraction);
                }
                catch (SolverException e) {
                    throw new CPAException("Solver failure", e);
                }
                if (stateChanged) {
                    arg.removeCoverageOf(element);
                }
                lastAbstraction = PredicateAbstractState.getPredicateState(element).getAbstractionFormula();
            }
            assert (this.stop.stop(argState, Collections.singleton(coveringCandidate), pPrecision) || argState.isCovered()) : "Forced covering did not cover element\n" + argState + "\nwith\n" + coveringCandidate;
            if (!argState.isCovered()) {
                argState.setCovered((ARGState)coveringCandidate);
            } else assert (argState.getCoveringState() == coveringCandidate);
            return true;
        }
        return false;
    }

    private ImmutableList<ARGState> getAbstractionPathTo(ARGState argState) {
        ARGPath pathFromRoot = ARGUtils.getOnePathTo(argState);
        return FluentIterable.from(pathFromRoot.asStatesList()).filter(PredicateAbstractState::containsAbstractionState).toList();
    }

    private static int findLengthOfCommonPrefix(Iterable<?> i1, Iterable<?> i2) {
        int i = 0;
        Iterator<?> it1 = i1.iterator();
        Iterator<?> it2 = i2.iterator();
        while (it1.hasNext() && it2.hasNext() && Objects.equals(it1.next(), it2.next())) {
            ++i;
        }
        return i;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private static final class FCStatistics
    implements Statistics {
        private int attemptedForcedCoverings = 0;
        private int successfulForcedCoverings = 0;
        private int wasAlreadyCovered = 0;

        private FCStatistics() {
        }

        @Override
        public String getName() {
            return "Predicate Forced Covering";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("Attempted forced coverings:             " + this.attemptedForcedCoverings);
            if (this.attemptedForcedCoverings > 0) {
                out.println("Successful forced coverings:            " + this.successfulForcedCoverings + " (" + StatisticsUtils.toPercent(this.successfulForcedCoverings, this.attemptedForcedCoverings) + ")");
            }
            out.println("No of times elment was already covered: " + this.wasAlreadyCovered);
        }
    }
}

