/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStatistics;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class PredicateMergeOperator
implements MergeOperator {
    private final LogManager logger;
    private final PathFormulaManager formulaManager;
    private final PredicateStatistics statistics;
    private final ThreadSafeTimerContainer.TimerWrapper totalMergeTimer;
    private boolean mergeAbstractionStates;
    private final PredicateAbstractionManager predAbsManager;

    public PredicateMergeOperator(LogManager pLogger, PathFormulaManager pPfmgr, PredicateStatistics pStatistics, boolean pMergeAbstractionStates, PredicateAbstractionManager pPredAbsManager) {
        this.logger = pLogger;
        this.formulaManager = pPfmgr;
        this.statistics = pStatistics;
        this.totalMergeTimer = this.statistics.totalMergeTime.getNewTimer();
        this.mergeAbstractionStates = pMergeAbstractionStates;
        this.predAbsManager = pPredAbsManager;
    }

    @Override
    public AbstractState merge(AbstractState element1, AbstractState element2, Precision precision) throws InterruptedException {
        PredicateAbstractState merged;
        PredicateAbstractState elem1 = (PredicateAbstractState)element1;
        PredicateAbstractState elem2 = (PredicateAbstractState)element2;
        if (this.mergeAbstractionStates && elem1.isAbstractionState() && elem2.isAbstractionState() && !elem1.getAbstractionFormula().equals(elem2.getAbstractionFormula()) && elem1.getPreviousAbstractionState().equals(elem2.getPreviousAbstractionState())) {
            this.totalMergeTimer.start();
            AbstractionFormula newAbstractionFormula = this.predAbsManager.makeOr(elem1.getAbstractionFormula(), elem2.getAbstractionFormula());
            PathFormula newPathFormula = this.formulaManager.makeEmptyPathFormulaWithContextFrom(newAbstractionFormula.getBlockFormula());
            PredicateAbstractState merged2 = PredicateAbstractState.mkAbstractionState(newPathFormula, newAbstractionFormula, elem2.getAbstractionLocationsOnPath(), elem2.getPreviousAbstractionState());
            elem1.setMergedInto(merged2);
            this.totalMergeTimer.stop();
            return merged2;
        }
        if (elem1.isAbstractionState() || elem2.isAbstractionState()) {
            merged = elem2;
        } else if (!elem1.getAbstractionFormula().equals(elem2.getAbstractionFormula()) || elem1.getPathFormula().equals(elem2.getPathFormula())) {
            merged = elem2;
        } else {
            this.totalMergeTimer.start();
            assert (elem1.getAbstractionLocationsOnPath().equals(elem2.getAbstractionLocationsOnPath()));
            this.logger.log(Level.FINEST, new Object[]{"Merging two non-abstraction nodes."});
            PathFormula pathFormula = this.formulaManager.makeOr(elem1.getPathFormula(), elem2.getPathFormula());
            this.logger.log(Level.ALL, new Object[]{"New path formula is", pathFormula});
            merged = PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(pathFormula, elem1, elem2.getPreviousAbstractionState());
            elem1.setMergedInto(merged);
            this.totalMergeTimer.stop();
        }
        return merged;
    }
}

