/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.Collection;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class PredicatePCCStopOperator
implements StopOperator {
    private final PredicateAbstractionManager paMgr;
    private final PathFormulaManager pMgr;
    private final Solver solver;
    private final AbstractionFormula trueAbs;

    public PredicatePCCStopOperator(PathFormulaManager pPfmgr, PredicateAbstractionManager pPredAbsManager, Solver pSolver) {
        this.paMgr = pPredAbsManager;
        this.pMgr = pPfmgr;
        this.solver = pSolver;
        this.trueAbs = this.paMgr.makeTrueAbstractionFormula(null);
    }

    @Override
    public boolean stop(AbstractState pState, Collection<AbstractState> pReached, Precision pPrecision) throws CPAException, InterruptedException {
        PredicateAbstractState e1 = (PredicateAbstractState)pState;
        for (AbstractState reachedState : pReached) {
            PredicateAbstractState e2 = (PredicateAbstractState)reachedState;
            try {
                if (!this.isCoveredBy(e1, e2)) continue;
                return true;
            }
            catch (SolverException e) {
                throw new CPAException("Solver Failure", e);
            }
        }
        return false;
    }

    private boolean isCoveredBy(PredicateAbstractState e1, PredicateAbstractState e2) throws InterruptedException, SolverException {
        if (e1.isAbstractionState() && e2.isAbstractionState()) {
            return this.paMgr.checkCoverage(e1.getAbstractionFormula(), e2.getAbstractionFormula());
        }
        if (e2.isAbstractionState()) {
            return this.paMgr.checkCoverage(e1.getAbstractionFormula(), e1.getPathFormula(), e2.getAbstractionFormula());
        }
        if (e1.isAbstractionState()) {
            return false;
        }
        if (e1.getAbstractionFormula() == e2.getAbstractionFormula()) {
            BooleanFormula implicationTest = this.pMgr.buildImplicationTestAsUnsat(e1.getPathFormula(), e2.getPathFormula());
            return this.solver.isUnsat(this.solver.getFormulaManager().makeAnd(this.trueAbs.asInstantiatedFormula(), implicationTest));
        }
        return false;
    }
}

