/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AdjustablePrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;

public final class PredicatePrecision
implements AdjustablePrecision {
    private final ImmutableSetMultimap<LocationInstance, AbstractionPredicate> mLocationInstancePredicates;
    private final ImmutableSetMultimap<CFANode, AbstractionPredicate> mLocalPredicates;
    private final ImmutableSetMultimap<String, AbstractionPredicate> mFunctionPredicates;
    private final ImmutableSet<AbstractionPredicate> mGlobalPredicates;
    private static final PredicatePrecision EMPTY = new PredicatePrecision((Iterable<Map.Entry<LocationInstance, AbstractionPredicate>>)ImmutableList.of(), (Iterable<Map.Entry<CFANode, AbstractionPredicate>>)ImmutableList.of(), (Iterable<Map.Entry<String, AbstractionPredicate>>)ImmutableList.of(), (Iterable<AbstractionPredicate>)ImmutableList.of());

    public PredicatePrecision(Multimap<LocationInstance, AbstractionPredicate> pLocationInstancePredicates, Multimap<CFANode, AbstractionPredicate> pLocalPredicates, Multimap<String, AbstractionPredicate> pFunctionPredicates, Iterable<AbstractionPredicate> pGlobalPredicates) {
        this(pLocationInstancePredicates.entries(), pLocalPredicates.entries(), pFunctionPredicates.entries(), pGlobalPredicates);
    }

    private PredicatePrecision(Iterable<Map.Entry<LocationInstance, AbstractionPredicate>> pLocationInstancePredicates, Iterable<Map.Entry<CFANode, AbstractionPredicate>> pLocalPredicates, Iterable<Map.Entry<String, AbstractionPredicate>> pFunctionPredicates, Iterable<AbstractionPredicate> pGlobalPredicates) {
        this.mGlobalPredicates = ImmutableSet.copyOf(pGlobalPredicates);
        ListMultimap functionPredicates = MultimapBuilder.treeKeys().arrayListValues().build();
        PredicatePrecision.putAll(pFunctionPredicates, functionPredicates);
        for (Object function : functionPredicates.keySet()) {
            functionPredicates.putAll(function, this.mGlobalPredicates);
        }
        this.mFunctionPredicates = ImmutableSetMultimap.copyOf((Multimap)functionPredicates);
        ListMultimap localPredicates = MultimapBuilder.treeKeys().arrayListValues().build();
        PredicatePrecision.putAll(pLocalPredicates, localPredicates);
        for (CFANode node : localPredicates.keySet()) {
            localPredicates.putAll((Object)node, (Iterable)this.mFunctionPredicates.get((Object)node.getFunctionName()));
            localPredicates.putAll((Object)node, this.mGlobalPredicates);
        }
        this.mLocalPredicates = ImmutableSetMultimap.copyOf((Multimap)localPredicates);
        ListMultimap locationInstancePredicates = MultimapBuilder.treeKeys().arrayListValues().build();
        PredicatePrecision.putAll(pLocationInstancePredicates, locationInstancePredicates);
        for (LocationInstance location : locationInstancePredicates.keySet()) {
            locationInstancePredicates.putAll((Object)location, (Iterable)this.mLocalPredicates.get((Object)location.getLocation()));
            locationInstancePredicates.putAll((Object)location, (Iterable)this.mFunctionPredicates.get((Object)location.getFunctionName()));
            locationInstancePredicates.putAll((Object)location, this.mGlobalPredicates);
        }
        this.mLocationInstancePredicates = ImmutableSetMultimap.copyOf((Multimap)locationInstancePredicates);
    }

    private static <K, V> void putAll(Iterable<Map.Entry<K, V>> entries, Multimap<K, V> map) {
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static PredicatePrecision empty() {
        return EMPTY;
    }

    private static PredicatePrecision unionOf(Collection<PredicatePrecision> precisions) {
        if (precisions.isEmpty()) {
            return PredicatePrecision.empty();
        }
        if (precisions.size() == 1) {
            return (PredicatePrecision)Iterables.getOnlyElement(precisions);
        }
        return new PredicatePrecision((Iterable<Map.Entry<LocationInstance, AbstractionPredicate>>)FluentIterable.from(precisions).transformAndConcat(prec -> prec.getLocationInstancePredicates().entries()), (Iterable<Map.Entry<CFANode, AbstractionPredicate>>)FluentIterable.from(precisions).transformAndConcat(prec -> prec.getLocalPredicates().entries()), (Iterable<Map.Entry<String, AbstractionPredicate>>)FluentIterable.from(precisions).transformAndConcat(prec -> prec.getFunctionPredicates().entries()), (Iterable<AbstractionPredicate>)FluentIterable.from(precisions).transformAndConcat(prec -> prec.getGlobalPredicates()));
    }

    public static PredicatePrecision unionOf(Iterable<Precision> precisions) {
        Set distinctPrecisions = Sets.newIdentityHashSet();
        ArrayList<PredicatePrecision> orderedPrecisions = new ArrayList<PredicatePrecision>();
        for (Precision prec : precisions) {
            PredicatePrecision predicatePrec = Precisions.extractPrecisionByType(prec, PredicatePrecision.class);
            if (predicatePrec == EMPTY || !distinctPrecisions.add(predicatePrec)) continue;
            orderedPrecisions.add(predicatePrec);
        }
        assert (distinctPrecisions.size() == orderedPrecisions.size());
        return PredicatePrecision.unionOf(orderedPrecisions);
    }

    public ImmutableSetMultimap<LocationInstance, AbstractionPredicate> getLocationInstancePredicates() {
        return this.mLocationInstancePredicates;
    }

    public ImmutableSetMultimap<CFANode, AbstractionPredicate> getLocalPredicates() {
        return this.mLocalPredicates;
    }

    public ImmutableSetMultimap<String, AbstractionPredicate> getFunctionPredicates() {
        return this.mFunctionPredicates;
    }

    public ImmutableSet<AbstractionPredicate> getGlobalPredicates() {
        return this.mGlobalPredicates;
    }

    public ImmutableSet<AbstractionPredicate> getPredicates(CFANode loc, int locInstance) {
        return this.getPredicates(new LocationInstance(loc, locInstance));
    }

    public ImmutableSet<AbstractionPredicate> getPredicates(LocationInstance locationInstance) {
        ImmutableSet<AbstractionPredicate> result = this.getLocationInstancePredicates().get((Object)locationInstance);
        if (result.isEmpty()) {
            result = this.getLocalPredicates().get((Object)locationInstance.getLocation());
        }
        if (result.isEmpty()) {
            result = this.getFunctionPredicates().get((Object)locationInstance.getFunctionName());
        }
        if (result.isEmpty()) {
            result = this.getGlobalPredicates();
        }
        return result;
    }

    public PredicatePrecision addGlobalPredicates(Collection<AbstractionPredicate> newPredicates) {
        return new PredicatePrecision((Multimap<LocationInstance, AbstractionPredicate>)this.getLocationInstancePredicates(), (Multimap<CFANode, AbstractionPredicate>)this.getLocalPredicates(), (Multimap<String, AbstractionPredicate>)this.getFunctionPredicates(), (Iterable<AbstractionPredicate>)Iterables.concat(this.getGlobalPredicates(), newPredicates));
    }

    public PredicatePrecision addFunctionPredicates(Iterable<Map.Entry<String, AbstractionPredicate>> newPredicates) {
        if (Iterables.isEmpty(newPredicates)) {
            return this;
        }
        return new PredicatePrecision((Iterable<Map.Entry<LocationInstance, AbstractionPredicate>>)this.getLocationInstancePredicates().entries(), (Iterable<Map.Entry<CFANode, AbstractionPredicate>>)this.getLocalPredicates().entries(), Iterables.concat((Iterable)this.getFunctionPredicates().entries(), newPredicates), (Iterable<AbstractionPredicate>)this.getGlobalPredicates());
    }

    public PredicatePrecision addLocalPredicates(Iterable<Map.Entry<CFANode, AbstractionPredicate>> newPredicates) {
        if (Iterables.isEmpty(newPredicates)) {
            return this;
        }
        return new PredicatePrecision((Iterable<Map.Entry<LocationInstance, AbstractionPredicate>>)this.getLocationInstancePredicates().entries(), Iterables.concat((Iterable)this.getLocalPredicates().entries(), newPredicates), (Iterable<Map.Entry<String, AbstractionPredicate>>)this.getFunctionPredicates().entries(), (Iterable<AbstractionPredicate>)this.getGlobalPredicates());
    }

    public PredicatePrecision addLocationInstancePredicates(Iterable<Map.Entry<LocationInstance, AbstractionPredicate>> newPredicates) {
        if (Iterables.isEmpty(newPredicates)) {
            return this;
        }
        return new PredicatePrecision(Iterables.concat((Iterable)this.getLocationInstancePredicates().entries(), newPredicates), (Iterable<Map.Entry<CFANode, AbstractionPredicate>>)this.getLocalPredicates().entries(), (Iterable<Map.Entry<String, AbstractionPredicate>>)this.getFunctionPredicates().entries(), (Iterable<AbstractionPredicate>)this.getGlobalPredicates());
    }

    public PredicatePrecision mergeWith(PredicatePrecision prec) {
        if (this == prec || this.isEmpty()) {
            return prec;
        }
        if (prec.isEmpty()) {
            return this;
        }
        return new PredicatePrecision(Iterables.concat((Iterable)this.getLocationInstancePredicates().entries(), (Iterable)prec.getLocationInstancePredicates().entries()), Iterables.concat((Iterable)this.getLocalPredicates().entries(), (Iterable)prec.getLocalPredicates().entries()), Iterables.concat((Iterable)this.getFunctionPredicates().entries(), (Iterable)prec.getFunctionPredicates().entries()), (Iterable<AbstractionPredicate>)Iterables.concat(this.getGlobalPredicates(), prec.getGlobalPredicates()));
    }

    public int calculateDifferenceTo(PredicatePrecision other) {
        int difference = 0;
        difference += Sets.difference(this.getGlobalPredicates(), other.getGlobalPredicates()).size();
        difference += Sets.difference((Set)this.getFunctionPredicates().entries(), (Set)other.getFunctionPredicates().entries()).size();
        difference += Sets.difference((Set)this.getLocalPredicates().entries(), (Set)other.getLocalPredicates().entries()).size();
        return difference += Sets.difference((Set)this.getLocationInstancePredicates().entries(), (Set)other.getLocationInstancePredicates().entries()).size();
    }

    @Override
    public boolean isEmpty() {
        return this.getGlobalPredicates().isEmpty() && this.getFunctionPredicates().isEmpty() && this.getLocalPredicates().isEmpty() && this.getLocationInstancePredicates().isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.getGlobalPredicates(), this.getFunctionPredicates(), this.getLocalPredicates(), this.getLocationInstancePredicates());
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (pObj == null) {
            return false;
        }
        if (!pObj.getClass().equals(this.getClass())) {
            return false;
        }
        PredicatePrecision other = (PredicatePrecision)pObj;
        return this.getLocationInstancePredicates().equals(other.getLocationInstancePredicates()) && this.getLocalPredicates().equals(other.getLocalPredicates()) && this.getFunctionPredicates().equals(other.getFunctionPredicates()) && this.getGlobalPredicates().equals(other.getGlobalPredicates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.getGlobalPredicates().isEmpty()) {
            sb.append("global predicates: ");
            sb.append(this.getGlobalPredicates());
        }
        if (!this.getFunctionPredicates().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("function predicates: ");
            sb.append(this.getFunctionPredicates());
        }
        if (!this.getLocalPredicates().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("local predicates: ");
            sb.append(this.getLocalPredicates());
        }
        if (!this.getLocationInstancePredicates().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("location-instance predicates: ");
            sb.append(this.getLocationInstancePredicates());
        }
        if (sb.length() == 0) {
            return "empty";
        }
        return sb.toString();
    }

    @Override
    public AdjustablePrecision add(AdjustablePrecision pOtherPrecision) {
        Preconditions.checkArgument((boolean)(pOtherPrecision instanceof PredicatePrecision));
        return this.mergeWith((PredicatePrecision)pOtherPrecision);
    }

    @Override
    public AdjustablePrecision subtract(AdjustablePrecision pOtherPrecision) {
        Preconditions.checkArgument((boolean)(pOtherPrecision instanceof PredicatePrecision));
        PredicatePrecision other = (PredicatePrecision)pOtherPrecision;
        return new PredicatePrecision((Iterable<Map.Entry<LocationInstance, AbstractionPredicate>>)Sets.difference((Set)this.mLocationInstancePredicates.entries(), (Set)other.getLocationInstancePredicates().entries()), (Iterable<Map.Entry<CFANode, AbstractionPredicate>>)Sets.difference((Set)this.mLocalPredicates.entries(), (Set)other.getLocalPredicates().entries()), (Iterable<Map.Entry<String, AbstractionPredicate>>)Sets.difference((Set)this.mFunctionPredicates.entries(), (Set)other.getFunctionPredicates().entries()), (Iterable<AbstractionPredicate>)Sets.difference(this.getGlobalPredicates(), other.getGlobalPredicates()));
    }

    public static final class LocationInstance
    implements Comparable<LocationInstance> {
        private final CFANode location;
        private final int instance;

        public LocationInstance(CFANode pLocation, int pInstance) {
            this.location = (CFANode)Preconditions.checkNotNull((Object)pLocation);
            Preconditions.checkArgument((pInstance >= 0 ? 1 : 0) != 0, (String)"Invalid LocationInstance with negative count %s", (int)pInstance);
            this.instance = pInstance;
        }

        public CFANode getLocation() {
            return this.location;
        }

        public int getInstance() {
            return this.instance;
        }

        public String getFunctionName() {
            return this.location.getFunctionName();
        }

        public int hashCode() {
            return 31 + this.instance + this.location.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocationInstance)) {
                return false;
            }
            LocationInstance other = (LocationInstance)obj;
            return this.instance == other.instance && this.location.equals(other.location);
        }

        @Override
        public int compareTo(LocationInstance other) {
            return ComparisonChain.start().compare((Comparable)this.location, (Comparable)other.location).compare(this.instance, other.instance).result();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.location).add("instance", this.instance).toString();
        }
    }
}

