/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPAInvariantsManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateProvider;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStatistics;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class PredicatePrecisionAdjustment
implements PrecisionAdjustment {
    private final LogManager logger;
    private final BlockOperator blk;
    private final PredicateAbstractionManager formulaManager;
    private final PathFormulaManager pathFormulaManager;
    private final FormulaManagerView fmgr;
    private final PredicateCPAInvariantsManager invariants;
    private final PredicateProvider predicateProvider;
    private final PredicateStatistics statistics;
    private final ThreadSafeTimerContainer.TimerWrapper totalPrecTime;
    private final ThreadSafeTimerContainer.TimerWrapper computingAbstractionTime;

    public PredicatePrecisionAdjustment(LogManager pLogger, FormulaManagerView pFmgr, PathFormulaManager pPfmgr, BlockOperator pBlk, PredicateAbstractionManager pPredAbsManager, PredicateCPAInvariantsManager pInvariantSupplier, PredicateProvider pPredicateProvider, PredicateStatistics pPredicateStatistics) {
        this.logger = pLogger;
        this.fmgr = pFmgr;
        this.pathFormulaManager = pPfmgr;
        this.blk = pBlk;
        this.formulaManager = pPredAbsManager;
        this.invariants = pInvariantSupplier;
        this.predicateProvider = pPredicateProvider;
        this.statistics = pPredicateStatistics;
        this.totalPrecTime = this.statistics.totalPrecTime.getNewTimer();
        this.computingAbstractionTime = this.statistics.computingAbstractionTime.getNewTimer();
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        this.totalPrecTime.start();
        try {
            PredicateAbstractState element = (PredicateAbstractState)pElement;
            ImmutableList locations = ImmutableList.copyOf(AbstractStates.extractLocations(fullState));
            for (CFANode location : locations) {
                if (!this.shouldComputeAbstraction(fullState, location, element)) continue;
                PredicatePrecision precision = (PredicatePrecision)pPrecision;
                Optional<PrecisionAdjustmentResult> optional = this.computeAbstraction(element, precision, (Collection<CFANode>)locations, fullState);
                return optional;
            }
            Optional<PrecisionAdjustmentResult> optional = Optional.of(PrecisionAdjustmentResult.create(element, pPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
            return optional;
        }
        catch (SolverException e) {
            throw new CPAException("Solver Failure: " + e.getMessage(), e);
        }
        finally {
            this.totalPrecTime.stop();
        }
    }

    private boolean shouldComputeAbstraction(AbstractState fullState, CFANode location, PredicateAbstractState predicateState) {
        if (predicateState.isAbstractionState()) {
            return false;
        }
        if (predicateState instanceof PredicateAbstractState.InfeasibleDummyState) {
            return false;
        }
        if (this.blk.isBlockEnd(location, predicateState.getPathFormula().getLength())) {
            return true;
        }
        if (AbstractStates.isTargetState(fullState)) {
            this.statistics.numTargetAbstractions.inc();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<PrecisionAdjustmentResult> computeAbstraction(PredicateAbstractState element, PredicatePrecision precision, Collection<CFANode> pLocations, AbstractState fullState) throws SolverException, CPAException, InterruptedException {
        AbstractionFormula abstractionFormula = element.getAbstractionFormula();
        PersistentMap abstractionLocations = element.getAbstractionLocationsOnPath();
        PathFormula pathFormula = element.getPathFormula();
        Optional<CallstackStateEqualsWrapper> callstackWrapper = AbstractStates.extractOptionalCallstackWraper(fullState);
        this.statistics.numAbstractions.inc();
        this.logger.log(Level.FINEST, new Object[]{"Computing abstraction at node", pLocations, "in path."});
        this.statistics.blockSize.setNextValue(pathFormula.getLength());
        this.invariants.updateGlobalInvariants();
        ArrayList<BooleanFormula> invariantFormulas = new ArrayList<BooleanFormula>();
        for (CFANode loc : pLocations) {
            if (!this.invariants.appendToPathFormula()) continue;
            BooleanFormula invariant = this.fmgr.instantiate(this.invariants.getInvariantFor(loc, callstackWrapper, this.fmgr, this.pathFormulaManager, pathFormula), pathFormula.getSsa());
            invariantFormulas.add(invariant);
        }
        BooleanFormula invariant = this.fmgr.getBooleanFormulaManager().and(invariantFormulas);
        if (!this.fmgr.getBooleanFormulaManager().isTrue(invariant)) {
            pathFormula = this.pathFormulaManager.makeAnd(pathFormula, invariant);
        }
        Set<AbstractionPredicate> additionalPredicates = this.predicateProvider.getPredicates(fullState);
        AbstractionFormula newAbstractionFormula = null;
        this.computingAbstractionTime.start();
        try {
            for (CFANode loc : pLocations) {
                Integer newLocInstance = (Integer)abstractionLocations.getOrDefault((Object)loc, (Object)0) + 1;
                additionalPredicates.addAll((Collection<AbstractionPredicate>)precision.getPredicates(loc, newLocInstance));
                abstractionLocations = abstractionLocations.putAndCopy((Object)loc, (Object)newLocInstance);
            }
            newAbstractionFormula = this.formulaManager.buildAbstraction(pLocations, callstackWrapper, abstractionFormula, pathFormula, additionalPredicates);
        }
        finally {
            this.computingAbstractionTime.stop();
        }
        if (newAbstractionFormula.isFalse()) {
            this.statistics.numAbstractionsFalse.inc();
            this.logger.log(Level.FINEST, new Object[]{"Abstraction is false, node is not reachable"});
            return Optional.empty();
        }
        PathFormula newPathFormula = this.pathFormulaManager.makeEmptyPathFormulaWithContextFrom(pathFormula);
        if (!this.fmgr.getBooleanFormulaManager().isTrue(invariant)) {
            newPathFormula = this.pathFormulaManager.makeAnd(newPathFormula, invariant);
        }
        PredicateAbstractState state = PredicateAbstractState.mkAbstractionState(newPathFormula, newAbstractionFormula, (PersistentMap<CFANode, Integer>)abstractionLocations, element.getPreviousAbstractionState());
        return Optional.of(PrecisionAdjustmentResult.create(state, precision, PrecisionAdjustmentResult.Action.CONTINUE));
    }
}

