/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.ExpressionTreeLocationInvariant;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonGraphmlParser;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateMapParser;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.WitnessInvariantsExtractor;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;
import org.sosy_lab.cpachecker.util.expressions.ToFormulaVisitor;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.Converter;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.KeyValueStatistics;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="cpa.predicate")
public class PredicatePrecisionBootstrapper
implements StatisticsProvider {
    @Option(secure=true, name="abstraction.initialPredicates", description="get an initial map of predicates from a list of files (see source doc/examples/predmap.txt for an example)")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> predicatesFiles = ImmutableList.of();
    @Option(secure=true, description="always check satisfiability at end of block, even if precision is empty")
    private boolean checkBlockFeasibility = false;
    private final FormulaManagerView formulaManagerView;
    private final AbstractionManager abstractionManager;
    private final Configuration config;
    private final LogManager logger;
    private final CFA cfa;
    private final ShutdownNotifier shutdownNotifier;
    private final PathFormulaManager pathFormulaManager;
    private final PredicateAbstractionManager predicateAbstractionManager;
    private final KeyValueStatistics statistics = new KeyValueStatistics();
    private final InitialPredicatesOptions options;

    public PredicatePrecisionBootstrapper(Configuration config, LogManager logger, CFA cfa, AbstractionManager abstractionManager, FormulaManagerView formulaManagerView, ShutdownNotifier shutdownNotifier, PathFormulaManager pathFormulaManager, PredicateAbstractionManager predicateAbstractionManager) throws InvalidConfigurationException {
        this.config = config;
        this.logger = logger;
        this.cfa = cfa;
        this.abstractionManager = abstractionManager;
        this.formulaManagerView = formulaManagerView;
        this.shutdownNotifier = shutdownNotifier;
        this.pathFormulaManager = pathFormulaManager;
        this.predicateAbstractionManager = predicateAbstractionManager;
        config.inject((Object)this);
        this.options = new InitialPredicatesOptions();
        config.inject((Object)this.options);
    }

    private PredicatePrecision internalPrepareInitialPredicates() throws InvalidConfigurationException, InterruptedException {
        PredicatePrecision result = PredicatePrecision.empty();
        if (this.checkBlockFeasibility) {
            result = result.addGlobalPredicates(Collections.singleton(this.abstractionManager.makeFalsePredicate()));
        }
        if (!this.predicatesFiles.isEmpty()) {
            PredicateMapParser parser = new PredicateMapParser(this.cfa, this.logger, this.formulaManagerView, this.abstractionManager, this.options);
            for (Path predicatesFile : this.predicatesFiles) {
                try {
                    IO.checkReadableFile((Path)predicatesFile);
                    if (AutomatonGraphmlParser.isGraphmlAutomatonFromConfiguration(predicatesFile)) {
                        switch (AutomatonGraphmlParser.getWitnessType(predicatesFile)) {
                            case CORRECTNESS_WITNESS: {
                                result = result.mergeWith(this.parseInvariantsFromCorrectnessWitnessAsPredicates(predicatesFile));
                                break;
                            }
                            case VIOLATION_WITNESS: {
                                this.logger.log(Level.WARNING, new Object[]{"Invariants do not exist in a violaton witness"});
                            }
                        }
                        continue;
                    }
                    result = result.mergeWith(parser.parsePredicates(predicatesFile));
                }
                catch (IOException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read predicate precision from file");
                }
                catch (PredicatePersistenceUtils.PredicateParsingFailedException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read predicate map");
                }
            }
        }
        return result;
    }

    private PredicatePrecision parseInvariantsFromCorrectnessWitnessAsPredicates(Path pWitnessFile) throws InterruptedException {
        PredicatePrecision result = PredicatePrecision.empty();
        try {
            WitnessInvariantsExtractor extractor = new WitnessInvariantsExtractor(this.config, this.logger, this.cfa, this.shutdownNotifier, pWitnessFile);
            Set<ExpressionTreeLocationInvariant> invariants = extractor.extractInvariantsFromReachedSet();
            boolean wereAnyPredicatesLoaded = false;
            for (ExpressionTreeLocationInvariant invariant : invariants) {
                boolean applyLocally;
                ListMultimap localPredicates = MultimapBuilder.treeKeys().arrayListValues().build();
                HashSet<AbstractionPredicate> globalPredicates = new HashSet<AbstractionPredicate>();
                ListMultimap functionPredicates = MultimapBuilder.treeKeys().arrayListValues().build();
                ArrayList<AbstractionPredicate> predicates = new ArrayList<AbstractionPredicate>();
                if (this.options.splitIntoAtoms) {
                    predicates.addAll((Collection<AbstractionPredicate>)this.splitToPredicates(invariant));
                } else {
                    predicates.add(this.abstractionManager.makePredicate(invariant.getFormula(this.formulaManagerView, this.pathFormulaManager, null)));
                }
                for (AbstractionPredicate predicate : predicates) {
                    localPredicates.put((Object)invariant.getLocation(), (Object)predicate);
                    globalPredicates.add(predicate);
                    functionPredicates.put((Object)invariant.getLocation().getFunctionName(), (Object)predicate);
                }
                wereAnyPredicatesLoaded |= !predicates.isEmpty();
                boolean bl = applyLocally = this.options.applyFunctionWide == this.options.applyGlobally;
                if (applyLocally) {
                    result = result.addLocalPredicates(localPredicates.entries());
                    continue;
                }
                if (this.options.applyFunctionWide) {
                    result = result.addFunctionPredicates(functionPredicates.entries());
                    continue;
                }
                if (!this.options.applyGlobally) continue;
                result = result.addGlobalPredicates(globalPredicates);
            }
            if (!invariants.isEmpty() && !wereAnyPredicatesLoaded) {
                this.logger.log(Level.WARNING, new Object[]{"Predicate from correctness witness invariants could not be computed.They are present, but are not correctly loaded"});
            }
        }
        catch (InvalidConfigurationException | CPAException e) {
            this.logger.logUserException(Level.WARNING, e, "Predicate from correctness witness invariants could not be computed");
        }
        return result;
    }

    private ImmutableSet<AbstractionPredicate> splitToPredicates(ExpressionTreeLocationInvariant pInvariant) throws CPATransferException, InterruptedException {
        Collection<ExpressionTree<AExpression>> atoms = this.splitTree(pInvariant);
        ImmutableSet.Builder predicates = ImmutableSet.builder();
        for (ExpressionTree<AExpression> atom : atoms) {
            predicates.addAll(this.predicateAbstractionManager.getPredicatesForAtomsOf(this.toFormula(atom)));
        }
        return predicates.build();
    }

    private BooleanFormula toFormula(ExpressionTree<AExpression> expressionTree) throws CPATransferException, InterruptedException {
        ToFormulaVisitor toFormulaVisitor = new ToFormulaVisitor(this.formulaManagerView, this.pathFormulaManager, null);
        try {
            return expressionTree.accept(toFormulaVisitor);
        }
        catch (ToFormulaVisitor.ToFormulaException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), CPATransferException.class, InterruptedException.class);
            throw new Classes.UnexpectedCheckedException("expression tree to formula", (Throwable)e);
        }
    }

    private Collection<ExpressionTree<AExpression>> splitTree(ExpressionTreeLocationInvariant pInvariant) {
        return this.split(this.cast(pInvariant.asExpressionTree()));
    }

    private <LeafType> ExpressionTree<LeafType> cast(ExpressionTree<Object> toCast) {
        return toCast;
    }

    private Collection<ExpressionTree<AExpression>> split(ExpressionTree<AExpression> pExpr) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.split0(pExpr, (ImmutableSet.Builder<ExpressionTree<AExpression>>)builder);
        return builder.build();
    }

    private void split0(ExpressionTree<AExpression> pExpr, ImmutableSet.Builder<ExpressionTree<AExpression>> pSetBuilder) {
        if (pExpr instanceof And) {
            ((And)pExpr).forEach(conj -> this.split0((ExpressionTree<AExpression>)conj, pSetBuilder));
        } else if (pExpr instanceof Or) {
            ((Or)pExpr).forEach(conj -> this.split0((ExpressionTree<AExpression>)conj, pSetBuilder));
        } else if (pExpr instanceof LeafExpression) {
            pSetBuilder.add(pExpr);
        } else {
            throw new AssertionError((Object)("Unhandled expression type: " + pExpr.getClass()));
        }
    }

    public PredicatePrecision prepareInitialPredicates() throws InvalidConfigurationException, InterruptedException {
        PredicatePrecision result = this.internalPrepareInitialPredicates();
        this.statistics.addKeyValueStatistic("Init. global predicates", result.getGlobalPredicates().size());
        this.statistics.addKeyValueStatistic("Init. location predicates", result.getLocalPredicates().size());
        this.statistics.addKeyValueStatistic("Init. function predicates", result.getFunctionPredicates().size());
        return result;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    @Options(prefix="cpa.predicate.abstraction.initialPredicates")
    public static class InitialPredicatesOptions {
        @Option(secure=true, description="Apply location-specific predicates to all locations in their function")
        private boolean applyFunctionWide = false;
        @Option(secure=true, description="Apply location- and function-specific predicates globally (to all locations in the program)")
        private boolean applyGlobally = false;
        @Option(secure=true, description="when reading predicates from file, convert them from Integer- to BV-theory or reverse.")
        private Converter.PrecisionConverter encodePredicates = Converter.PrecisionConverter.DISABLE;
        @Option(secure=true, description="initial predicates are added as atomic predicates")
        private boolean splitIntoAtoms = false;

        public boolean applyFunctionWide() {
            return this.applyFunctionWide;
        }

        public boolean applyGlobally() {
            return this.applyGlobally;
        }

        public Converter.PrecisionConverter getPrecisionConverter() {
            return this.encodePredicates;
        }
    }
}

