/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.argReplay.ARGReplayState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateAbstractionsStorage;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.Converter;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.FormulaParser;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="cpa.predicate")
public class PredicateProvider {
    @Option(secure=true, description="try to reuse old abstractions from file during strengthening")
    private boolean strengthenWithReusedAbstractions = false;
    @Option(description="file that consists of old abstractions, to be used during strengthening")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path strengthenWithReusedAbstractionsFile = Path.of("abstractions.txt", new String[0]);
    private final CFA cfa;
    private final LogManager logger;
    private final FormulaManagerView fmgr;
    private final PredicateAbstractionManager predFmgr;
    private Multimap<Integer, BooleanFormula> abstractions = null;

    PredicateProvider(Configuration config, CFA pCfa, LogManager pLogger, FormulaManagerView pFmgr, PredicateAbstractionManager pPredMgr) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cfa = pCfa;
        this.logger = pLogger;
        this.fmgr = pFmgr;
        this.predFmgr = pPredMgr;
    }

    public Set<AbstractionPredicate> getPredicates(AbstractState pFullState) throws CPATransferException {
        HashSet<AbstractionPredicate> result = new HashSet<AbstractionPredicate>();
        if (this.strengthenWithReusedAbstractions) {
            CFANode location = AbstractStates.extractLocation(pFullState);
            result.addAll(this.getPredicatesFromAbstractionFromFile(location));
        }
        for (ARGReplayState state : AbstractStates.asIterable(pFullState).filter(ARGReplayState.class)) {
            result.addAll(this.getPredicatesFromState(state));
        }
        return result;
    }

    private Set<AbstractionPredicate> getPredicatesFromAbstractionFromFile(CFANode pLocation) throws CPATransferException {
        if (this.abstractions == null) {
            PredicateAbstractionsStorage abstractionStorage;
            Converter converter = Converter.getConverter(Converter.PrecisionConverter.INT2BV, this.cfa, this.logger);
            try {
                abstractionStorage = new PredicateAbstractionsStorage(this.strengthenWithReusedAbstractionsFile, this.logger, this.fmgr, converter);
            }
            catch (PredicatePersistenceUtils.PredicateParsingFailedException e) {
                throw new CPATransferException("cannot read abstractions from file, parsing fail", e);
            }
            this.abstractions = HashMultimap.create();
            for (PredicateAbstractionsStorage.AbstractionNode absNode : abstractionStorage.getAbstractions().values()) {
                OptionalInt location = absNode.getLocationId();
                if (!location.isPresent()) continue;
                this.abstractions.put((Object)location.orElseThrow(), (Object)absNode.getFormula());
            }
        }
        HashSet<AbstractionPredicate> result = new HashSet<AbstractionPredicate>();
        for (BooleanFormula possibleConstraint : this.abstractions.get((Object)pLocation.getNodeNumber())) {
            result.addAll((Collection<AbstractionPredicate>)this.predFmgr.getPredicatesForAtomsOf(possibleConstraint));
        }
        return result;
    }

    private Set<AbstractionPredicate> getPredicatesFromState(ARGReplayState state) {
        HashSet<AbstractionPredicate> result = new HashSet<AbstractionPredicate>();
        for (ARGState innerState : state.getStates()) {
            PredicateAbstractState oldPredicateState = AbstractStates.extractStateByType(innerState, PredicateAbstractState.class);
            if (oldPredicateState == null || !oldPredicateState.isAbstractionState()) continue;
            PredicateCPA oldPredicateCPA = CPAs.retrieveCPA(state.getCPA(), PredicateCPA.class);
            result.addAll(this.getPredicatesFromAbstractionState(oldPredicateState, oldPredicateCPA));
        }
        return result;
    }

    private Collection<AbstractionPredicate> getPredicatesFromAbstractionState(PredicateAbstractState pOldPredicateState, PredicateCPA oldPredicateCPA) {
        StringBuilder in = new StringBuilder();
        Converter converter = Converter.getConverter(Converter.PrecisionConverter.INT2BV, this.cfa, this.logger);
        Appender app = oldPredicateCPA.getSolver().getFormulaManager().dumpFormula(pOldPredicateState.getAbstractionFormula().asFormula());
        try {
            app.appendTo((Appendable)in);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        LogManagerWithoutDuplicates logger2 = new LogManagerWithoutDuplicates(this.logger);
        StringBuilder out = new StringBuilder();
        for (String line : Splitter.on((char)'\n').split((CharSequence)in)) {
            line = FormulaParser.convertFormula((Converter)Preconditions.checkNotNull((Object)converter), line, logger2);
            if (line == null) continue;
            out.append(line).append("\n");
        }
        BooleanFormula constraint = this.fmgr.parse(out.toString());
        return this.predFmgr.getPredicatesForAtomsOf(constraint);
    }
}

