/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefiner;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.StaticRefiner;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="staticRefiner")
public class PredicateStaticRefiner
extends StaticRefiner
implements ARGBasedRefiner,
StatisticsProvider {
    @Option(secure=true, description="Apply mined predicates on the corresponding scope. false = add them to the global precision.")
    private boolean applyScoped = true;
    @Option(secure=true, description="Add all assumptions along a error trace to the precision.")
    private boolean addAllErrorTraceAssumes = false;
    @Option(secure=true, description="Add all assumptions from the control flow automaton to the precision.")
    private boolean addAllControlFlowAssumes = false;
    @Option(secure=true, description="Add all assumptions along the error trace to the precision.")
    private boolean addAssumesByBoundedBackscan = true;
    @Option(secure=true, description="Dump CFA assume edges as SMTLIB2 formulas to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path assumePredicatesFile = null;
    @Option(secure=true, description="split generated heuristic predicates into atoms")
    private boolean atomicPredicates = true;
    private final StatTimer totalTime = new StatTimer("Total time for static refinement");
    private final StatTimer satCheckTime = new StatTimer("Time for path feasibility check");
    private final StatTimer predicateExtractionTime = new StatTimer("Time for predicate extraction from CFA");
    private final StatTimer argUpdateTime = new StatTimer("Time for ARG update");
    private final StatTimer errorPathProcessing = new StatTimer("Error-path post-processing");
    private final StatInt foundPredicates = new StatInt(StatKind.SUM, "Number of predicates found statically");
    private final ShutdownNotifier shutdownNotifier;
    private final PathFormulaManager pathFormulaManager;
    private final FormulaManagerView formulaManagerView;
    private final BooleanFormulaManager booleanManager;
    private final PredicateAbstractionManager predAbsManager;
    private final BlockFormulaStrategy blockFormulaStrategy;
    private final InterpolationManager itpManager;
    private final PathChecker pathChecker;
    private final Solver solver;
    private final CFA cfa;
    private final ARGBasedRefiner delegate;
    private boolean usedStaticRefinement = false;

    public PredicateStaticRefiner(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Solver pSolver, PathFormulaManager pPathFormulaManager, PredicateAbstractionManager pPredAbsManager, BlockFormulaStrategy pBlockFormulaStrategy, InterpolationManager pItpManager, PathChecker pPathChecker, CFA pCfa, ARGBasedRefiner pDelegate) throws InvalidConfigurationException {
        super(pConfig, pLogger);
        pConfig.inject((Object)this);
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.pathFormulaManager = pPathFormulaManager;
        this.predAbsManager = pPredAbsManager;
        this.blockFormulaStrategy = pBlockFormulaStrategy;
        this.itpManager = pItpManager;
        this.pathChecker = pPathChecker;
        this.solver = pSolver;
        this.formulaManagerView = pSolver.getFormulaManager();
        this.booleanManager = this.formulaManagerView.getBooleanFormulaManager();
        this.delegate = pDelegate;
        if (this.assumePredicatesFile != null) {
            this.dumpAssumePredicate(this.assumePredicatesFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet pReached, ARGPath allStatesTrace) throws CPAException, InterruptedException {
        if (this.usedStaticRefinement) {
            return this.delegate.performRefinementForPath(pReached, allStatesTrace);
        }
        this.totalTime.start();
        try {
            CounterexampleInfo counterexampleInfo = this.performStaticRefinementForPath(pReached, allStatesTrace);
            return counterexampleInfo;
        }
        finally {
            this.totalTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CounterexampleInfo performStaticRefinementForPath(ARGReachedSet pReached, ARGPath allStatesTrace) throws CPAException, InterruptedException {
        CounterexampleTraceInfo counterexample;
        this.logger.log(Level.FINEST, new Object[]{"Starting heuristics-based refinement."});
        List<ARGState> abstractionStatesTrace = PredicateCPARefiner.filterAbstractionStates(allStatesTrace);
        BlockFormulaStrategy.BlockFormulas formulas = this.blockFormulaStrategy.getFormulasForPath(allStatesTrace.getFirstState(), abstractionStatesTrace);
        this.satCheckTime.start();
        try {
            counterexample = this.itpManager.buildCounterexampleTraceWithoutInterpolation(formulas, Optional.of(allStatesTrace));
        }
        finally {
            this.satCheckTime.stop();
        }
        if (counterexample.isSpurious()) {
            PredicatePrecision heuristicPrecision;
            this.logger.log(Level.FINEST, new Object[]{"Error trace is spurious, refining the abstraction"});
            this.usedStaticRefinement = true;
            UnmodifiableReachedSet reached = pReached.asReachedSet();
            ARGState root = (ARGState)reached.getFirstState();
            ARGState targetState = abstractionStatesTrace.get(abstractionStatesTrace.size() - 1);
            this.predicateExtractionTime.start();
            try {
                heuristicPrecision = this.extractPrecisionFromCfa(pReached.asReachedSet(), targetState);
            }
            catch (CPATransferException | SolverException e) {
                throw new RefinementFailedException(RefinementFailedException.Reason.StaticRefinementFailed, allStatesTrace, e);
            }
            finally {
                this.predicateExtractionTime.stop();
            }
            PredicatePrecision basePrecision = Precisions.extractPrecisionByType(pReached.asReachedSet().getPrecision(root), PredicatePrecision.class);
            PredicatePrecision newPrecision = basePrecision.mergeWith(heuristicPrecision);
            this.shutdownNotifier.shutdownIfNecessary();
            this.argUpdateTime.start();
            for (ARGState refinementRoot : ImmutableList.copyOf(root.getChildren())) {
                pReached.removeSubtree(refinementRoot, newPrecision, (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
            }
            this.argUpdateTime.stop();
            return CounterexampleInfo.spurious();
        }
        this.logger.log(Level.FINEST, new Object[]{"Error trace is not spurious"});
        this.errorPathProcessing.start();
        try {
            CounterexampleInfo counterexampleInfo = this.pathChecker.handleFeasibleCounterexample(counterexample, allStatesTrace);
            return counterexampleInfo;
        }
        finally {
            this.errorPathProcessing.stop();
        }
    }

    private boolean isAssumeOnLoopVariable(AssumeEdge e) {
        Set<String> loopExitConditionVariables;
        if (!this.cfa.getLoopStructure().isPresent()) {
            return false;
        }
        ImmutableSet referenced = CFAUtils.getVariableNamesOfExpression((CExpression)e.getExpression()).toSet();
        return !Collections.disjoint(referenced, loopExitConditionVariables = this.cfa.getLoopStructure().orElseThrow().getLoopExitConditionVariables());
    }

    private Multimap<String, AStatementEdge> buildDirectlyAffectingStatements() {
        LinkedHashMultimap directlyAffectingStatements = LinkedHashMultimap.create();
        for (CFANode u : this.cfa.getAllNodes()) {
            Deque edgesToHandle = (Deque)CFAUtils.leavingEdges(u).copyInto(new ArrayDeque());
            while (!edgesToHandle.isEmpty()) {
                CAssignment assign;
                CStatementEdge stmtEdge;
                CFAEdge e = (CFAEdge)edgesToHandle.pop();
                if (!(e instanceof CStatementEdge) || !((stmtEdge = (CStatementEdge)e).getStatement() instanceof CAssignment) || !((assign = (CAssignment)stmtEdge.getStatement()).getLeftHandSide() instanceof CIdExpression)) continue;
                String variable = ((CIdExpression)assign.getLeftHandSide()).getDeclaration().getQualifiedName();
                directlyAffectingStatements.put((Object)variable, (Object)stmtEdge);
            }
        }
        return directlyAffectingStatements;
    }

    private boolean isContradicting(AssumeEdge assume, AStatementEdge stmt) throws SolverException, CPATransferException, InterruptedException {
        BooleanFormula assumeFormula;
        BooleanFormula stmtFormula = this.pathFormulaManager.makeAnd(this.pathFormulaManager.makeEmptyPathFormula(), stmt).getFormula();
        BooleanFormula query = this.formulaManagerView.uninstantiate(this.booleanManager.and(stmtFormula, assumeFormula = this.pathFormulaManager.makeAnd(this.pathFormulaManager.makeEmptyPathFormula(), assume).getFormula()));
        boolean contra = this.solver.isUnsat(query);
        if (contra) {
            this.logger.log(Level.INFO, new Object[]{"Contradiction found ", query});
        }
        return contra;
    }

    private boolean hasContradictingOperationInFlow(AssumeEdge e, Multimap<String, AStatementEdge> directlyAffectingStatements) throws SolverException, CPATransferException, InterruptedException {
        ImmutableSet referenced = CFAUtils.getVariableNamesOfExpression((CExpression)e.getExpression()).toSet();
        for (String varName : referenced) {
            Collection affectedByStmts = directlyAffectingStatements.get((Object)varName);
            for (AStatementEdge stmtEdge : affectedByStmts) {
                if (!this.isContradicting(e, stmtEdge)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<AssumeEdge> getAllNonLoopControlFlowAssumes(Multimap<String, AStatementEdge> directlyAffectingStatements) throws SolverException, CPATransferException, InterruptedException {
        HashSet<AssumeEdge> result = new HashSet<AssumeEdge>();
        for (CFANode u : this.cfa.getAllNodes()) {
            for (CFAEdge e : CFAUtils.leavingEdges(u)) {
                AssumeEdge assume;
                if (!(e instanceof AssumeEdge) || this.isAssumeOnLoopVariable(assume = (AssumeEdge)e) || !this.hasContradictingOperationInFlow(assume, directlyAffectingStatements)) continue;
                result.add(assume);
            }
        }
        return result;
    }

    private Set<AssumeEdge> getAssumeEdgesAlongPath(UnmodifiableReachedSet reached, ARGState targetState, Multimap<String, AStatementEdge> directlyAffectingStatements) throws SolverException, CPATransferException, InterruptedException {
        HashSet<AssumeEdge> result = new HashSet<AssumeEdge>();
        ImmutableSet<ARGState> allStatesOnPath = ARGUtils.getAllStatesOnPathsTo(targetState);
        for (ARGState s : allStatesOnPath) {
            CFANode u = AbstractStates.extractLocation(s);
            for (CFAEdge e : CFAUtils.leavingEdges(u)) {
                AssumeEdge assume;
                CFANode v = e.getSuccessor();
                Collection<AbstractState> reachedOnV = reached.getReached(v);
                boolean edgeOnTrace = false;
                for (AbstractState ve : reachedOnV) {
                    if (!allStatesOnPath.contains(ve)) continue;
                    edgeOnTrace = true;
                    break;
                }
                if (!edgeOnTrace || !(e instanceof AssumeEdge) || this.isAssumeOnLoopVariable(assume = (AssumeEdge)e) || !this.hasContradictingOperationInFlow(assume, directlyAffectingStatements)) continue;
                result.add(assume);
            }
        }
        return result;
    }

    private PredicatePrecision extractPrecisionFromCfa(UnmodifiableReachedSet pReached, ARGState targetState) throws SolverException, CPATransferException, InterruptedException {
        this.logger.log(Level.FINER, new Object[]{"Extracting precision from CFA..."});
        ArrayListMultimap functionPredicates = ArrayListMultimap.create();
        ArrayList<AbstractionPredicate> globalPredicates = new ArrayList<AbstractionPredicate>();
        Iterable<CFANode> targetLocations = AbstractStates.extractLocations(targetState);
        LinkedHashSet<AssumeEdge> assumeEdges = new LinkedHashSet<AssumeEdge>();
        Multimap<String, AStatementEdge> directlyAffectingStatements = this.buildDirectlyAffectingStatements();
        if (this.addAllControlFlowAssumes) {
            assumeEdges.addAll(this.getAllNonLoopControlFlowAssumes(directlyAffectingStatements));
        } else {
            if (this.addAllErrorTraceAssumes) {
                assumeEdges.addAll(this.getAssumeEdgesAlongPath(pReached, targetState, directlyAffectingStatements));
            }
            if (this.addAssumesByBoundedBackscan) {
                assumeEdges.addAll(this.getTargetLocationAssumes((Collection<CFANode>)ImmutableList.copyOf(targetLocations)).values());
            }
        }
        for (AssumeEdge assume : assumeEdges) {
            Collection<AbstractionPredicate> preds = this.assumeEdgeToPredicates(this.atomicPredicates, assume);
            boolean applyGlobal = true;
            if (this.applyScoped) {
                for (CIdExpression idExpr : CFAUtils.getIdExpressionsOfExpression((CExpression)assume.getExpression())) {
                    CSimpleDeclaration decl = idExpr.getDeclaration();
                    if (decl instanceof CVariableDeclaration) {
                        if (((CVariableDeclaration)decl).isGlobal()) continue;
                        applyGlobal = false;
                        continue;
                    }
                    if (!(decl instanceof CParameterDeclaration)) continue;
                    applyGlobal = false;
                }
            }
            if (applyGlobal) {
                this.logger.log(Level.FINEST, new Object[]{"Global predicates mined", preds});
                globalPredicates.addAll(preds);
                continue;
            }
            this.logger.log(Level.FINEST, new Object[]{"Function predicates mined", preds});
            String function = assume.getPredecessor().getFunctionName();
            functionPredicates.putAll((Object)function, preds);
        }
        HashSet allPredicates = new HashSet(globalPredicates);
        allPredicates.addAll(functionPredicates.values());
        this.foundPredicates.setNextValue(allPredicates.size());
        this.logger.log(Level.FINER, new Object[]{"Extracting finished, found", allPredicates.size(), "predicates"});
        return new PredicatePrecision((Multimap<PredicatePrecision.LocationInstance, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<CFANode, AbstractionPredicate>)ArrayListMultimap.create(), (Multimap<String, AbstractionPredicate>)functionPredicates, globalPredicates);
    }

    private Collection<AbstractionPredicate> assumeEdgeToPredicates(boolean pAtomicPredicates, AssumeEdge assume) throws CPATransferException, InterruptedException {
        BooleanFormula relevantAssumesFormula = this.pathFormulaManager.makeAnd(this.pathFormulaManager.makeEmptyPathFormula(), assume).getFormula();
        ImmutableList preds = pAtomicPredicates ? this.predAbsManager.getPredicatesForAtomsOf(relevantAssumesFormula) : ImmutableList.of((Object)this.predAbsManager.getPredicateFor(relevantAssumesFormula));
        return preds;
    }

    private void dumpAssumePredicate(Path target) {
        try (Writer w = IO.openOutputFile((Path)target, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            for (CFANode u : this.cfa.getAllNodes()) {
                for (CFAEdge e : CFAUtils.leavingEdges(u)) {
                    if (!(e instanceof AssumeEdge)) continue;
                    Collection<AbstractionPredicate> preds = this.assumeEdgeToPredicates(false, (AssumeEdge)e);
                    for (AbstractionPredicate p : preds) {
                        w.append(p.getSymbolicAtom().toString());
                        w.append("\n");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Interrupted, could not write assume predicates to file!");
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "IO exception! Could not write assume predicates to file!");
        }
        catch (CPATransferException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Transfer exception! Could not write assume predicates to file!");
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Stats());
        if (this.delegate instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.delegate)).collectStatistics(pStatsCollection);
        }
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter.writingStatisticsTo(pOut).ifUpdatedAtLeastOnce(PredicateStaticRefiner.this.totalTime).put(PredicateStaticRefiner.this.foundPredicates).spacer().put(PredicateStaticRefiner.this.totalTime).beginLevel().put(PredicateStaticRefiner.this.satCheckTime).putIfUpdatedAtLeastOnce(PredicateStaticRefiner.this.predicateExtractionTime).putIfUpdatedAtLeastOnce(PredicateStaticRefiner.this.argUpdateTime).putIfUpdatedAtLeastOnce(PredicateStaticRefiner.this.errorPathProcessing);
        }

        @Override
        public String getName() {
            return "Static Predicate Refiner";
        }
    }
}

