/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCpaOptions;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStatistics;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public final class PredicateTransferRelation
extends SingleEdgeTransferRelation {
    private final LogManager logger;
    private final PredicateAbstractionManager formulaManager;
    private final PathFormulaManager pathFormulaManager;
    private final BlockOperator blk;
    private final FormulaManagerView fmgr;
    private final AnalysisDirection direction;
    private final PredicateStatistics statistics;
    private final PredicateCpaOptions options;
    private final ThreadSafeTimerContainer.TimerWrapper postTimer;
    private final ThreadSafeTimerContainer.TimerWrapper satCheckTimer;
    private final ThreadSafeTimerContainer.TimerWrapper pathFormulaTimer;
    private final ThreadSafeTimerContainer.TimerWrapper strengthenTimer;
    private final ThreadSafeTimerContainer.TimerWrapper strengthenCheckTimer;
    private final ThreadSafeTimerContainer.TimerWrapper abstractionCheckTimer;

    public PredicateTransferRelation(LogManager pLogger, AnalysisDirection pDirection, FormulaManagerView pFmgr, PathFormulaManager pPfmgr, BlockOperator pBlk, PredicateAbstractionManager pPredAbsManager, PredicateStatistics pStatistics, PredicateCpaOptions pOptions) {
        this.logger = pLogger;
        this.formulaManager = pPredAbsManager;
        this.pathFormulaManager = pPfmgr;
        this.fmgr = pFmgr;
        this.blk = pBlk;
        this.direction = pDirection;
        this.statistics = pStatistics;
        this.options = pOptions;
        this.postTimer = this.statistics.postTimer.getNewTimer();
        this.satCheckTimer = this.statistics.satCheckTimer.getNewTimer();
        this.pathFormulaTimer = this.statistics.pathFormulaTimer.getNewTimer();
        this.strengthenTimer = this.statistics.strengthenTimer.getNewTimer();
        this.strengthenCheckTimer = this.statistics.strengthenCheckTimer.getNewTimer();
        this.abstractionCheckTimer = this.statistics.abstractionCheckTimer.getNewTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge edge) throws CPATransferException, InterruptedException {
        this.postTimer.start();
        try {
            PredicateAbstractState element = (PredicateAbstractState)pElement;
            if (element.getAbstractionFormula().isFalse()) {
                ImmutableSet immutableSet = ImmutableSet.of();
                return immutableSet;
            }
            PathFormula pathFormula = this.convertEdgeToPathFormula(element.getPathFormula(), edge);
            this.logger.log(Level.ALL, new Object[]{"New path formula is", pathFormula});
            boolean satCheck = this.shouldDoSatCheck(edge, pathFormula);
            this.logger.log(Level.FINEST, new Object[]{"Handling non-abstraction location", satCheck ? "with satisfiability check" : ""});
            try {
                if (satCheck && this.unsatCheck(element.getAbstractionFormula(), pathFormula)) {
                    ImmutableSet immutableSet = ImmutableSet.of();
                    return immutableSet;
                }
            }
            catch (SolverException e) {
                throw new CPATransferException("Solver failed during successor generation", e);
            }
            PredicateAbstractState successor = element.isAbstractionState() ? PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(pathFormula, element, element) : PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(pathFormula, element, element.getPreviousAbstractionState());
            Set<PredicateAbstractState> set = Collections.singleton(successor);
            return set;
        }
        finally {
            this.postTimer.stop();
        }
    }

    private boolean shouldDoSatCheck(CFAEdge edge, PathFormula pathFormula) {
        CFANode loc;
        if (this.options.getSatCheckBlockSize() > 0 && pathFormula.getLength() >= this.options.getSatCheckBlockSize()) {
            return true;
        }
        return this.options.satCheckAtAbstraction() && this.blk.isBlockEnd(loc = this.getAnalysisSuccessor(edge), pathFormula.getLength());
    }

    private CFANode getAnalysisSuccessor(CFAEdge pEdge) {
        if (this.direction == AnalysisDirection.BACKWARD) {
            return pEdge.getPredecessor();
        }
        return pEdge.getSuccessor();
    }

    private boolean unsatCheck(AbstractionFormula lastAbstraction, PathFormula pathFormulaFromLastAbstraction) throws SolverException, InterruptedException {
        this.satCheckTimer.start();
        boolean unsat = this.formulaManager.unsat(lastAbstraction, pathFormulaFromLastAbstraction);
        this.satCheckTimer.stop();
        if (unsat) {
            this.statistics.numSatChecksFalse.inc();
            this.logger.log(Level.FINEST, new Object[]{"Abstraction & PathFormula is unsatisfiable."});
        }
        return unsat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathFormula convertEdgeToPathFormula(PathFormula pathFormula, CFAEdge edge) throws CPATransferException, InterruptedException {
        this.pathFormulaTimer.start();
        try {
            PathFormula pathFormula2 = this.pathFormulaManager.makeAnd(pathFormula, edge);
            return pathFormula2;
        }
        finally {
            this.pathFormulaTimer.stop();
        }
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, Iterable<AbstractState> otherElements, CFAEdge edge, Precision pPrecision) throws CPATransferException, InterruptedException {
        this.strengthenTimer.start();
        try {
            Object object;
            PredicateAbstractState element = (PredicateAbstractState)pElement;
            if (element.isAbstractionState()) {
                Set<PredicateAbstractState> set = Collections.singleton(element);
                return set;
            }
            CFANode currentLocation = edge == null ? null : this.getAnalysisSuccessor(edge);
            boolean errorFound = false;
            for (AbstractState lElement : otherElements) {
                if (lElement instanceof AssumptionStorageState) {
                    element = this.strengthen(element, (AssumptionStorageState)lElement);
                }
                if (lElement instanceof ThreadingState) {
                    element = this.strengthen(element, (ThreadingState)lElement);
                }
                if (!this.options.ignoreStateAssumptions() && lElement instanceof AbstractStateWithAssumptions && (element = this.strengthen(element, (AbstractStateWithAssumptions)lElement, edge)) instanceof PredicateAbstractState.InfeasibleDummyState) {
                    ImmutableSet immutableSet = ImmutableSet.of((Object)element);
                    return immutableSet;
                }
                if (this.options.strengthenWithFormulaReportingStates() && lElement instanceof FormulaReportingState) {
                    element = this.strengthen(element, (FormulaReportingState)lElement);
                }
                if (!AbstractStates.isTargetState(lElement)) continue;
                errorFound = true;
            }
            if (errorFound && this.options.targetStateSatCheck() && (element = this.strengthenSatCheck(element, currentLocation)) == null) {
                object = ImmutableSet.of();
                return object;
            }
            object = Collections.singleton(element);
            return object;
        }
        catch (SolverException e) {
            throw new CPATransferException("Solver failed during strengthen sat check", e);
        }
        finally {
            this.strengthenTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PredicateAbstractState strengthen(PredicateAbstractState pElement, AbstractStateWithAssumptions pAssumeElement, CFAEdge pEdge) throws CPATransferException, InterruptedException, SolverException {
        PathFormula pf = pElement.getPathFormula();
        if (this.options.assumptionStrengtheningSatCheck()) {
            PathFormula f = this.pathFormulaManager.makeFormulaForPath(Collections.singletonList(pEdge));
            for (CExpression assumption : FluentIterable.from(pAssumeElement.getAssumptions()).filter(CExpression.class)) {
                f = this.pathFormulaManager.makeAnd(f, assumption);
            }
            AbstractionFormula dummy = this.formulaManager.makeTrueAbstractionFormula(f);
            if (this.formulaManager.unsat(dummy, f)) {
                return PredicateAbstractState.mkInfeasibleDummyState(f, dummy, pElement.getAbstractionLocationsOnPath());
            }
        }
        for (CExpression assumption : FluentIterable.from(pAssumeElement.getAssumptions()).filter(CExpression.class)) {
            if (CFAUtils.getIdExpressionsOfExpression(assumption).anyMatch(var -> var.getExpressionType() instanceof CProblemType) || assumption.getExpressionType() instanceof CProblemType) {
                this.logger.log(Level.INFO, new Object[]{"Ignoring assumption", assumption, "because of CProblemType"});
                continue;
            }
            this.pathFormulaTimer.start();
            try {
                pf = this.pathFormulaManager.makeAnd(pf, assumption);
            }
            finally {
                this.pathFormulaTimer.stop();
            }
        }
        if (pf != pElement.getPathFormula()) {
            return this.replacePathFormula(pElement, pf);
        }
        return pElement;
    }

    private PredicateAbstractState strengthen(PredicateAbstractState pElement, AssumptionStorageState pElement2) {
        if (pElement2.isAssumptionTrue() || pElement2.isAssumptionFalse()) {
            return pElement;
        }
        String asmpt = pElement2.getAssumptionAsString().toString();
        PathFormula pf = this.pathFormulaManager.makeAnd(pElement.getPathFormula(), this.fmgr.parse(asmpt));
        return this.replacePathFormula(pElement, pf);
    }

    private PredicateAbstractState strengthen(PredicateAbstractState pState, ThreadingState pThreadingState) throws CPATransferException, InterruptedException {
        FunctionCallEdge function = pThreadingState.getEntryFunction();
        if (function == null) {
            return pState;
        }
        PathFormula pathFormula = this.convertEdgeToPathFormula(pState.getPathFormula(), function);
        return this.replacePathFormula(pState, pathFormula);
    }

    private PredicateAbstractState strengthen(PredicateAbstractState pElement, FormulaReportingState pFormulaReportingState) {
        BooleanFormula formula = pFormulaReportingState.getFormulaApproximation(this.fmgr);
        BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
        if (bfmgr.isTrue(formula) || bfmgr.isFalse(formula)) {
            return pElement;
        }
        PathFormula previousPathFormula = pElement.getPathFormula();
        PathFormula newPathFormula = this.pathFormulaManager.makeAnd(previousPathFormula, formula);
        return this.replacePathFormula(pElement, newPathFormula);
    }

    private PredicateAbstractState replacePathFormula(PredicateAbstractState oldElement, PathFormula newPathFormula) {
        assert (!oldElement.isAbstractionState());
        return PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(newPathFormula, oldElement);
    }

    private PredicateAbstractState strengthenSatCheck(PredicateAbstractState pElement, CFANode loc) throws SolverException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Checking for feasibility of path because error has been found"});
        this.strengthenCheckTimer.start();
        PathFormula pathFormula = pElement.getPathFormula();
        boolean unsat = this.formulaManager.unsat(pElement.getAbstractionFormula(), pathFormula);
        this.strengthenCheckTimer.stop();
        if (unsat) {
            this.statistics.numStrengthenChecksFalse.inc();
            this.logger.log(Level.FINEST, new Object[]{"Path is infeasible."});
            return null;
        }
        this.logger.log(Level.FINEST, new Object[]{"Last part of the path is not infeasible."});
        AbstractionFormula abs = this.formulaManager.makeTrueAbstractionFormula(pathFormula);
        PathFormula newPathFormula = this.pathFormulaManager.makeEmptyPathFormulaWithContextFrom(pathFormula);
        PersistentMap abstractionLocations = pElement.getAbstractionLocationsOnPath();
        Integer newLocInstance = (Integer)abstractionLocations.getOrDefault((Object)loc, (Object)0) + 1;
        abstractionLocations = abstractionLocations.putAndCopy((Object)loc, (Object)newLocInstance);
        return PredicateAbstractState.mkAbstractionState(newPathFormula, abs, (PersistentMap<CFANode, Integer>)abstractionLocations);
    }

    boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors, Map<PredicateAbstractState, PathFormula> computedPathFormulae) throws SolverException, CPATransferException, InterruptedException {
        PredicateAbstractState predicateElement = (PredicateAbstractState)pElement;
        PathFormula pathFormula = computedPathFormulae.get(predicateElement);
        if (pathFormula == null) {
            pathFormula = this.pathFormulaManager.makeEmptyPathFormulaWithContextFrom(predicateElement.getPathFormula());
        }
        boolean result = true;
        if (pSuccessors.isEmpty()) {
            PathFormula pFormula = this.convertEdgeToPathFormula(pathFormula, pCfaEdge);
            if (!this.unsatCheck(predicateElement.getAbstractionFormula(), pFormula)) {
                result = false;
            }
            return result;
        }
        for (AbstractState abstractState : pSuccessors) {
            PredicateAbstractState successor = (PredicateAbstractState)abstractState;
            if (successor.isAbstractionState()) {
                pathFormula = this.convertEdgeToPathFormula(pathFormula, pCfaEdge);
                this.abstractionCheckTimer.start();
                if (!this.formulaManager.checkCoverage(predicateElement.getAbstractionFormula(), pathFormula, successor.getAbstractionFormula())) {
                    result = false;
                }
                this.abstractionCheckTimer.stop();
                continue;
            }
            this.abstractionCheckTimer.start();
            if (!successor.getAbstractionFormula().equals(predicateElement.getAbstractionFormula())) {
                result = false;
            }
            this.abstractionCheckTimer.stop();
            PathFormula computedPathFormula = this.convertEdgeToPathFormula(pathFormula, pCfaEdge);
            PathFormula mergeWithPathFormula = computedPathFormulae.get(successor);
            if (mergeWithPathFormula != null) {
                computedPathFormulae.put(successor, this.pathFormulaManager.makeOr(mergeWithPathFormula, computedPathFormula));
                continue;
            }
            computedPathFormulae.put(successor, computedPathFormula);
        }
        return result;
    }
}

