/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.errorprone.annotations.ForOverride;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public abstract class RefinementStrategy {
    private final StatInt differentNontrivialInterpolants = new StatInt(StatKind.SUM, "Different non-trivial interpolants along paths");
    private final StatInt equalNontrivialInterpolants = new StatInt(StatKind.SUM, "Equal non-trivial interpolants along paths");
    private final StatInt truePathPrefixStates = new StatInt(StatKind.SUM, "Length (states) of path with itp 'true'");
    private final StatInt nonTrivialPathStates = new StatInt(StatKind.SUM, "Length (states) of path with itp non-trivial itp");
    private final StatInt falsePathSuffixStates = new StatInt(StatKind.SUM, "Length (states) of path with itp 'false'");
    private final StatInt numberOfAffectedStates = new StatInt(StatKind.SUM, "Number of affected states");
    private final StatInt totalPathLengthToInfeasibility = new StatInt(StatKind.AVG, "Length of refined path (in blocks)");
    private final BooleanFormulaManagerView bfmgr;
    private final Solver solver;

    protected void printStatistics(PrintStream out) {
        StatisticsWriter.writingStatisticsTo(out).put(this.totalPathLengthToInfeasibility).put(this.numberOfAffectedStates).put(this.truePathPrefixStates).put(this.nonTrivialPathStates).put(this.falsePathSuffixStates).put(this.differentNontrivialInterpolants).put(this.equalNontrivialInterpolants);
    }

    protected RefinementStrategy(Solver pSolver) {
        this.solver = pSolver;
        this.bfmgr = this.solver.getFormulaManager().getBooleanFormulaManager();
    }

    public boolean performRefinement(ARGReachedSet pReached, List<ARGState> abstractionStatesTrace, List<BooleanFormula> pInterpolants, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        Pair<ARGState, List<ARGState>> rootOfInfeasibleArgAndChangedElements;
        this.startRefinementOfPath();
        ARGState lastElement = abstractionStatesTrace.get(abstractionStatesTrace.size() - 1);
        try {
            rootOfInfeasibleArgAndChangedElements = this.evaluateInterpolantsOnPath(lastElement, abstractionStatesTrace, pInterpolants);
        }
        catch (SolverException e) {
            throw new CPAException("Solver Failure", e);
        }
        ARGState infeasiblePartOfARG = rootOfInfeasibleArgAndChangedElements.getFirst();
        List<ARGState> changedElements = rootOfInfeasibleArgAndChangedElements.getSecond();
        this.finishRefinementOfPath(infeasiblePartOfARG, changedElements, pReached, abstractionStatesTrace, pRepeatedCounterexample);
        return false;
    }

    private Pair<ARGState, List<ARGState>> evaluateInterpolantsOnPath(ARGState pTargetState, List<ARGState> abstractionStatesTrace, List<BooleanFormula> pInterpolants) throws SolverException, InterruptedException {
        abstractionStatesTrace = abstractionStatesTrace.subList(0, abstractionStatesTrace.size() - 1);
        assert (pInterpolants.size() == abstractionStatesTrace.size());
        ArrayList<ARGState> changedElements = new ArrayList<ARGState>();
        ARGState infeasiblePartOfARG = pTargetState;
        boolean previousItpWasTrue = true;
        int truePrefixStates = 0;
        int nonTrivialStates = 0;
        int falseSuffixStates = 0;
        int differentNontrivialItps = 0;
        int equalNontrivialItps = 0;
        int pathLengthToInfeasibility = 0;
        BooleanFormula lastItp = null;
        for (Pair<BooleanFormula, ARGState> interpolationPoint : Pair.zipList(pInterpolants, abstractionStatesTrace)) {
            ++pathLengthToInfeasibility;
            BooleanFormula itp = interpolationPoint.getFirst();
            ARGState w = interpolationPoint.getSecond();
            if (this.bfmgr.isTrue(itp)) {
                ++truePrefixStates;
                previousItpWasTrue = true;
                continue;
            }
            if (this.bfmgr.isFalse(itp)) {
                ++falseSuffixStates;
                infeasiblePartOfARG = w;
                if (!previousItpWasTrue) break;
                break;
            }
            if (lastItp != null) {
                if (lastItp.equals(itp)) {
                    ++equalNontrivialItps;
                } else {
                    ++differentNontrivialItps;
                }
            }
            lastItp = itp;
            ++nonTrivialStates;
            previousItpWasTrue = false;
            if (this.performRefinementForState(itp, w)) continue;
            changedElements.add(w);
        }
        this.numberOfAffectedStates.setNextValue(changedElements.size());
        if (Objects.equals(infeasiblePartOfARG, pTargetState)) {
            ++pathLengthToInfeasibility;
        }
        this.truePathPrefixStates.setNextValue(truePrefixStates);
        this.nonTrivialPathStates.setNextValue(nonTrivialStates);
        this.falsePathSuffixStates.setNextValue(falseSuffixStates);
        this.differentNontrivialInterpolants.setNextValue(differentNontrivialItps);
        this.equalNontrivialInterpolants.setNextValue(equalNontrivialItps);
        this.totalPathLengthToInfeasibility.setNextValue(pathLengthToInfeasibility);
        return Pair.of(infeasiblePartOfARG, changedElements);
    }

    @ForOverride
    protected abstract void startRefinementOfPath();

    @ForOverride
    protected abstract boolean performRefinementForState(BooleanFormula var1, ARGState var2) throws InterruptedException, SolverException;

    @ForOverride
    protected abstract void finishRefinementOfPath(ARGState var1, List<ARGState> var2, ARGReachedSet var3, List<ARGState> var4, boolean var5) throws CPAException, InterruptedException;
}

