/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.Collection;
import java.util.Optional;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefinerFactory;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;

public class SlicingAbstractionsRefiner
implements Refiner,
StatisticsProvider {
    private final ARGBasedRefiner refiner;
    private final ARGCPA argCpa;

    public SlicingAbstractionsRefiner(ARGBasedRefiner pRefiner, ARGCPA pCpa) {
        this.refiner = pRefiner;
        this.argCpa = pCpa;
    }

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        PredicateCPA predicateCpa = CPAs.retrieveCPA(pCpa, PredicateCPA.class);
        ARGCPA argCpa = CPAs.retrieveCPA(pCpa, ARGCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(SlicingAbstractionsRefiner.class.getSimpleName() + " needs a PredicateCPA");
        }
        SlicingAbstractionsStrategy strategy = new SlicingAbstractionsStrategy(predicateCpa, predicateCpa.getConfiguration());
        PredicateCPARefinerFactory factory = new PredicateCPARefinerFactory(pCpa);
        ARGBasedRefiner refiner = factory.create(strategy);
        return new SlicingAbstractionsRefiner(refiner, argCpa);
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        Optional<AbstractState> optionalTargetState;
        CounterexampleInfo counterexample = null;
        while ((optionalTargetState = pReached.stream().filter(AbstractStates::isTargetState).findFirst()).isPresent()) {
            ARGReachedSet reached = new ARGReachedSet(pReached, this.argCpa);
            AbstractState targetState = optionalTargetState.orElseThrow();
            ARGPath errorPath = ARGUtils.getShortestPathTo((ARGState)targetState);
            counterexample = this.refiner.performRefinementForPath(reached, errorPath);
            if (!counterexample.isSpurious()) {
                ((ARGState)targetState).addCounterexampleInformation(counterexample);
                return false;
            }
            if (SlicingAbstractionsUtils.checkProgress(pReached, errorPath)) continue;
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, errorPath);
        }
        return true;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.refiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.refiner)).collectStatistics(pStatsCollection);
        }
    }
}

