/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGLogger;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.predicate.ImpactUtility;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsUtils;
import org.sosy_lab.cpachecker.cpa.slab.EdgeSet;
import org.sosy_lab.cpachecker.cpa.slab.SLARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate.slicingabstractions")
public class SlicingAbstractionsStrategy
extends RefinementStrategy
implements StatisticsProvider {
    @Option(secure=true, name="minimalslicing", description="Only slices the minimal amount of edges to guarantuee progress")
    private boolean minimalSlicing = false;
    @Option(secure=true, name="optimizeslicing", description="Reduces the amount of solver calls by directely slicing some edgesthat are mathematically proven to be infeasible in any case")
    private boolean optimizeSlicing = true;
    @Option(secure=true, description="Whether to remove parts fo the ARG from which no target state is reachable")
    private boolean removeSafeRegions = true;
    @Option(secure=true, description="Whether to perform dynamic block encoding as part of each refinement iteration")
    private boolean dynamicBlockEncoding = false;
    private final Stats stats = new Stats();
    private final BooleanFormulaManagerView bfmgr;
    private final PredicateAbstractionManager predAbsMgr;
    private final ImpactUtility impact;
    private final PathFormulaManager pfmgr;
    private final Solver solver;
    private final ARGLogger argLogger;
    private final LogManager logger;
    private AbstractionFormula lastAbstraction = null;
    private boolean initialSliceDone = false;
    private Boolean mayShortcutSlicing = null;
    private Map<ARGState, ARGState> forkedStateMap;

    public SlicingAbstractionsStrategy(PredicateCPA pPredicateCpa, Configuration config) throws InvalidConfigurationException {
        super(pPredicateCpa.getSolver());
        this.solver = pPredicateCpa.getSolver();
        this.bfmgr = this.solver.getFormulaManager().getBooleanFormulaManager();
        this.predAbsMgr = pPredicateCpa.getPredicateManager();
        this.impact = new ImpactUtility(pPredicateCpa.getConfiguration(), this.solver.getFormulaManager(), this.predAbsMgr);
        this.pfmgr = pPredicateCpa.getPathFormulaManager();
        this.logger = pPredicateCpa.getLogger();
        this.argLogger = new ARGLogger(pPredicateCpa.getConfiguration(), this.logger);
        config.inject((Object)this);
    }

    @Override
    protected void startRefinementOfPath() {
        Preconditions.checkState((this.lastAbstraction == null ? 1 : 0) != 0);
        this.stats.increaseRefinementCounter();
        this.lastAbstraction = this.predAbsMgr.makeTrueAbstractionFormula(null);
        this.forkedStateMap = new HashMap<ARGState, ARGState>();
        this.mayShortcutSlicing = true;
    }

    @Override
    protected boolean performRefinementForState(BooleanFormula itp, ARGState s) throws SolverException, InterruptedException {
        Preconditions.checkArgument((!this.bfmgr.isTrue(itp) ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.bfmgr.isFalse(itp) ? 1 : 0) != 0);
        Preconditions.checkState((this.forkedStateMap != null ? 1 : 0) != 0);
        PredicateAbstractState original = PredicateAbstractState.getPredicateState(s);
        PredicateAbstractState copiedPredicateState = PredicateAbstractState.mkAbstractionState(original.getPathFormula(), original.getAbstractionFormula(), original.getAbstractionLocationsOnPath());
        boolean stateChanged = this.impact.strengthenStateWithInterpolant(itp, s, this.lastAbstraction);
        if (!(!stateChanged || this.optimizeSlicing && this.mayShortcutSlicing.booleanValue() && SlicingAbstractionsUtils.calculateIncomingSegments(s).size() <= 1)) {
            this.mayShortcutSlicing = false;
            AbstractState newState = s.forkWithReplacements(Collections.singleton(copiedPredicateState));
            this.forkedStateMap.put(s, (ARGState)newState);
            BooleanFormula negatedItp = this.bfmgr.not(itp);
            this.impact.strengthenStateWithInterpolant(negatedItp, (ARGState)newState, this.lastAbstraction);
        }
        this.lastAbstraction = PredicateAbstractState.getPredicateState(s).getAbstractionFormula();
        return !stateChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishRefinementOfPath(ARGState infeasiblePartOfART, List<ARGState> changedElements, ARGReachedSet pReached, List<ARGState> abstractionStatesTrace, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        ARGState rootState;
        Preconditions.checkState((this.lastAbstraction != null ? 1 : 0) != 0);
        this.lastAbstraction = null;
        this.stats.argUpdate.start();
        this.stats.copyEdges.start();
        for (ARGState w : changedElements) {
            pReached.removeCoverageOf(w);
            if (!this.forkedStateMap.containsKey(w)) continue;
            ARGState forkedState = this.forkedStateMap.get(w);
            SlicingAbstractionsUtils.copyEdges(forkedState, w, pReached);
            pReached.addForkedState(forkedState, w);
        }
        this.stats.copyEdges.stop();
        ImmutableSet<ARGState> rootStates = ARGUtils.getRootStates(pReached.asReachedSet());
        if (rootStates.size() == 1) {
            rootState = (ARGState)Iterables.get(rootStates, (int)0);
        } else {
            rootState = (ARGState)rootStates.stream().reduce((x, y) -> x.getStateId() < y.getStateId() ? x : y).orElseThrow();
            this.logger.logf(Level.INFO, "More than one root state present!(%s)", new Object[]{FluentIterable.from(rootStates).transform(ARGState::getStateId)});
        }
        this.argLogger.log("in refinement before slicing!", pReached.asReachedSet().asCollection());
        this.stats.sliceEdges.start();
        if (!this.initialSliceDone) {
            ImmutableList all = FluentIterable.from((Iterable)pReached.asReachedSet()).filter(ARGState.class).filter(SlicingAbstractionsUtils::isAbstractionState).toList();
            this.sliceEdges((List<ARGState>)all, infeasiblePartOfART, abstractionStatesTrace, rootState);
            this.initialSliceDone = true;
        } else {
            this.sliceEdges(changedElements, infeasiblePartOfART, abstractionStatesTrace, rootState);
        }
        this.stats.sliceEdges.stop();
        this.argLogger.log("in refinement after slicing!", pReached.asReachedSet().asCollection());
        this.stats.calcReached.start();
        pReached.recalculateReachedSet(rootState);
        this.stats.calcReached.stop();
        this.forkedStateMap.clear();
        this.mayShortcutSlicing = null;
        if (this.dynamicBlockEncoding) {
            boolean changed = true;
            while (changed) {
                changed = SlicingAbstractionsUtils.performDynamicBlockEncoding(pReached);
                if (!changed) continue;
                pReached.recalculateReachedSet(rootState);
                ImmutableList all = FluentIterable.from((Iterable)pReached.asReachedSet()).filter(ARGState.class).filter(SlicingAbstractionsUtils::isAbstractionState).toList();
                this.sliceEdges((List<ARGState>)all, null, null, null);
            }
            pReached.recalculateReachedSet(rootState);
        }
        if (this.removeSafeRegions) {
            pReached.removeSafeRegions();
        }
        this.argLogger.log("in refinement after pruning!", pReached.asReachedSet().asCollection());
        this.stats.argUpdate.stop();
        this.stats.coverTime.start();
        try {
            for (ARGState w : changedElements) {
                if (w instanceof SLARGState) continue;
                if (w.isDestroyed()) {
                } else if (!pReached.tryToCover(w)) continue;
                break;
            }
        }
        finally {
            this.stats.coverTime.stop();
        }
    }

    private void sliceEdges(List<ARGState> pChangedElements, ARGState pInfeasiblePartOfART, List<ARGState> pAbstractionStatesTrace, ARGState rootState) throws InterruptedException, CPAException {
        List allChangedStates = pChangedElements.stream().map(x -> this.forkedStateMap.get(x)).filter(x -> x != null).filter(x -> !pChangedElements.contains(x)).collect(Collectors.toCollection(ArrayList::new));
        allChangedStates.addAll(pChangedElements);
        ArrayList<ARGState> priorAbstractionStates = new ArrayList<ARGState>();
        for (ARGState currentState : allChangedStates) {
            for (ARGState s : SlicingAbstractionsUtils.calculateStartStates(currentState)) {
                if (priorAbstractionStates.contains(s) || allChangedStates.contains(s)) continue;
                priorAbstractionStates.add(s);
            }
        }
        allChangedStates.addAll(priorAbstractionStates);
        if (this.minimalSlicing) {
            allChangedStates.addAll((Collection)pAbstractionStatesTrace.stream().filter(x -> !allChangedStates.contains(x)).collect(ImmutableList.toImmutableList()));
        }
        for (ARGState currentState : allChangedStates) {
            if (currentState instanceof SLARGState) {
                SlicingAbstractionsUtils.removeIncomingEdgesWithLocationMismatch((SLARGState)currentState);
                SlicingAbstractionsUtils.removeOutgoingEdgesWithLocationMismatch((SLARGState)currentState);
            }
            ImmutableMap<ARGState, PersistentList<ARGState>> segmentMap = SlicingAbstractionsUtils.calculateOutgoingSegments(currentState);
            HashMap<ARGState, Boolean> infeasibleMap = new HashMap<ARGState, Boolean>();
            for (Map.Entry entry : segmentMap.entrySet()) {
                ARGState key = (ARGState)entry.getKey();
                List segment = (List)entry.getValue();
                boolean infeasible = currentState instanceof SLARGState ? this.checkSymbolicEdge(currentState, key, segment) : this.checkEdge(currentState, key, segment, pAbstractionStatesTrace, rootState, pInfeasiblePartOfART, pChangedElements);
                infeasibleMap.put(key, infeasible);
            }
            SlicingAbstractionsStrategy.slice0(currentState, segmentMap, infeasibleMap);
        }
    }

    private static void slice0(ARGState currentState, Map<ARGState, PersistentList<ARGState>> segmentMap, Map<ARGState, Boolean> infeasibleMap) {
        HashSet segmentStateSet = new HashSet();
        for (List list : segmentMap.values()) {
            segmentStateSet.addAll(list);
        }
        for (Map.Entry entry : infeasibleMap.entrySet()) {
            ARGState key = (ARGState)entry.getKey();
            boolean isInfeasible = (Boolean)entry.getValue();
            List segment = (List)segmentMap.get(key);
            if (!isInfeasible) {
                segmentStateSet.removeAll(segment);
                continue;
            }
            if (key.getParents().contains(currentState)) {
                key.removeParent(currentState);
            }
            if (Collections.disjoint(key.getParents(), segment)) continue;
            for (ARGState s : Sets.intersection(new HashSet<ARGState>(key.getParents()), new HashSet(segment))) {
                key.removeParent(s);
            }
        }
        for (ARGState aRGState : segmentStateSet) {
            SlicingAbstractionsStrategy.detachFromParentsInARG(aRGState);
        }
    }

    private static void detachFromParentsInARG(ARGState toRemove) {
        for (ARGState parent : ImmutableList.copyOf(toRemove.getParents())) {
            toRemove.removeParent(parent);
        }
    }

    private boolean checkEdgeSet(SLARGState startState, SLARGState endState) throws InterruptedException, CPAException {
        assert (startState.getChildren().contains(endState));
        EdgeSet edgeSet = startState.getEdgeSetToChild(endState);
        boolean infeasible = true;
        CFAEdge savedEdge = edgeSet.choose();
        Iterator<CFAEdge> it = edgeSet.iterator();
        while (it.hasNext()) {
            CFAEdge cfaEdge = it.next();
            edgeSet.select(cfaEdge);
            if (this.isInfeasibleEdge(startState, endState, (List<ARGState>)ImmutableList.of())) {
                it.remove();
                continue;
            }
            infeasible = false;
        }
        if (!infeasible && edgeSet.contains(savedEdge)) {
            edgeSet.select(savedEdge);
        }
        return infeasible;
    }

    private boolean checkEdge(ARGState startState, ARGState endState, List<ARGState> segmentList, List<ARGState> abstractionStatesTrace, ARGState rootState, ARGState pInfeasiblePartOfART, List<ARGState> pChangedElements) throws InterruptedException, CPAException {
        boolean infeasible = false;
        boolean mustBeInfeasible = this.mustBeInfeasible(startState, endState, abstractionStatesTrace, rootState, pInfeasiblePartOfART, pChangedElements);
        if (mustBeInfeasible && this.optimizeSlicing) {
            infeasible = true;
        } else if (this.minimalSlicing) {
            if (!this.optimizeSlicing) assert (!mustBeInfeasible || this.isInfeasibleEdge(startState, endState, segmentList)) : "Edge " + startState.getStateId() + " -> " + endState.getStateId() + " must be infeasible!";
            infeasible = mustBeInfeasible;
        } else {
            infeasible = this.isInfeasibleEdge(startState, endState, segmentList);
            assert (!mustBeInfeasible || infeasible) : "Edge " + startState.getStateId() + " -> " + endState.getStateId() + " must be infeasible!";
        }
        assert (!(startState instanceof SLARGState) || ((SLARGState)startState).getEdgeSetToChild(endState) == null || ((SLARGState)startState).getEdgeSetToChild(endState).size() > 0 || infeasible);
        return infeasible;
    }

    private boolean checkSymbolicEdge(ARGState pStartState, ARGState pEndState, List<ARGState> pSegmentList) throws InterruptedException, CPAException {
        boolean segmentExists;
        boolean edgeSetExists = pStartState.getChildren().contains(pEndState);
        boolean bl = segmentExists = !pSegmentList.isEmpty();
        if (segmentExists && !edgeSetExists) {
            return this.isInfeasibleEdge(pStartState, pEndState, pSegmentList);
        }
        if (!segmentExists && edgeSetExists) {
            return this.checkEdgeSet((SLARGState)pStartState, (SLARGState)pEndState);
        }
        if (segmentExists && edgeSetExists) {
            boolean edgeSetInfeasible = this.checkEdgeSet((SLARGState)pStartState, (SLARGState)pEndState);
            if (edgeSetInfeasible) {
                pEndState.removeParent(pStartState);
            }
            boolean segmentInfeasible = this.isInfeasibleEdge(pStartState, pEndState, pSegmentList);
            return edgeSetInfeasible && segmentInfeasible;
        }
        throw new RuntimeException("Checking a nonexisting transition in the ARG!");
    }

    private boolean isInfeasibleEdge(ARGState start, ARGState stop, List<ARGState> segmentList) throws InterruptedException, CPAException {
        boolean infeasible = false;
        SSAMap startSSAMap = SSAMap.emptySSAMap().withDefault(1);
        PointerTargetSet startPts = PointerTargetSet.emptyPointerTargetSet();
        BooleanFormula formula = SlicingAbstractionsUtils.buildPathFormula(start, stop, segmentList, startSSAMap, startPts, this.pfmgr, SlicingAbstractionsUtils.AbstractionPosition.BOTH).getFormula();
        try (ProverEnvironment thmProver = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            thmProver.push(formula);
            this.stats.increaseSolverCallCounter();
            infeasible = thmProver.isUnsat();
        }
        catch (SolverException e) {
            throw new CPAException("Solver Failure", e);
        }
        return infeasible;
    }

    private boolean mustBeInfeasible(ARGState parent, ARGState child, List<ARGState> abstractionStatesTrace, ARGState rootState, ARGState infeasiblePartOfART, List<ARGState> pChangedElements) {
        ARGState firstAfterRoot;
        ARGState s;
        int i;
        if (rootState == null) {
            return false;
        }
        for (i = 0; i < abstractionStatesTrace.size() - 1; ++i) {
            ARGState s2;
            ARGState currentState = abstractionStatesTrace.get(i);
            ARGState nextState = abstractionStatesTrace.get(i + 1);
            if (!currentState.equals(parent) || !Objects.equals(s2 = this.forkedStateMap.get(nextState), child) || !pChangedElements.contains(nextState)) continue;
            return true;
        }
        if (Objects.equals(parent, rootState) && Objects.equals(s = this.forkedStateMap.get(firstAfterRoot = abstractionStatesTrace.get(0)), child) && pChangedElements.contains(firstAfterRoot)) {
            return true;
        }
        return Objects.equals(infeasiblePartOfART, child) && ((i = abstractionStatesTrace.indexOf(infeasiblePartOfART)) > 0 ? Objects.equals(abstractionStatesTrace.get(i - 1), parent) : Objects.equals(parent, rootState));
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private class Stats
    implements Statistics {
        private final Timer coverTime = new Timer();
        private final Timer argUpdate = new Timer();
        private final Timer copyEdges = new Timer();
        private final Timer sliceEdges = new Timer();
        private final Timer calcReached = new Timer();
        private int refinementCount = 0;
        private int solverCallCount = 0;

        private Stats() {
        }

        @Override
        public String getName() {
            return "Slicing Abstractions";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("  Computing abstraction of itp:       " + SlicingAbstractionsStrategy.this.impact.abstractionTime);
            out.println("  Checking whether itp is new:        " + SlicingAbstractionsStrategy.this.impact.itpCheckTime);
            out.println("  Number of refinements:                  " + this.refinementCount);
            out.println("  Coverage checks:                    " + this.coverTime);
            out.println("  ARG update:                         " + this.argUpdate);
            out.println("    Copy edges:                       " + this.copyEdges);
            out.println("    Slice edges:                      " + this.sliceEdges);
            out.println("      Solver calls:                       " + this.solverCallCount);
            out.println("    Recalculate ReachedSet:           " + this.calcReached);
            out.println();
            out.println("Number of abstractions during refinements:  " + SlicingAbstractionsStrategy.this.impact.abstractionTime.getNumberOfIntervals());
            SlicingAbstractionsStrategy.this.printStatistics(out);
        }

        public void increaseRefinementCounter() {
            ++this.refinementCount;
        }

        public void increaseSolverCallCounter() {
            ++this.solverCallCount;
        }
    }
}

