/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

@RunWith(value=Parameterized.class)
public class SlicingAbstractionsTest {
    private static final String TEST_DIR_PATH = "test/programs/slicingabstractions/";
    private static final String CONFIG_DIR_PATH = "config/";
    private static final ImmutableMap<String, String> EMPTY_OPTIONS = ImmutableMap.of();
    private static final ImmutableMap<String, String> LINEAR_OPTIONS = ImmutableMap.of((Object)"cpa.predicate.encodeBitvectorAs", (Object)"INTEGER", (Object)"cpa.predicate.encodeFloatAs", (Object)"RATIONAL", (Object)"cpa.predicate.handleFieldAccess", (Object)"false");
    private static final ImmutableMap<String, String> UNOPTIMIZED_OPTION = ImmutableMap.of((Object)"cpa.predicate.slicingabstractions.optimizeslicing", (Object)"false");
    private static final ImmutableMap<String, String> MINIMAL_OPTION = ImmutableMap.of((Object)"cpa.predicate.slicingabstractions.minimalslicing", (Object)"true");
    private String filename;
    private String configname;
    private Map<String, String> extraOptions;

    private static boolean isConfig(File pPathname) {
        return (pPathname.getName().contains("Kojak") || pPathname.getName().contains("SlicingAbstractions")) && !pPathname.getName().contains("overflow");
    }

    private static boolean isSlabConfig(File pPathname) {
        return pPathname.getName().contains("Slab");
    }

    private static boolean isOverflowConfig(File pPathname) {
        return (pPathname.getName().contains("Kojak") || pPathname.getName().contains("SlicingAbstractions")) && pPathname.getName().contains("overflow");
    }

    @Parameterized.Parameters(name="{3}: {0}")
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static Collection<Object[]> data() {
        File taskfolder = new File(TEST_DIR_PATH);
        ImmutableList files = FluentIterable.from((Object[])taskfolder.listFiles()).transform(x -> x.getName()).filter(x -> ((String)x).contains("unreach")).toList();
        ImmutableList overflowFiles = FluentIterable.from((Object[])taskfolder.listFiles()).transform(x -> x.getName()).filter(x -> ((String)x).contains("overflow")).toList();
        File configfolder = new File(CONFIG_DIR_PATH);
        ImmutableList configs = FluentIterable.from((Object[])configfolder.listFiles(SlicingAbstractionsTest::isConfig)).transform(x -> x.getName()).toList();
        ImmutableList slabConfigs = FluentIterable.from((Object[])configfolder.listFiles(SlicingAbstractionsTest::isSlabConfig)).transform(x -> x.getName()).toList();
        ImmutableList overflowConfigs = FluentIterable.from((Object[])configfolder.listFiles(SlicingAbstractionsTest::isOverflowConfig)).transform(x -> x.getName()).toList();
        ImmutableList solverModes = ImmutableList.of(EMPTY_OPTIONS, LINEAR_OPTIONS);
        ImmutableList optimizeModes = ImmutableList.of(EMPTY_OPTIONS, UNOPTIMIZED_OPTION);
        ImmutableList minimalModes = ImmutableList.of(EMPTY_OPTIONS, MINIMAL_OPTION);
        FluentIterable firstIterable = FluentIterable.from((Iterable)Lists.cartesianProduct((List[])new List[]{files, configs, solverModes, optimizeModes, minimalModes})).transform(x -> SlicingAbstractionsTest.repack(x)).filter(x -> SlicingAbstractionsTest.filter(x));
        FluentIterable secondIterable = FluentIterable.from((Iterable)Lists.cartesianProduct((List[])new List[]{files, slabConfigs})).transform(x -> {
            Object[] result;
            result = new Object[]{x.get(0), x.get(1), new HashMap(), ((String)result[1]).replace("predicateAnalysis-", "").replace(".properties", "")};
            return result;
        });
        FluentIterable thirdIterable = FluentIterable.from((Iterable)Lists.cartesianProduct((List[])new List[]{overflowFiles, overflowConfigs})).transform(x -> {
            Object[] result;
            result = new Object[]{x.get(0), x.get(1), new HashMap(), ((String)result[1]).replace("predicateAnalysis-", "").replace(".properties", "")};
            return result;
        });
        return firstIterable.append((Iterable)secondIterable).append((Iterable)thirdIterable).toList();
    }

    private static Object[] repack(List<Object> x) {
        Object[] result = new Object[4];
        result[0] = x.get(0);
        result[1] = x.get(1);
        HashMap extraOptions = new HashMap();
        Map solverMode = (Map)x.get(2);
        Map optimizeMode = (Map)x.get(3);
        Map minimalMode = (Map)x.get(4);
        extraOptions.putAll(solverMode);
        extraOptions.putAll(optimizeMode);
        extraOptions.putAll(minimalMode);
        result[2] = extraOptions;
        Object modeString = ((String)x.get(1)).replace("predicateAnalysis-", "").replace(".properties", "");
        modeString = (String)modeString + (solverMode == EMPTY_OPTIONS ? "-bitvector" : "-linear");
        modeString = (String)modeString + (optimizeMode == EMPTY_OPTIONS ? "-optimized" : "-unoptimized");
        result[3] = modeString = (String)modeString + (minimalMode == EMPTY_OPTIONS ? "-maximal" : "-minimal");
        return result;
    }

    private static boolean filter(Object[] x) {
        String modeString = (String)x[3];
        return !modeString.matches(".*SlicingAbstractionsAbstractionRefiner.*unoptimized.*");
    }

    public SlicingAbstractionsTest(String filename, String configname, Map<String, String> extraOptions, String name) {
        this.filename = filename;
        this.configname = configname;
        this.extraOptions = extraOptions;
    }

    @Test
    public void check() throws Exception {
        this.check(this.filename, this.extraOptions);
    }

    private void check(String pFilename, Map<String, String> extra) throws Exception {
        this.check(pFilename, this.getProperties(this.configname, extra));
    }

    private void check(String pFilename, Configuration config) throws Exception {
        String fullPath = Path.of(TEST_DIR_PATH, this.filename).toString();
        TestResults results = CPATestRunner.run(config, fullPath);
        if (!this.configname.contains("overflow")) {
            if (pFilename.contains("_true_assert") || pFilename.contains("_true-unreach")) {
                results.assertIsSafe();
            } else if (pFilename.contains("_false_assert") || pFilename.contains("_false-unreach")) {
                results.assertIsUnsafe();
            }
        } else if (pFilename.contains("_true_no_overflow")) {
            results.assertIsSafe();
        } else if (pFilename.contains("_false_no_overflow")) {
            results.assertIsUnsafe();
        }
    }

    private Configuration getProperties(String configFile, Map<String, String> extra) throws InvalidConfigurationException, IOException {
        return TestDataTools.configurationForTest().loadFromFile(CONFIG_DIR_PATH + configFile).setOptions(extra).build();
    }
}

