/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.dca.DCAState;
import org.sosy_lab.cpachecker.cpa.overflow.OverflowState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefiner;
import org.sosy_lab.cpachecker.cpa.slab.EdgeSet;
import org.sosy_lab.cpachecker.cpa.slab.SLARGState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class SlicingAbstractionsUtils {
    private SlicingAbstractionsUtils() {
    }

    public static Map<ARGState, PersistentList<ARGState>> calculateIncomingSegments(ARGState originState) {
        Preconditions.checkArgument((boolean)SlicingAbstractionsUtils.isAbstractionState(originState));
        TreeMap<ARGState, PersistentList<ARGState>> result = new TreeMap<ARGState, PersistentList<ARGState>>();
        List<ARGState> startAbstractionStates = SlicingAbstractionsUtils.calculateStartStates(originState);
        for (ARGState s : startAbstractionStates) {
            ImmutableMap<ARGState, PersistentList<ARGState>> outgoing = SlicingAbstractionsUtils.calculateOutgoingSegments(s);
            if (!outgoing.containsKey(originState)) continue;
            result.put(s, (PersistentList<ARGState>)((PersistentList)outgoing.get(originState)));
        }
        return result;
    }

    public static List<ARGState> calculateStartStates(ARGState originState) {
        Preconditions.checkArgument((boolean)SlicingAbstractionsUtils.isAbstractionState(originState));
        HashSet<ARGState> result = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> reached = new HashSet<ARGState>();
        for (ARGState parent : originState.getParents()) {
            if (SlicingAbstractionsUtils.isAbstractionState(parent)) {
                result.add(parent);
                continue;
            }
            waitlist.add(parent);
            reached.clear();
            reached.add(parent);
            block1: while (!waitlist.isEmpty()) {
                ARGState currentState = (ARGState)waitlist.pop();
                for (ARGState s : currentState.getParents()) {
                    if (SlicingAbstractionsUtils.isAbstractionState(s)) {
                        result.add(s);
                        waitlist.clear();
                        continue block1;
                    }
                    if (reached.contains(s)) continue;
                    waitlist.add(s);
                    reached.add(s);
                }
            }
        }
        return new ArrayList<ARGState>(result);
    }

    public static ImmutableMap<ARGState, PersistentList<ARGState>> calculateOutgoingSegments(ARGState originState) {
        Collection<ARGState> outgoingStates = originState.getChildren();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        TreeMap<ARGState, Object> frontier = new TreeMap<ARGState, Object>();
        TreeMap<ARGState, Object> segmentMap = new TreeMap<ARGState, Object>();
        Collection<ARGState> reachableNonAbstractionStates = SlicingAbstractionsUtils.nonAbstractionReach(originState);
        frontier.put(originState, PersistentLinkedList.of());
        for (ARGState startState : outgoingStates) {
            if (!SlicingAbstractionsUtils.isAbstractionState(startState)) {
                waitlist.add(startState);
                continue;
            }
            segmentMap.put(startState, PersistentLinkedList.of());
        }
        while (!waitlist.isEmpty()) {
            ARGState currentState = (ARGState)waitlist.pop();
            if (!frontier.keySet().containsAll((Collection<?>)FluentIterable.from(currentState.getParents()).filter(x -> reachableNonAbstractionStates.contains(x)).toList())) {
                waitlist.add(currentState);
                continue;
            }
            PersistentList currentStateList = null;
            HashSet<ARGState> currentStateSet = new HashSet<ARGState>();
            for (ARGState parent : currentState.getParents()) {
                if (!reachableNonAbstractionStates.contains(parent)) continue;
                PersistentList parentStateList = (PersistentList)frontier.get(parent);
                if (currentStateList == null) {
                    currentStateList = parentStateList;
                    currentStateSet.addAll((Collection<ARGState>)parentStateList);
                    continue;
                }
                for (ARGState s : parentStateList.reversed()) {
                    if (currentStateSet.contains(s)) continue;
                    currentStateList = currentStateList.with((Object)s);
                    currentStateSet.add(s);
                }
            }
            assert (currentStateList != null);
            currentStateList = currentStateList.with((Object)currentState);
            frontier.put(currentState, currentStateList);
            for (ARGState child : currentState.getChildren()) {
                if (SlicingAbstractionsUtils.isAbstractionState(child)) {
                    if (segmentMap.containsKey(child)) {
                        PersistentList storedStateList = (PersistentList)segmentMap.get(child);
                        HashSet storedStateSet = new HashSet(storedStateList);
                        for (ARGState s : currentStateList.reversed()) {
                            if (storedStateSet.contains(s)) continue;
                            storedStateList = storedStateList.with((Object)s);
                        }
                        segmentMap.put(child, storedStateList);
                        continue;
                    }
                    segmentMap.put(child, currentStateList);
                    continue;
                }
                if (waitlist.contains(child)) continue;
                waitlist.add(child);
            }
        }
        return ImmutableMap.copyOf((Map)Maps.transformValues(segmentMap, segment -> segment.reversed()));
    }

    private static Collection<ARGState> nonAbstractionReach(ARGState pOriginState) {
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> reachable = new HashSet<ARGState>();
        waitlist.push(pOriginState);
        reachable.add(pOriginState);
        while (!waitlist.isEmpty()) {
            ARGState s = (ARGState)waitlist.pop();
            ImmutableList l = FluentIterable.from(s.getChildren()).filter(x -> !SlicingAbstractionsUtils.isAbstractionState(x)).filter(x -> !reachable.contains(x)).toList();
            waitlist.addAll((Collection<ARGState>)l);
            reachable.addAll((Collection<ARGState>)l);
        }
        return reachable;
    }

    public static boolean isAbstractionState(ARGState pState) {
        return PredicateAbstractState.getPredicateState(pState).isAbstractionState() || !pState.wasExpanded();
    }

    public static PathFormula buildPathFormula(ARGState start, ARGState stop, SSAMap pSSAMap, PointerTargetSet pPts, FormulaManagerView pFmgr, PathFormulaManager pPfmgr, ImmutableSet<AbstractionPosition> withInvariants) throws CPATransferException, InterruptedException {
        List segmentList = (List)SlicingAbstractionsUtils.calculateOutgoingSegments(start).get((Object)stop);
        if (segmentList == null) {
            segmentList = ImmutableList.of();
        }
        return SlicingAbstractionsUtils.buildPathFormula(start, stop, segmentList, pSSAMap, pPts, pPfmgr, withInvariants);
    }

    public static PathFormula buildPathFormula(ARGState start, ARGState stop, List<ARGState> segmentList, SSAMap pSSAMap, PointerTargetSet pPts, PathFormulaManager pPfmgr, ImmutableSet<AbstractionPosition> withInvariants) throws CPATransferException, InterruptedException {
        PathFormula pathFormula;
        PathFormula startFormula = withInvariants.contains((Object)AbstractionPosition.START) ? SlicingAbstractionsUtils.invariantPathFormulaFromState(start, pSSAMap, pPts, pPfmgr) : pPfmgr.makeEmptyPathFormulaWithContext(pSSAMap, pPts);
        AbstractStateWithAssumptions other = AbstractStates.extractStateByType(stop, AbstractStateWithAssumptions.class);
        if (other != null && !(other instanceof DCAState)) {
            if (stop.isTarget() && other instanceof OverflowState) {
                other = ((OverflowState)other).getParent();
            }
            for (CExpression assumption : Iterables.filter(other.getAssumptions(), CExpression.class)) {
                startFormula = pPfmgr.makeAnd(startFormula, assumption);
            }
        }
        PathFormulaBuilder pfb = SlicingAbstractionsUtils.buildFormulaBuilder(start, stop, segmentList, pPfmgr);
        PathFormula p = pfb.build(pPfmgr, startFormula);
        if (withInvariants.contains((Object)AbstractionPosition.END)) {
            BooleanFormula endInvariant = PredicateAbstractState.getPredicateState(stop).getAbstractionFormula().asFormula();
            pathFormula = pPfmgr.makeAnd(p, endInvariant);
        } else {
            pathFormula = p;
        }
        return pathFormula;
    }

    private static PathFormulaBuilder buildFormulaBuilder(ARGState start, ARGState stop, List<ARGState> segmentList, PathFormulaManager pPfmgr) {
        TreeMap<ARGState, PathFormulaBuilder> finishedBuilders = new TreeMap<ARGState, PathFormulaBuilder>();
        ArrayList<ARGState> allList = new ArrayList<ARGState>(segmentList);
        allList.add(0, start);
        allList.add(stop);
        for (ARGState currentState : allList) {
            PathFormulaBuilder currentBuilder = null;
            for (ARGState parent : currentState.getParents()) {
                CFAEdge edge;
                if (!finishedBuilders.containsKey(parent)) continue;
                if (currentBuilder == null) {
                    DCAState dcaState;
                    edge = parent.getEdgeToChild(currentState);
                    if (edge != null) {
                        currentBuilder = ((PathFormulaBuilder)finishedBuilders.get(parent)).makeAnd(edge);
                    } else {
                        List<CFAEdge> edges = parent.getEdgesToChild(currentState);
                        assert (!edges.isEmpty());
                        currentBuilder = (PathFormulaBuilder)finishedBuilders.get(parent);
                        for (CFAEdge e : edges) {
                            currentBuilder = currentBuilder.makeAnd(e);
                        }
                    }
                    if ((dcaState = AbstractStates.extractStateByType(currentState, DCAState.class)) == null) continue;
                    for (CExpression assumption : FluentIterable.from(dcaState.getAssumptions()).filter(CExpression.class)) {
                        currentBuilder = currentBuilder.makeAnd(assumption);
                    }
                    continue;
                }
                edge = parent.getEdgeToChild(currentState);
                if (edge != null) {
                    currentBuilder = currentBuilder.makeOr(((PathFormulaBuilder)finishedBuilders.get(parent)).makeAnd(edge));
                    continue;
                }
                PathFormulaBuilder otherBuilder = (PathFormulaBuilder)finishedBuilders.get(parent);
                List<CFAEdge> edges = parent.getEdgesToChild(currentState);
                assert (!edges.isEmpty());
                for (CFAEdge e : edges) {
                    otherBuilder = otherBuilder.makeAnd(e);
                }
                currentBuilder = currentBuilder.makeOr(otherBuilder);
            }
            if (currentBuilder == null) {
                currentBuilder = pPfmgr.createNewPathFormulaBuilder();
            }
            finishedBuilders.put(currentState, currentBuilder);
        }
        return (PathFormulaBuilder)finishedBuilders.get(stop);
    }

    private static PathFormula invariantPathFormulaFromState(ARGState state, SSAMap pSSAMap, PointerTargetSet pPts, PathFormulaManager pfmgr) {
        BooleanFormula initFormula = PredicateAbstractState.getPredicateState(state).getAbstractionFormula().asFormula();
        return pfmgr.makeAnd(pfmgr.makeEmptyPathFormulaWithContext(pSSAMap, pPts), initFormula);
    }

    public static List<PathFormula> getFormulasForPath(PathFormulaManager pfmgr, Solver pSolver, ARGState pRoot, List<ARGState> pPath, ImmutableSet<AbstractionPosition> includePartialInvariants) throws CPATransferException, InterruptedException {
        return SlicingAbstractionsUtils.getFormulasForPath(pfmgr, pSolver, pRoot, pPath, SSAMap.emptySSAMap().withDefault(1), PointerTargetSet.emptyPointerTargetSet(), includePartialInvariants);
    }

    public static List<PathFormula> getFormulasForPath(PathFormulaManager pfmgr, Solver pSolver, ARGState pRoot, List<ARGState> pPath, SSAMap pSSAMap, PointerTargetSet pPts, ImmutableSet<AbstractionPosition> includePartialInvariants) throws CPATransferException, InterruptedException {
        ArrayList<PathFormula> abstractionFormulas = new ArrayList<PathFormula>();
        PathFormula currentPathFormula = SlicingAbstractionsUtils.buildPathFormula(pRoot, pPath.get(0), pSSAMap, pPts, pSolver.getFormulaManager(), pfmgr, includePartialInvariants);
        abstractionFormulas.add(currentPathFormula);
        for (int i = 0; i < pPath.size() - 1; ++i) {
            PathFormula oldPathFormula = currentPathFormula;
            currentPathFormula = SlicingAbstractionsUtils.buildPathFormula(pPath.get(i), pPath.get(i + 1), oldPathFormula.getSsa(), oldPathFormula.getPointerTargetSet(), pSolver.getFormulaManager(), pfmgr, includePartialInvariants);
            abstractionFormulas.add(currentPathFormula);
        }
        return abstractionFormulas;
    }

    public static void copyEdges(ARGState forkedState, ARGState originalState, ARGReachedSet pReached) {
        List intermediateStateList;
        ImmutableMap<ARGState, PersistentList<ARGState>> outgoingSegmentMap = SlicingAbstractionsUtils.calculateOutgoingSegments(originalState);
        Map<ARGState, PersistentList<ARGState>> incomingSegmentMap = SlicingAbstractionsUtils.calculateIncomingSegments(originalState);
        for (Map.Entry entry : outgoingSegmentMap.entrySet()) {
            ARGState endState = (ARGState)entry.getKey();
            intermediateStateList = (List)entry.getValue();
            SlicingAbstractionsUtils.copyEdge(intermediateStateList, originalState, endState, forkedState, endState, pReached);
            if (!endState.equals(originalState)) continue;
            SlicingAbstractionsUtils.copyEdge(intermediateStateList, originalState, endState, forkedState, forkedState, pReached);
        }
        for (Map.Entry<Object, Object> entry : incomingSegmentMap.entrySet()) {
            ARGState startState = (ARGState)entry.getKey();
            intermediateStateList = (List)entry.getValue();
            SlicingAbstractionsUtils.copyEdge(intermediateStateList, startState, originalState, startState, forkedState, pReached);
        }
    }

    private static void copyEdge(List<ARGState> pSegmentStates, ARGState oldStartState, ARGState oldEndState, ARGState newStartState, ARGState newEndState, ARGReachedSet pReached) {
        if (oldEndState.getParents().contains(oldStartState)) {
            if (oldStartState instanceof SLARGState) {
                EdgeSet newEdgeSet = new EdgeSet(((SLARGState)oldStartState).getEdgeSetToChild(oldEndState));
                ((SLARGState)newEndState).addParent((SLARGState)newStartState, newEdgeSet);
            } else {
                newEndState.addParent(newStartState);
            }
            if (newEndState.equals(newStartState)) {
                // empty if block
            }
        }
        ArrayList<ARGState> newSegmentStates = new ArrayList<ARGState>();
        for (ARGState existingState : pSegmentStates) {
            ARGState newState = !(existingState instanceof SLARGState) ? new ARGState(existingState.getWrappedState(), null) : new SLARGState((SLARGState)existingState);
            newState.makeTwinOf(existingState);
            newSegmentStates.add(newState);
            for (ARGState parent : existingState.getParents()) {
                if (!pSegmentStates.contains(parent)) continue;
                SlicingAbstractionsUtils.copyParent(parent, existingState, (ARGState)newSegmentStates.get(pSegmentStates.indexOf(parent)), newState);
            }
            if (existingState.getParents().contains(oldStartState)) {
                SlicingAbstractionsUtils.copyParent(oldStartState, existingState, newStartState, newState);
            }
            if (!existingState.getChildren().contains(oldEndState)) continue;
            SlicingAbstractionsUtils.copyParent(existingState, oldEndState, newState, newEndState);
        }
        SlicingAbstractionsUtils.addForkedStatesToReachedSet(newSegmentStates, pSegmentStates, pReached);
    }

    private static void addForkedStatesToReachedSet(List<ARGState> newStates, List<ARGState> originalStates, ARGReachedSet pReached) {
        Preconditions.checkArgument((newStates.size() == originalStates.size() ? 1 : 0) != 0);
        for (int i = 0; i < newStates.size(); ++i) {
            pReached.addForkedState(newStates.get(i), originalStates.get(i));
        }
    }

    private static void copyParent(ARGState oldParent, ARGState oldState, ARGState newParent, ARGState newState) {
        if (!(newParent instanceof SLARGState)) {
            newState.addParent(newParent);
        } else {
            EdgeSet newEdgeSet = new EdgeSet(((SLARGState)oldParent).getEdgeSetToChild(oldState));
            ((SLARGState)newState).addParent((SLARGState)newParent, newEdgeSet);
        }
    }

    public static boolean checkProgress(UnmodifiableReachedSet pReached, ARGPath pErrorPath) {
        ImmutableSet<ARGState> rootStates = ARGUtils.getRootStates(pReached);
        assert (rootStates.size() == 1);
        ARGState root = (ARGState)rootStates.iterator().next();
        List<ARGState> abstractionStatesTrace = PredicateCPARefiner.filterAbstractionStates(pErrorPath);
        assert (abstractionStatesTrace.get(0).getStateId() != 0);
        for (int i = -1; i < abstractionStatesTrace.size() - 1; ++i) {
            ARGState first = i == -1 ? root : abstractionStatesTrace.get(i);
            ARGState second = abstractionStatesTrace.get(i + 1);
            if (SlicingAbstractionsUtils.calculateOutgoingSegments(first).containsKey((Object)second)) continue;
            return true;
        }
        return false;
    }

    public static Set<ARGState> getStatesOnErrorPath(ARGState errorState) {
        ARGPath path;
        if (errorState.getCounterexampleInformation().isPresent()) {
            CounterexampleInfo cexInfo = errorState.getCounterexampleInformation().orElseThrow();
            path = cexInfo.getTargetPath();
        } else {
            path = ARGUtils.getOnePathTo(errorState);
        }
        ImmutableList abstractionStatesOnErrorPath = FluentIterable.from(path.asStatesList()).filter(x -> SlicingAbstractionsUtils.isAbstractionState(x)).toList();
        HashSet<ARGState> statesOnErrorPath = new HashSet<ARGState>((Collection<ARGState>)abstractionStatesOnErrorPath);
        for (int i = 0; i < abstractionStatesOnErrorPath.size() - 1; ++i) {
            ARGState start = (ARGState)abstractionStatesOnErrorPath.get(i);
            ARGState stop = (ARGState)abstractionStatesOnErrorPath.get(i + 1);
            statesOnErrorPath.addAll((Collection)SlicingAbstractionsUtils.calculateOutgoingSegments(start).get((Object)stop));
        }
        return statesOnErrorPath;
    }

    private static Set<CFANode> getIncomingLocations(SLARGState pState) {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        for (ARGState parent : pState.getParents()) {
            for (CFAEdge edge : ((SLARGState)parent).getEdgeSetToChild(pState)) {
                locations.add((Object)edge.getSuccessor());
            }
        }
        return locations.build();
    }

    private static Set<CFANode> getOutgoingLocations(SLARGState pState) {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        for (ARGState child : pState.getChildren()) {
            for (CFAEdge edge : pState.getEdgeSetToChild(child)) {
                locations.add((Object)edge.getPredecessor());
            }
        }
        return locations.build();
    }

    public static void removeIncomingEdgesWithLocationMismatch(SLARGState state) {
        if (state.isTarget() || state.getParents().isEmpty()) {
            return;
        }
        Set<CFANode> locations = SlicingAbstractionsUtils.getOutgoingLocations(state);
        ArrayList<ARGState> toRemove = new ArrayList<ARGState>();
        for (ARGState parent : state.getParents()) {
            EdgeSet edgeSet = ((SLARGState)parent).getEdgeSetToChild(state);
            if (edgeSet == null) continue;
            Iterator<CFAEdge> it = edgeSet.iterator();
            while (it.hasNext()) {
                CFAEdge edge = it.next();
                if (locations.contains(edge.getSuccessor())) continue;
                it.remove();
            }
            if (!edgeSet.isEmpty()) continue;
            toRemove.add(parent);
        }
        for (ARGState parent : toRemove) {
            state.removeParent(parent);
        }
    }

    public static void removeOutgoingEdgesWithLocationMismatch(SLARGState state) {
        if (state.isTarget() || state.getParents().isEmpty()) {
            return;
        }
        Set<CFANode> locations = SlicingAbstractionsUtils.getIncomingLocations(state);
        ArrayList<ARGState> toRemove = new ArrayList<ARGState>();
        for (ARGState child : state.getChildren()) {
            EdgeSet edgeSet = state.getEdgeSetToChild(child);
            if (edgeSet == null) continue;
            Iterator<CFAEdge> it = edgeSet.iterator();
            while (it.hasNext()) {
                CFAEdge edge = it.next();
                if (locations.contains(edge.getPredecessor())) continue;
                it.remove();
            }
            if (!edgeSet.isEmpty()) continue;
            toRemove.add(child);
        }
        for (ARGState child : toRemove) {
            child.removeParent(state);
        }
    }

    private static boolean blk(ARGState pState) {
        if (pState.getParents().isEmpty()) {
            return true;
        }
        if (pState.isTarget()) {
            return true;
        }
        if (SlicingAbstractionsUtils.calculateStartStates(pState).size() > 1) {
            return true;
        }
        if (SlicingAbstractionsUtils.calculateOutgoingSegments(pState).containsKey((Object)pState)) {
            return true;
        }
        if (pState instanceof SLARGState) {
            if (!pState.getParents().stream().map(parent -> ((SLARGState)parent).getEdgeSetToChild(pState)).allMatch(x -> x.size() == 1)) {
                return true;
            }
            if (!pState.getChildren().stream().map(child -> ((SLARGState)pState).getEdgeSetToChild((ARGState)child)).allMatch(x -> x.size() == 1)) {
                return true;
            }
        }
        return SlicingAbstractionsUtils.calculateIncomingSegments(pState).entrySet().size() > 1 || SlicingAbstractionsUtils.calculateOutgoingSegments(pState).entrySet().size() > 1;
    }

    static boolean performDynamicBlockEncoding(ARGReachedSet pArgReachedSet) {
        boolean changed = false;
        for (AbstractState state : new ArrayList<AbstractState>(pArgReachedSet.asReachedSet().asCollection())) {
            ARGState currentState = (ARGState)state;
            PredicateAbstractState predState = PredicateAbstractState.getPredicateState(currentState);
            assert (predState != null);
            if (predState.isAbstractionState() && !SlicingAbstractionsUtils.blk(currentState)) {
                changed = true;
                PredicateAbstractState replacement = PredicateAbstractState.mkNonAbstractionState(predState.getPathFormula(), predState.getAbstractionFormula(), predState.getAbstractionLocationsOnPath());
                AbstractState newState = currentState.forkWithReplacements(Collections.singleton(replacement));
                currentState.replaceInARGWith((ARGState)newState);
                pArgReachedSet.addForkedState((ARGState)newState, (ARGState)state);
                if (!(newState instanceof SLARGState)) continue;
                SlicingAbstractionsUtils.removeIncomingEdgesWithLocationMismatch((SLARGState)newState);
                SlicingAbstractionsUtils.removeOutgoingEdgesWithLocationMismatch((SLARGState)newState);
                continue;
            }
            if (!predState.isAbstractionState() || ((ARGState)state).getParents().isEmpty() || !(state instanceof SLARGState)) continue;
            SlicingAbstractionsUtils.removeOutgoingEdgesWithLocationMismatch((SLARGState)state);
        }
        return changed;
    }

    public static enum AbstractionPosition {
        START,
        END;

        public static final ImmutableSet<AbstractionPosition> BOTH;
        public static final ImmutableSet<AbstractionPosition> NONE;
        public static final ImmutableSet<AbstractionPosition> ONLY_START;
        public static final ImmutableSet<AbstractionPosition> ONLY_END;

        static {
            BOTH = Sets.immutableEnumSet((Enum)START, (Enum[])new AbstractionPosition[]{END});
            NONE = ImmutableSet.of();
            ONLY_START = Sets.immutableEnumSet((Enum)START, (Enum[])new AbstractionPosition[0]);
            ONLY_END = Sets.immutableEnumSet((Enum)END, (Enum[])new AbstractionPosition[0]);
        }
    }
}

