/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProviderImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.SolverException;

public class SymbolicLocationsUtility {
    private CFA cfa;
    private Solver solver;
    private FormulaManagerView fmgr;
    private PredicateAbstractionManager pamgr;
    private PathFormulaManager pfmgr;
    private ImmutableSet<CFANode> targetNodes;

    public SymbolicLocationsUtility(PredicateCPA pPredicateCpa, Specification pSpecification) {
        this.cfa = pPredicateCpa.getCfa();
        this.solver = pPredicateCpa.getSolver();
        this.fmgr = this.solver.getFormulaManager();
        this.pamgr = pPredicateCpa.getPredicateManager();
        this.pfmgr = pPredicateCpa.getPathFormulaManager();
        TargetLocationProviderImpl tlp = new TargetLocationProviderImpl(pPredicateCpa.getShutdownNotifier(), pPredicateCpa.getLogger(), this.cfa);
        this.targetNodes = tlp.tryGetAutomatonTargetLocations(this.cfa.getMainFunction(), pSpecification);
    }

    public PredicateAbstractState makePredicateState(boolean init, boolean error) throws InterruptedException {
        return PredicateAbstractState.mkAbstractionState(this.pfmgr.makeEmptyPathFormula(), this.pamgr.asAbstraction(this.makeStateFormula(init, error), this.pfmgr.makeEmptyPathFormula()), (PersistentMap<CFANode, Integer>)PathCopyingPersistentTreeMap.of());
    }

    public BooleanFormula makeStateFormula(boolean init, boolean error) {
        BooleanFormula formula = null;
        formula = init ? this.makeInit() : this.fmgr.makeNot(this.makeInit());
        formula = error ? this.fmgr.makeAnd(formula, this.makeError()) : this.fmgr.makeAnd(formula, this.solver.getFormulaManager().makeNot(this.makeError()));
        return formula;
    }

    public BooleanFormula makeInit() {
        return this.makeProgramCounter(this.cfa.getMainFunction());
    }

    public BooleanFormula makeError() {
        BooleanFormula formula = null;
        for (CFANode node : this.targetNodes) {
            if (formula == null) {
                formula = this.makeProgramCounter(node);
                continue;
            }
            formula = this.fmgr.makeOr(formula, this.makeProgramCounter(node));
        }
        if (formula == null) {
            return this.fmgr.getBooleanFormulaManager().makeFalse();
        }
        return formula;
    }

    public BooleanFormula makeProgramCounter(CFANode pNode) {
        BitvectorFormula pc = (BitvectorFormula)this.fmgr.makeVariable(FormulaType.getBitvectorTypeWithSize((int)32), "%pc");
        BitvectorFormula pc0 = (BitvectorFormula)this.fmgr.makeNumber(FormulaType.getBitvectorTypeWithSize((int)32), pNode.getNodeNumber());
        BooleanFormula formula = this.fmgr.assignment(pc, pc0);
        return formula;
    }

    public boolean isInit(AbstractState pAbsElement) throws SolverException, InterruptedException {
        PredicateAbstractState predicateState = (PredicateAbstractState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(pAbsElement, PredicateAbstractState.class));
        return !this.solver.isUnsat(this.fmgr.makeAnd(this.makeInit(), predicateState.getAbstractionFormula().asFormula()));
    }

    public boolean isError(AbstractState pAbsElement) throws SolverException, InterruptedException {
        PredicateAbstractState predicateState = (PredicateAbstractState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(pAbsElement, PredicateAbstractState.class));
        return !this.solver.isUnsat(this.fmgr.makeAnd(this.makeError(), predicateState.getAbstractionFormula().asFormula()));
    }
}

