/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.counterexamples;

import com.google.common.collect.Lists;
import com.google.errorprone.annotations.ForOverride;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.AbstractSetBasedCounterexampleFilter;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.counterexamples.InterpolantPredicatesCounterexampleFilter;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;

abstract class AbstractNegatedPathCounterexampleFilter<T>
extends AbstractSetBasedCounterexampleFilter<T> {
    private final LogManager logger;
    private final PathFormulaManager pfmgr;

    protected AbstractNegatedPathCounterexampleFilter(Configuration pConfig, LogManager pLogger, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pCpa);
        PredicateCPA predicateCpa = CPAs.retrieveCPAOrFail(pCpa, PredicateCPA.class, InterpolantPredicatesCounterexampleFilter.class);
        this.logger = pLogger;
        this.pfmgr = predicateCpa.getPathFormulaManager();
    }

    @Override
    protected Optional<T> getCounterexampleRepresentation(CounterexampleInfo counterexample) throws InterruptedException {
        CFAEdge edge;
        List<CFAEdge> edges = counterexample.getTargetPath().getInnerEdges();
        int cutPoint = edges.size() - 1;
        Iterator iterator = Lists.reverse(edges).iterator();
        while (iterator.hasNext() && !((edge = (CFAEdge)iterator.next()) instanceof AssumeEdge)) {
            --cutPoint;
        }
        if (cutPoint < 0) {
            return Optional.empty();
        }
        AssumeEdge lastAssumeEdge = (AssumeEdge)edges.get(cutPoint);
        List<CFAEdge> prefix = edges.subList(0, cutPoint);
        PathFormula pf = this.pfmgr.makeEmptyPathFormula();
        ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>(prefix.size() + 1);
        try {
            for (CFAEdge edge2 : prefix) {
                pf = this.pfmgr.makeAnd(pf, edge2);
                formulas.add(pf.getFormula());
                pf = this.pfmgr.makeEmptyPathFormulaWithContextFrom(pf);
            }
            pf = this.pfmgr.makeAnd(pf, CFAUtils.getComplimentaryAssumeEdge(lastAssumeEdge));
            formulas.add(pf.getFormula());
        }
        catch (CPATransferException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Failed to filter counterexample");
            return Optional.empty();
        }
        return this.getCounterexampleRepresentation(formulas);
    }

    @ForOverride
    protected abstract Optional<T> getCounterexampleRepresentation(List<BooleanFormula> var1) throws InterruptedException;
}

