/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.counterexamples;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.counterexamples.AbstractNegatedPathCounterexampleFilter;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class UnsatCoreCounterexampleFilter
extends AbstractNegatedPathCounterexampleFilter<ImmutableList<BooleanFormula>> {
    private final LogManager logger;
    private final Solver solver;

    public UnsatCoreCounterexampleFilter(Configuration pConfig, LogManager pLogger, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pCpa);
        this.logger = pLogger;
        PredicateCPA predicateCpa = CPAs.retrieveCPAOrFail(pCpa, PredicateCPA.class, UnsatCoreCounterexampleFilter.class);
        this.solver = predicateCpa.getSolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<ImmutableList<BooleanFormula>> getCounterexampleRepresentation(List<BooleanFormula> formulas) throws InterruptedException {
        try (ProverEnvironment thmProver = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            Optional<ImmutableList<BooleanFormula>> optional;
            for (BooleanFormula f : formulas) {
                thmProver.push(f);
            }
            if (!thmProver.isUnsat()) {
                optional = Optional.empty();
                return optional;
            }
            optional = Optional.of(ImmutableList.copyOf((Collection)thmProver.getUnsatCore()));
            return optional;
        }
        catch (SolverException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Solving failed on counterexample path, cannot filter this counterexample");
            return Optional.empty();
        }
    }
}

