/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class LoopInvariantsWriter {
    private final CFA cfa;
    private final LogManager logger;
    private final AbstractionManager absmgr;
    private final FormulaManagerView fmgr;
    private final RegionManager rmgr;

    public LoopInvariantsWriter(CFA pCfa, LogManager pLogger, AbstractionManager pAbsMgr, FormulaManagerView pFmMgr, RegionManager pRegMgr) {
        this.cfa = pCfa;
        this.logger = pLogger;
        this.absmgr = pAbsMgr;
        this.fmgr = pFmMgr;
        this.rmgr = pRegMgr;
    }

    private Map<CFANode, Region> getLoopHeadInvariants(UnmodifiableReachedSet reached) {
        if (!this.cfa.getAllLoopHeads().isPresent()) {
            this.logger.log(Level.WARNING, new Object[]{"Cannot dump loop invariants because loop-structure information is not available."});
            return null;
        }
        HashMap<CFANode, Region> regions = new HashMap<CFANode, Region>();
        for (AbstractState state : reached) {
            CFANode loc = AbstractStates.extractLocation(state);
            if (!this.cfa.getAllLoopHeads().orElseThrow().contains((Object)loc)) continue;
            PredicateAbstractState predicateState = PredicateAbstractState.getPredicateState(state);
            if (!predicateState.isAbstractionState()) {
                this.logger.log(Level.WARNING, new Object[]{"Cannot dump loop invariants because a non-abstraction state was found for a loop-head location."});
                return null;
            }
            Region region = regions.getOrDefault(loc, this.rmgr.makeFalse());
            region = this.rmgr.makeOr(region, predicateState.getAbstractionFormula().asRegion());
            regions.put(loc, region);
        }
        return regions;
    }

    public void exportLoopInvariants(Path invariantsFile, UnmodifiableReachedSet reached) {
        Map<CFANode, Region> regions = this.getLoopHeadInvariants(reached);
        if (regions == null) {
            return;
        }
        try (Writer writer = IO.openOutputFile((Path)invariantsFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            for (CFANode loc : FluentIterable.from((Iterable)((Iterable)this.cfa.getAllLoopHeads().orElseThrow())).toSortedSet(Comparator.comparingInt(CFANode::getNodeNumber))) {
                Region region = regions.getOrDefault(loc, this.rmgr.makeFalse());
                BooleanFormula formula = this.absmgr.convertRegionToFormula(region);
                writer.append("loop__");
                writer.append(loc.getFunctionName());
                writer.append("__");
                writer.append("" + (loc.getNumLeavingEdges() == 0 ? 0 : loc.getLeavingEdge(0).getLineNumber()));
                writer.append(":\n");
                this.fmgr.dumpFormula(formula).appendTo((Appendable)writer);
                writer.append('\n');
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write loop invariants to file");
        }
    }

    public void exportLoopInvariantsAsPrecision(Path invariantPrecisionsFile, UnmodifiableReachedSet reached) {
        Map<CFANode, Region> regions = this.getLoopHeadInvariants(reached);
        if (regions == null) {
            return;
        }
        HashSet<String> uniqueDefs = new HashSet<String>();
        StringBuilder asserts = new StringBuilder();
        try (Writer writer = IO.openOutputFile((Path)invariantPrecisionsFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            for (CFANode loc : FluentIterable.from((Iterable)((Iterable)this.cfa.getAllLoopHeads().orElseThrow())).toSortedSet(Comparator.comparingInt(CFANode::getNodeNumber))) {
                Region region = regions.getOrDefault(loc, this.rmgr.makeFalse());
                BooleanFormula formula = this.absmgr.convertRegionToFormula(region);
                Pair<String, List<String>> locInvariant = PredicatePersistenceUtils.splitFormula(this.fmgr, formula);
                for (String def : locInvariant.getSecond()) {
                    if (!uniqueDefs.add(def)) continue;
                    writer.append(def);
                    writer.append("\n");
                }
                asserts.append(loc.getFunctionName());
                asserts.append(" ");
                asserts.append(loc.toString());
                asserts.append(":\n");
                asserts.append(locInvariant.getFirst());
                asserts.append("\n\n");
            }
            writer.append("\n");
            writer.append(asserts);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write loop invariants to file");
        }
    }
}

