/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.OptionalInt;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.Converter;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.FormulaParser;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class PredicateAbstractionsStorage {
    private static final Pattern NODE_DECLARATION_PATTERN = Pattern.compile("^[0-9]+[ ]*\\(([0-9]+[,]*)*\\)[ ]*(@[0-9]+)$");
    private final Path abstractionsFile;
    private final FormulaManagerView fmgr;
    protected final LogManager logger;
    private final Converter converter;
    private Integer rootAbstractionId = null;
    private ImmutableMap<Integer, AbstractionNode> abstractions = ImmutableMap.of();
    private ImmutableListMultimap<Integer, Integer> abstractionTree = ImmutableListMultimap.of();
    private Set<Integer> reusedAbstractions = new TreeSet<Integer>();

    public PredicateAbstractionsStorage(Path pFile, LogManager pLogger, FormulaManagerView pFmgr, @Nullable Converter pConverter) throws PredicatePersistenceUtils.PredicateParsingFailedException {
        this.fmgr = pFmgr;
        this.logger = pLogger;
        this.abstractionsFile = pFile;
        this.converter = pConverter;
        if (pFile != null) {
            try {
                IO.checkReadableFile((Path)pFile);
                this.parseAbstractionTree();
            }
            catch (IOException e) {
                throw new PredicatePersistenceUtils.PredicateParsingFailedException(e, "Init", 0);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void parseAbstractionTree() throws IOException, PredicatePersistenceUtils.PredicateParsingFailedException {
        LinkedHashMultimap resultTree = LinkedHashMultimap.create();
        TreeMap<Integer, AbstractionNode> resultAbstractions = new TreeMap<Integer, AbstractionNode>();
        TreeSet abstractionsWithParents = new TreeSet();
        String source = this.abstractionsFile.getFileName().toString();
        try (BufferedReader reader = Files.newBufferedReader(this.abstractionsFile, StandardCharsets.US_ASCII);){
            String currentLine;
            Pair<Integer, String> defParsingResult = PredicatePersistenceUtils.parseCommonDefinitions(reader, this.abstractionsFile.toString());
            int lineNo = defParsingResult.getFirst();
            String commonDefinitions = this.convert(defParsingResult.getSecond());
            int currentAbstractionId = -1;
            OptionalInt currentLocationId = OptionalInt.empty();
            TreeSet<Integer> currentSuccessors = new TreeSet<Integer>();
            AbstractionsParserState parserState = AbstractionsParserState.EXPECT_NODE_DECLARATION;
            while ((currentLine = reader.readLine()) != null) {
                BooleanFormula f;
                ++lineNo;
                if ((currentLine = currentLine.trim()).isEmpty() || currentLine.startsWith("//")) continue;
                if (parserState == AbstractionsParserState.EXPECT_NODE_DECLARATION) {
                    if (!currentLine.endsWith(":")) {
                        throw new PredicatePersistenceUtils.PredicateParsingFailedException(currentLine + " is not a valid abstraction header", source, lineNo);
                    }
                    if ((currentLine = currentLine.substring(0, currentLine.length() - 1).trim()).isEmpty()) {
                        throw new PredicatePersistenceUtils.PredicateParsingFailedException("empty header is not allowed", source, lineNo);
                    }
                    if (!NODE_DECLARATION_PATTERN.matcher(currentLine).matches()) {
                        throw new PredicatePersistenceUtils.PredicateParsingFailedException(currentLine + " is not a valid abstraction header", source, lineNo);
                    }
                    currentLocationId = null;
                    StringTokenizer declarationTokenizer = new StringTokenizer(currentLine, " (,):");
                    currentAbstractionId = Integer.parseInt(declarationTokenizer.nextToken());
                    while (declarationTokenizer.hasMoreTokens()) {
                        String token = declarationTokenizer.nextToken().trim();
                        if (token.isEmpty()) continue;
                        if (token.startsWith("@")) {
                            currentLocationId = OptionalInt.of(Integer.parseInt(token.substring(1)));
                            continue;
                        }
                        int successorId = Integer.parseInt(token);
                        currentSuccessors.add(successorId);
                    }
                    parserState = AbstractionsParserState.EXPECT_NODE_ABSTRACTION;
                    continue;
                }
                if (parserState != AbstractionsParserState.EXPECT_NODE_ABSTRACTION) continue;
                if (!currentLine.startsWith("(assert ") && currentLine.endsWith(")")) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException("unexpected line " + currentLine, source, lineNo);
                }
                currentLine = this.convert(currentLine);
                try {
                    f = this.fmgr.parse(commonDefinitions + currentLine);
                }
                catch (IllegalArgumentException e) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException(e, "Formula parsing", lineNo);
                }
                AbstractionNode abstractionNode = new AbstractionNode(currentAbstractionId, f, currentLocationId);
                resultAbstractions.put(currentAbstractionId, abstractionNode);
                resultTree.putAll((Object)currentAbstractionId, currentSuccessors);
                abstractionsWithParents.addAll(currentSuccessors);
                currentAbstractionId = -1;
                currentSuccessors.clear();
                parserState = AbstractionsParserState.EXPECT_NODE_DECLARATION;
            }
        }
        Sets.SetView nodesWithNoParents = Sets.difference(resultAbstractions.keySet(), abstractionsWithParents);
        assert (nodesWithNoParents.size() <= 1);
        this.rootAbstractionId = !nodesWithNoParents.isEmpty() ? (Integer)nodesWithNoParents.iterator().next() : null;
        this.abstractions = ImmutableMap.copyOf(resultAbstractions);
        this.abstractionTree = ImmutableListMultimap.copyOf((Multimap)resultTree);
    }

    private String convert(String str) {
        if (this.converter == null) {
            return str;
        }
        LogManagerWithoutDuplicates logger2 = new LogManagerWithoutDuplicates(this.logger);
        StringBuilder out = new StringBuilder();
        for (String line : Splitter.on((char)'\n').split((CharSequence)str)) {
            line = FormulaParser.convertFormula((Converter)Preconditions.checkNotNull((Object)this.converter), line, logger2);
            if (line == null) continue;
            out.append(line).append("\n");
        }
        return out.toString();
    }

    public AbstractionNode getAbstractionNode(int abstractionId) {
        return (AbstractionNode)this.abstractions.get((Object)abstractionId);
    }

    public ImmutableListMultimap<Integer, Integer> getAbstractionTree() {
        return this.abstractionTree;
    }

    public Integer getRootAbstractionId() {
        return this.rootAbstractionId;
    }

    public Set<AbstractionNode> getSuccessorAbstractions(Integer ofAbstractionWithId) {
        LinkedHashSet<AbstractionNode> result = new LinkedHashSet<AbstractionNode>();
        if (this.abstractionTree != null) {
            for (Integer successorId : this.abstractionTree.get((Object)ofAbstractionWithId)) {
                AbstractionNode successor;
                if (successorId == null || (successor = (AbstractionNode)this.abstractions.get((Object)successorId)) == null) continue;
                result.add(successor);
            }
        }
        return result;
    }

    public void markAbstractionBeingReused(Integer abstractionId) {
        Preconditions.checkNotNull((Object)abstractionId);
        this.reusedAbstractions.add(abstractionId);
    }

    public boolean wasAbstractionReused(Integer abstractionId) {
        Preconditions.checkNotNull((Object)abstractionId);
        return this.reusedAbstractions.contains(abstractionId);
    }

    public ImmutableMap<Integer, AbstractionNode> getAbstractions() {
        return this.abstractions;
    }

    private static enum AbstractionsParserState {
        EXPECT_OF_COMMON_DEFINITIONS,
        EXPECT_NODE_DECLARATION,
        EXPECT_NODE_ABSTRACTION;

    }

    public static class AbstractionNode {
        private final int id;
        private final OptionalInt locationId;
        private final BooleanFormula formula;

        public AbstractionNode(int pId, BooleanFormula pFormula, OptionalInt pLocationId) {
            this.id = pId;
            this.formula = pFormula;
            this.locationId = pLocationId;
        }

        public BooleanFormula getFormula() {
            return this.formula;
        }

        public int getId() {
            return this.id;
        }

        public OptionalInt getLocationId() {
            return this.locationId;
        }

        public String toString() {
            return Integer.toString(this.getId());
        }
    }
}

