/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class PredicateAbstractionsWriter {
    private final LogManager logger;
    private final FormulaManagerView fmgr;

    public PredicateAbstractionsWriter(LogManager pLogger, FormulaManagerView pFmMgr) {
        this.logger = pLogger;
        this.fmgr = pFmMgr;
    }

    private int getAbstractionId(ARGState state) {
        return PredicateAbstractState.getPredicateState(state).getAbstractionFormula().getId();
    }

    public void writeAbstractions(Path abstractionsFile, UnmodifiableReachedSet reached) {
        SetMultimap<ARGState, ARGState> successors;
        LinkedHashSet definitions = new LinkedHashSet();
        LinkedHashMap<ARGState, Object> stateToAssert = new LinkedHashMap<ARGState, Object>();
        ArrayDeque<ARGState> worklist = new ArrayDeque<ARGState>();
        if (!reached.isEmpty()) {
            ARGState rootState = AbstractStates.extractStateByType(reached.getFirstState(), ARGState.class);
            if (rootState != null) {
                successors = ARGUtils.projectARG(rootState, ARGState::getChildren, (Predicate<? super ARGState>)((Predicate)PredicateAbstractState::containsAbstractionState));
                worklist.add(rootState);
            } else {
                successors = ImmutableSetMultimap.of();
            }
        } else {
            successors = ImmutableSetMultimap.of();
        }
        HashSet<ARGState> done = new HashSet<ARGState>();
        try (Writer writer = IO.openOutputFile((Path)abstractionsFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            while (!worklist.isEmpty()) {
                ARGState state = (ARGState)worklist.pop();
                if (done.contains(state)) continue;
                worklist.addAll(successors.get((Object)state));
                PredicateAbstractState predicateState = PredicateAbstractState.getPredicateState(state);
                BooleanFormula formula = predicateState.getAbstractionFormula().asFormula();
                Pair<String, List<String>> p = PredicatePersistenceUtils.splitFormula(this.fmgr, formula);
                String formulaString = p.getFirst();
                definitions.addAll(p.getSecond());
                stateToAssert.put(state, formulaString);
                done.add(state);
            }
            PredicatePersistenceUtils.LINE_JOINER.appendTo((Appendable)writer, definitions);
            writer.append("\n\n");
            for (Map.Entry entry : stateToAssert.entrySet()) {
                ARGState state = (ARGState)entry.getKey();
                StringBuilder stateSuccessorsSb = new StringBuilder();
                for (ARGState successor : successors.get((Object)state)) {
                    if (stateSuccessorsSb.length() > 0) {
                        stateSuccessorsSb.append(",");
                    }
                    stateSuccessorsSb.append(this.getAbstractionId(successor));
                }
                CFANode locationNode = AbstractStates.extractLocation(state);
                String locationString = locationNode != null ? Integer.toString(locationNode.getNodeNumber()) : AbstractStates.extractLocations(state).toString();
                writer.append(String.format("%d (%s) @%s:", this.getAbstractionId(state), stateSuccessorsSb.toString(), locationString));
                writer.append("\n");
                writer.append((CharSequence)entry.getValue());
                writer.append("\n\n");
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write abstractions to file");
        }
    }
}

