/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionBootstrapper;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.Converter;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.FormulaParser;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class PredicateMapParser {
    private static final String FUNCTION_NAME_REGEX = "([_a-zA-Z][_a-zA-Z0-9]*)";
    private static final String CFA_NODE_REGEX = "N([0-9][0-9]*)";
    private static final Pattern FUNCTION_NAME_PATTERN = Pattern.compile("^([_a-zA-Z][_a-zA-Z0-9]*)$");
    private static final Pattern CFA_NODE_PATTERN = Pattern.compile("^([_a-zA-Z][_a-zA-Z0-9]*) N([0-9][0-9]*)$");
    private final CFA cfa;
    private final LogManagerWithoutDuplicates logger;
    private final FormulaManagerView fmgr;
    private final AbstractionManager amgr;
    private final Map<Integer, CFANode> idToNodeMap = new HashMap<Integer, CFANode>();
    private final PredicatePrecisionBootstrapper.InitialPredicatesOptions options;

    public PredicateMapParser(CFA pCfa, LogManager pLogger, FormulaManagerView pFmgr, AbstractionManager pAmgr, PredicatePrecisionBootstrapper.InitialPredicatesOptions pOptions) {
        this.cfa = pCfa;
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.fmgr = pFmgr;
        this.amgr = pAmgr;
        this.options = pOptions;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public PredicatePrecision parsePredicates(Path file) throws IOException, PredicatePersistenceUtils.PredicateParsingFailedException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.US_ASCII);){
            PredicatePrecision predicatePrecision = this.parsePredicates(reader, file.getFileName().toString());
            return predicatePrecision;
        }
    }

    PredicatePrecision parsePredicates(BufferedReader reader, String source) throws IOException, PredicatePersistenceUtils.PredicateParsingFailedException {
        String currentLine;
        Pair<Integer, String> defParsingResult = PredicatePersistenceUtils.parseCommonDefinitions(reader, source);
        int lineNo = defParsingResult.getFirst();
        String commonDefinitions = defParsingResult.getSecond();
        Converter converter = Converter.getConverter(this.options.getPrecisionConverter(), this.cfa, (LogManager)this.logger);
        if (this.options.getPrecisionConverter() != Converter.PrecisionConverter.DISABLE) {
            StringBuilder str = new StringBuilder();
            for (String line : Splitter.on((char)'\n').split((CharSequence)commonDefinitions)) {
                String converted = this.convertFormula(converter, line);
                if (converted == null) continue;
                str.append(converted).append("\n");
            }
            commonDefinitions = str.toString();
        }
        ArrayList<AbstractionPredicate> globalPredicates = new ArrayList<AbstractionPredicate>();
        ArrayListMultimap functionPredicates = ArrayListMultimap.create();
        ArrayListMultimap localPredicates = ArrayListMultimap.create();
        List<AbstractionPredicate> currentSet = null;
        while ((currentLine = reader.readLine()) != null) {
            ++lineNo;
            if ((currentLine = currentLine.trim()).isEmpty()) {
                currentSet = null;
                continue;
            }
            if (currentLine.startsWith("//")) continue;
            if (currentSet == null) {
                if (!currentLine.endsWith(":")) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException(currentLine + " is not a valid section header", source, lineNo);
                }
                if ((currentLine = currentLine.substring(0, currentLine.length() - 1).trim()).isEmpty()) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException("empty key is not allowed", source, lineNo);
                }
                if (currentLine.equals("*") || this.options.applyGlobally()) {
                    currentSet = globalPredicates;
                    continue;
                }
                if (FUNCTION_NAME_PATTERN.matcher(currentLine).matches()) {
                    if (!this.cfa.getAllFunctionNames().contains(currentLine)) {
                        this.logger.log(Level.WARNING, new Object[]{"Cannot use predicates for function", currentLine + ", this function does not exist."});
                        currentSet = new ArrayList();
                        continue;
                    }
                    currentSet = functionPredicates.get((Object)currentLine);
                    continue;
                }
                Matcher matcher = CFA_NODE_PATTERN.matcher(currentLine);
                if (matcher.matches()) {
                    String function = matcher.group(1);
                    int nodeId = Integer.parseInt(matcher.group(2));
                    if (this.options.applyFunctionWide()) {
                        if (!this.cfa.getAllFunctionNames().contains(function)) {
                            this.logger.log(Level.WARNING, new Object[]{"Cannot use predicates for function", function + ", this function does not exist."});
                            currentSet = new ArrayList();
                            continue;
                        }
                        currentSet = functionPredicates.get((Object)function);
                        continue;
                    }
                    CFANode node = this.getCFANodeWithId(nodeId);
                    if (node == null) {
                        this.logger.log(Level.WARNING, new Object[]{"Cannot use predicates for CFANode", nodeId + ", this node does not exist."});
                        currentSet = new ArrayList();
                        continue;
                    }
                    currentSet = localPredicates.get((Object)node);
                    continue;
                }
                throw new PredicatePersistenceUtils.PredicateParsingFailedException(currentLine + " is not a valid key", source, lineNo);
            }
            if (currentLine.startsWith("(assert ") && currentLine.endsWith(")")) {
                BooleanFormula f;
                if (this.options.getPrecisionConverter() != Converter.PrecisionConverter.DISABLE && (currentLine = this.convertFormula(converter, currentLine)) == null) continue;
                try {
                    f = this.fmgr.parse(commonDefinitions + currentLine);
                }
                catch (IllegalArgumentException e) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException(e, source, lineNo);
                }
                currentSet.add(this.amgr.makePredicate(f));
                continue;
            }
            throw new PredicatePersistenceUtils.PredicateParsingFailedException("unexpected line " + currentLine, source, lineNo);
        }
        return new PredicatePrecision((Multimap<PredicatePrecision.LocationInstance, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<CFANode, AbstractionPredicate>)localPredicates, (Multimap<String, AbstractionPredicate>)functionPredicates, globalPredicates);
    }

    private @Nullable String convertFormula(Converter converter, String line) {
        return FormulaParser.convertFormula((Converter)Preconditions.checkNotNull((Object)converter), line, this.logger);
    }

    private CFANode getCFANodeWithId(int id) {
        if (this.idToNodeMap.isEmpty()) {
            for (CFANode n : this.cfa.getAllNodes()) {
                this.idToNodeMap.put(n.getNodeNumber(), n);
            }
        }
        return this.idToNodeMap.get(id);
    }
}

