/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;

@Options(prefix="cpa.predicate")
public class PredicateMapWriter {
    @Option(secure=true, name="predmap.predicateFormat", description="Format for exporting predicates from precisions.")
    private PredicatePersistenceUtils.PredicateDumpFormat format = PredicatePersistenceUtils.PredicateDumpFormat.SMTLIB2;
    private final FormulaManagerView fmgr;

    public PredicateMapWriter(Configuration config, FormulaManagerView pFmgr) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.fmgr = pFmgr;
    }

    public void writePredicateMap(SetMultimap<PredicatePrecision.LocationInstance, AbstractionPredicate> locationInstancePredicates, SetMultimap<CFANode, AbstractionPredicate> localPredicates, SetMultimap<String, AbstractionPredicate> functionPredicates, Set<AbstractionPredicate> globalPredicates, Collection<AbstractionPredicate> allPredicates, Appendable sb) throws IOException {
        Object key;
        LinkedHashSet definitions = new LinkedHashSet();
        HashMap<AbstractionPredicate, String> predToString = new HashMap<AbstractionPredicate, String>();
        for (AbstractionPredicate abstractionPredicate : allPredicates) {
            String predString;
            if (this.format == PredicatePersistenceUtils.PredicateDumpFormat.SMTLIB2) {
                Pair<String, List<String>> p = PredicatePersistenceUtils.splitFormula(this.fmgr, abstractionPredicate.getSymbolicAtom());
                predString = p.getFirst();
                definitions.addAll(p.getSecond());
            } else {
                predString = abstractionPredicate.getSymbolicAtom().toString();
            }
            predToString.put(abstractionPredicate, predString);
        }
        PredicatePersistenceUtils.LINE_JOINER.appendTo(sb, definitions);
        sb.append("\n\n");
        this.writeSetOfPredicates(sb, "*", globalPredicates, predToString);
        for (Map.Entry entry : functionPredicates.asMap().entrySet()) {
            this.writeSetOfPredicates(sb, (String)entry.getKey(), (Collection)entry.getValue(), predToString);
        }
        for (Map.Entry entry : localPredicates.asMap().entrySet()) {
            key = ((CFANode)entry.getKey()).getFunctionName() + " " + entry.getKey();
            this.writeSetOfPredicates(sb, (String)key, (Collection)entry.getValue(), predToString);
        }
        for (Map.Entry entry : locationInstancePredicates.asMap().entrySet()) {
            key = String.format("%s %s@%d", ((PredicatePrecision.LocationInstance)entry.getKey()).getFunctionName(), ((PredicatePrecision.LocationInstance)entry.getKey()).getLocation(), ((PredicatePrecision.LocationInstance)entry.getKey()).getInstance());
            this.writeSetOfPredicates(sb, (String)key, (Collection)entry.getValue(), predToString);
        }
    }

    private void writeSetOfPredicates(Appendable sb, String key, Collection<AbstractionPredicate> predicates, Map<AbstractionPredicate, String> predToString) throws IOException {
        if (!predicates.isEmpty()) {
            sb.append(key);
            sb.append(":\n");
            for (AbstractionPredicate pred : predicates) {
                sb.append((CharSequence)Preconditions.checkNotNull((Object)predToString.get(pred)));
                sb.append('\n');
            }
            sb.append('\n');
        }
    }
}

