/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;

@RunWith(value=Parameterized.class)
public class PredicatePersistenceTest
extends SolverViewBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverToUse;

    @Parameterized.Parameters(name="{0}")
    public static SolverContextFactory.Solvers[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverToUse;
    }

    @Test
    public void testSplitFormula_Syntactically() {
        BooleanFormula f1 = this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable_with_long_name")), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        BooleanFormula f2 = this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable_with_long_name2")), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable_with_long_name")));
        BooleanFormula f = this.bmgr.and(f1, f2);
        Pair<String, List<String>> result = PredicatePersistenceUtils.splitFormula(this.mgrv, f);
        String assertFormula = result.getFirst();
        List<String> declarationFormulas = result.getSecond();
        Truth.assertThat((String)assertFormula).startsWith("(assert ");
        Truth.assertThat((String)assertFormula).endsWith(")");
        Truth.assertThat((String)assertFormula).doesNotContain((CharSequence)"\n");
        this.assertThatAllParenthesesAreClosed(assertFormula);
        for (String declaration : declarationFormulas) {
            String statement = (String)Splitter.on((char)' ').split((CharSequence)declaration).iterator().next();
            Truth.assertWithMessage((String)"Statement of %s", (Object[])new Object[]{declaration}).that(statement).isAnyOf((Object)"(define-fun", (Object)"(declare-fun", new Object[]{"(set-info", "(set-logic"});
            Truth.assertThat((String)declaration).endsWith(")");
            this.assertThatAllParenthesesAreClosed(declaration);
        }
    }

    private void assertThatAllParenthesesAreClosed(String formula) {
        Truth.assertWithMessage((String)"number of closing parentheses").that(Integer.valueOf(CharMatcher.anyOf((CharSequence)")").countIn((CharSequence)formula))).isEqualTo((Object)CharMatcher.anyOf((CharSequence)"(").countIn((CharSequence)formula));
    }
}

