/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.reachdef;

import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.reachdef.MergeIgnoringCallstack;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefTransferRelation;
import org.sosy_lab.cpachecker.cpa.reachdef.StopIgnoringCallstack;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.reachingdef.ReachingDefUtils;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.reachdef")
public class ReachingDefCPA
extends AbstractCPA
implements ProofChecker.ProofCheckerCPA {
    private LogManager logger;
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN", "IGNORECALLSTACK"}, description="which merge operator to use for ReachingDefCPA")
    private String mergeType = "JOIN";
    @Option(secure=true, name="stop", toUppercase=true, values={"SEP", "JOIN", "IGNORECALLSTACK"}, description="which stop operator to use for ReachingDefCPA")
    private String stopType = "SEP";

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ReachingDefCPA.class);
    }

    private ReachingDefCPA(LogManager logger, Configuration config, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        super(DelegateAbstractDomain.getInstance(), new ReachingDefTransferRelation(logger, shutdownNotifier, config));
        config.inject((Object)this);
        this.logger = logger;
    }

    @Override
    public MergeOperator getMergeOperator() {
        switch (this.mergeType) {
            case "SEP": {
                return MergeSepOperator.getInstance();
            }
            case "JOIN": {
                return new MergeJoinOperator(this.getAbstractDomain());
            }
            case "IGNORECALLSTACK": {
                return new MergeIgnoringCallstack();
            }
        }
        throw new AssertionError((Object)"unknown merge operator");
    }

    @Override
    public StopOperator getStopOperator() {
        switch (this.stopType) {
            case "SEP": {
                return new StopSepOperator(this.getAbstractDomain());
            }
            case "JOIN": {
                return new StopJoinOperator(this.getAbstractDomain());
            }
            case "IGNORECALLSTACK": {
                return new StopIgnoringCallstack();
            }
        }
        throw new AssertionError((Object)"unknown stop operator");
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        this.logger.log(Level.FINE, new Object[]{"Start extracting all declared variables in program.", "Distinguish between local and global variables."});
        Pair<Set<MemoryLocation>, Map<FunctionEntryNode, Set<MemoryLocation>>> result = ReachingDefUtils.getAllVariables(pNode);
        this.logger.log(Level.FINE, new Object[]{"Extracted all declared variables.", "Create initial state."});
        ((ReachingDefTransferRelation)this.getTransferRelation()).provideLocalVariablesOfFunctions(result.getSecond());
        ((ReachingDefTransferRelation)this.getTransferRelation()).setMainFunctionNode(pNode);
        return new ReachingDefState(result.getFirst());
    }
}

