/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.reachdef;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ReachingDefState
implements AbstractState,
Serializable,
LatticeAbstractState<ReachingDefState>,
Graphable {
    private static final long serialVersionUID = -7715698130795640052L;
    private static final SerialProxyReach proxy = new SerialProxyReach();
    public static final ReachingDefState topElement = new ReachingDefState();
    private transient Map<MemoryLocation, Set<DefinitionPoint>> localReachDefs;
    private transient Map<MemoryLocation, Set<DefinitionPoint>> globalReachDefs;
    private Map<CExpression, ProgramDefinitionPoint> unhandled = new HashMap<CExpression, ProgramDefinitionPoint>();

    private ReachingDefState() {
    }

    public ReachingDefState(Set<MemoryLocation> globalVariableNames) {
        this.localReachDefs = new HashMap<MemoryLocation, Set<DefinitionPoint>>();
        this.globalReachDefs = new HashMap<MemoryLocation, Set<DefinitionPoint>>();
        this.addVariables(this.globalReachDefs, globalVariableNames, UninitializedDefinitionPoint.getInstance());
    }

    public ReachingDefState(Map<MemoryLocation, Set<DefinitionPoint>> pLocalReachDefs, Map<MemoryLocation, Set<DefinitionPoint>> pGlobalReachDefs) {
        this.localReachDefs = pLocalReachDefs;
        this.globalReachDefs = pGlobalReachDefs;
    }

    public ReachingDefState addLocalReachDef(MemoryLocation variableName, CFANode pEntry, CFANode pExit) {
        ProgramDefinitionPoint definition = new ProgramDefinitionPoint(pEntry, pExit);
        return new ReachingDefState(this.replaceReachDef(this.localReachDefs, variableName, definition), this.globalReachDefs);
    }

    public ReachingDefState addGlobalReachDef(MemoryLocation variableName, CFANode pEntry, CFANode pExit) {
        ProgramDefinitionPoint definition = new ProgramDefinitionPoint(pEntry, pExit);
        return new ReachingDefState(this.localReachDefs, this.replaceReachDef(this.globalReachDefs, variableName, definition));
    }

    void addUnhandled(CExpression pExp, CFANode pEntry, CFANode pExit) {
        ProgramDefinitionPoint def = new ProgramDefinitionPoint(pEntry, pExit);
        this.unhandled.put(pExp, def);
    }

    Map<CExpression, ProgramDefinitionPoint> getAndResetUnhandled() {
        Map<CExpression, ProgramDefinitionPoint> unhandledExpressions = this.unhandled;
        this.unhandled = new HashMap<CExpression, ProgramDefinitionPoint>();
        return unhandledExpressions;
    }

    private Map<MemoryLocation, Set<DefinitionPoint>> replaceReachDef(Map<MemoryLocation, Set<DefinitionPoint>> toChange, MemoryLocation variableName, ProgramDefinitionPoint definition) {
        HashMap<MemoryLocation, Set<DefinitionPoint>> changed = new HashMap<MemoryLocation, Set<DefinitionPoint>>(toChange);
        ImmutableSet insert = ImmutableSet.of((Object)definition);
        changed.put(variableName, (Set<DefinitionPoint>)insert);
        return changed;
    }

    public ReachingDefState initVariables(Set<MemoryLocation> uninitVariableNames, Set<MemoryLocation> parameters, CFANode pEntry, CFANode pExit) {
        ProgramDefinitionPoint definition = new ProgramDefinitionPoint(pEntry, pExit);
        HashMap<MemoryLocation, Set<DefinitionPoint>> localVarsDef = new HashMap<MemoryLocation, Set<DefinitionPoint>>(this.localReachDefs);
        this.addVariables(localVarsDef, uninitVariableNames, UninitializedDefinitionPoint.getInstance());
        this.addVariables(localVarsDef, parameters, definition);
        return new ReachingDefState(localVarsDef, this.globalReachDefs);
    }

    private void addVariables(Map<MemoryLocation, Set<DefinitionPoint>> addTo, Set<MemoryLocation> variableNames, DefinitionPoint definition) {
        ImmutableSet insert = ImmutableSet.of((Object)definition);
        for (MemoryLocation name : variableNames) {
            addTo.put(name, (Set<DefinitionPoint>)insert);
        }
    }

    public ReachingDefState pop(String pFunctionName) {
        HashMap<MemoryLocation, Set<DefinitionPoint>> newLocalReachs = new HashMap<MemoryLocation, Set<DefinitionPoint>>(this.localReachDefs);
        for (MemoryLocation var : this.localReachDefs.keySet()) {
            if (!var.isOnFunctionStack(pFunctionName)) continue;
            newLocalReachs.remove(var);
        }
        return new ReachingDefState(newLocalReachs, this.globalReachDefs);
    }

    public Map<MemoryLocation, Set<DefinitionPoint>> getLocalReachingDefinitions() {
        return this == topElement ? null : this.localReachDefs;
    }

    public Map<MemoryLocation, Set<DefinitionPoint>> getGlobalReachingDefinitions() {
        return this == topElement ? null : this.globalReachDefs;
    }

    @Override
    public boolean isLessOrEqual(ReachingDefState superset) {
        if (superset == this || superset == topElement) {
            return true;
        }
        boolean isLocalSubset = this.isSubsetOf(this.localReachDefs, superset.localReachDefs);
        return isLocalSubset && this.isSubsetOf(this.globalReachDefs, superset.globalReachDefs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.globalReachDefs, this.localReachDefs);
    }

    @Override
    public boolean equals(Object pO) {
        if (pO instanceof ReachingDefState) {
            ReachingDefState other = (ReachingDefState)pO;
            return Objects.equals(this.globalReachDefs, other.globalReachDefs) && Objects.equals(this.localReachDefs, other.localReachDefs);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toDOTLabel();
    }

    private boolean isSubsetOf(Map<MemoryLocation, Set<DefinitionPoint>> subset, Map<MemoryLocation, Set<DefinitionPoint>> superset) {
        if (subset == superset) {
            return true;
        }
        for (Map.Entry<MemoryLocation, Set<DefinitionPoint>> entry : subset.entrySet()) {
            Set<DefinitionPoint> setSuper;
            Set<DefinitionPoint> setSub = entry.getValue();
            if (setSub == (setSuper = superset.get(entry.getKey())) || setSuper != null && Sets.intersection(setSub, setSuper).size() == setSub.size()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReachingDefState join(ReachingDefState toJoin) {
        Map<MemoryLocation, Set<DefinitionPoint>> newLocal;
        boolean changed = false;
        if (toJoin == this) {
            return this;
        }
        if (toJoin == topElement || this == topElement) {
            return topElement;
        }
        Map<MemoryLocation, Set<DefinitionPoint>> resultOfMapUnion = this.unionMaps(this.localReachDefs, toJoin.localReachDefs);
        if (resultOfMapUnion == this.localReachDefs) {
            newLocal = toJoin.localReachDefs;
        } else {
            changed = true;
            newLocal = resultOfMapUnion;
        }
        resultOfMapUnion = this.unionMaps(this.globalReachDefs, toJoin.globalReachDefs);
        if (resultOfMapUnion == this.globalReachDefs) {
            resultOfMapUnion = toJoin.globalReachDefs;
        } else {
            changed = true;
        }
        if (changed) {
            assert (newLocal != null);
            return new ReachingDefState(newLocal, resultOfMapUnion);
        }
        return toJoin;
    }

    private Map<MemoryLocation, Set<DefinitionPoint>> unionMaps(Map<MemoryLocation, Set<DefinitionPoint>> map1, Map<MemoryLocation, Set<DefinitionPoint>> map2) {
        HashMap<MemoryLocation, Set<DefinitionPoint>> newMap = new HashMap<MemoryLocation, Set<DefinitionPoint>>();
        if (map1 == map2) {
            return map1;
        }
        boolean changed = false;
        Sets.SetView variableUnion = Sets.union(map1.keySet(), map2.keySet());
        for (MemoryLocation var : variableUnion) {
            ImmutableSet defPoints2;
            ImmutableSet defPoints1 = map1.get(var);
            if (defPoints1 == (defPoints2 = map2.get(var))) {
                assert (defPoints1 != null);
                newMap.put(var, (Set<DefinitionPoint>)defPoints1);
                continue;
            }
            if (defPoints1 == null) {
                defPoints1 = ImmutableSet.of();
            } else if (defPoints2 == null) {
                defPoints2 = ImmutableSet.of();
            }
            Set<DefinitionPoint> unionResult = this.unionSets((Set<DefinitionPoint>)defPoints1, (Set<DefinitionPoint>)defPoints2);
            if (unionResult.size() != defPoints1.size() || unionResult.size() != defPoints2.size()) {
                assert (unionResult.size() >= defPoints1.size() && unionResult.size() >= defPoints2.size()) : "Union of map1 and map2 shouldn't be able to shrink!";
                changed = true;
            }
            newMap.put(var, unionResult);
        }
        if (changed) {
            return newMap;
        }
        return map1;
    }

    private Set<DefinitionPoint> unionSets(Set<DefinitionPoint> set1, Set<DefinitionPoint> set2) {
        HashSet<DefinitionPoint> result = new HashSet<DefinitionPoint>(set1);
        result.addAll(set2);
        return result;
    }

    private Object writeReplace() {
        if (this == topElement) {
            return proxy;
        }
        return this;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.localReachDefs.size());
        for (Map.Entry<MemoryLocation, Set<DefinitionPoint>> localReach : this.localReachDefs.entrySet()) {
            out.writeObject(localReach.getKey());
            out.writeObject(localReach.getValue());
        }
        out.writeInt(this.globalReachDefs.size());
        for (Map.Entry<MemoryLocation, Set<DefinitionPoint>> globalReach : this.globalReachDefs.entrySet()) {
            out.writeObject(globalReach.getKey());
            out.writeObject(globalReach.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        in.defaultReadObject();
        int size = in.readInt();
        this.localReachDefs = Maps.newHashMapWithExpectedSize((int)size);
        for (i = 0; i < size; ++i) {
            this.localReachDefs.put((MemoryLocation)in.readObject(), (Set)in.readObject());
        }
        size = in.readInt();
        this.globalReachDefs = Maps.newHashMapWithExpectedSize((int)size);
        for (i = 0; i < size; ++i) {
            this.globalReachDefs.put((MemoryLocation)in.readObject(), (Set)in.readObject());
        }
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\\n");
        sb.append(System.identityHashCode(this));
        sb.append("\\n");
        sb.append("global:");
        sb.append(this.createStringOfMap(this.globalReachDefs));
        sb.append("\\n");
        sb.append("local:");
        sb.append(this.createStringOfMap(this.localReachDefs));
        sb.append("\\n");
        sb.append("}");
        return sb.toString();
    }

    private String createStringOfMap(Map<MemoryLocation, Set<DefinitionPoint>> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        boolean first = true;
        for (Map.Entry<MemoryLocation, Set<DefinitionPoint>> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(" (");
            sb.append(entry.getKey());
            sb.append(": [");
            Joiner.on((String)"; ").appendTo(sb, (Iterable)entry.getValue());
            sb.append("])");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    public static class ProgramDefinitionPoint
    implements DefinitionPoint,
    Serializable {
        private static final long serialVersionUID = -7601382286840053882L;
        private transient CFANode entry;
        private transient CFANode exit;

        public ProgramDefinitionPoint(CFANode pEntry, CFANode pExit) {
            this.entry = pEntry;
            this.exit = pExit;
        }

        public CFANode getDefinitionEntryLocation() {
            return this.entry;
        }

        public CFANode getDefinitionExitLocation() {
            return this.exit;
        }

        public String toString() {
            return "(N" + this.entry.getNodeNumber() + ",N" + this.exit.getNodeNumber() + ")";
        }

        public int hashCode() {
            return Objects.hash(this.entry, this.exit);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProgramDefinitionPoint)) {
                return false;
            }
            ProgramDefinitionPoint other = (ProgramDefinitionPoint)obj;
            return Objects.equals(this.entry, other.entry) && Objects.equals(this.exit, other.exit);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(this.entry.getNodeNumber());
            out.writeInt(this.exit.getNodeNumber());
        }

        private void readObject(ObjectInputStream in) throws IOException {
            int nodeNumber = in.readInt();
            CFAInfo cfaInfo = GlobalInfo.getInstance().getCFAInfo().orElseThrow();
            this.entry = cfaInfo.getNodeByNodeNumber(nodeNumber);
            nodeNumber = in.readInt();
            this.exit = cfaInfo.getNodeByNodeNumber(nodeNumber);
        }
    }

    public static class UninitializedDefinitionPoint
    implements DefinitionPoint,
    Serializable {
        private static final long serialVersionUID = 6987753908487106524L;
        private static UninitializedDefinitionPoint instance = new UninitializedDefinitionPoint();
        private static final SerialProxy writeReplace = new SerialProxy();

        private UninitializedDefinitionPoint() {
        }

        public static UninitializedDefinitionPoint getInstance() {
            return instance;
        }

        public String toString() {
            return "?";
        }

        private Object writeReplace() {
            return writeReplace;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object pO) {
            return pO instanceof UninitializedDefinitionPoint;
        }

        private static class SerialProxy
        implements Serializable {
            private static final long serialVersionUID = 2843708585446089623L;

            private Object readResolve() {
                return instance;
            }
        }
    }

    public static interface DefinitionPoint {
    }

    private static class SerialProxyReach
    implements Serializable {
        private static final long serialVersionUID = 2843708585446089623L;

        private Object readResolve() {
            return topElement;
        }
    }
}

