/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.reachdef;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.reachingdef.ReachingDefUtils;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.reachdef")
public class ReachingDefTransferRelation
implements TransferRelation {
    @Option(secure=true, name="constraintIsDef", description="Whether to consider constraints on program variables (e.g., x > 10) as definitions)")
    private boolean considerConstraintAsDef = false;
    private Map<FunctionEntryNode, Set<MemoryLocation>> localVariablesPerFunction;
    private CFANode main;
    private final LogManagerWithoutDuplicates logger;
    private final ShutdownNotifier shutdownNotifier;

    public ReachingDefTransferRelation(LogManager pLogger, ShutdownNotifier pShutdownNotifier, Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.shutdownNotifier = pShutdownNotifier;
    }

    public void provideLocalVariablesOfFunctions(Map<FunctionEntryNode, Set<MemoryLocation>> localVars) {
        this.localVariablesPerFunction = localVars;
    }

    public void setMainFunctionNode(CFANode pMain) {
        this.main = pMain;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        List<CFANode> nodes = ReachingDefUtils.getAllNodesFromCFA();
        if (nodes == null) {
            throw new CPATransferException("CPA not properly initialized.");
        }
        ArrayList<AbstractState> successors = new ArrayList<AbstractState>();
        ArrayList<CFAEdge> definitions = new ArrayList<CFAEdge>();
        for (CFANode node : nodes) {
            for (CFAEdge cfaedge : CFAUtils.leavingEdges(node)) {
                this.shutdownNotifier.shutdownIfNecessary();
                if (cfaedge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) continue;
                if (cfaedge.getEdgeType() == CFAEdgeType.StatementEdge || cfaedge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
                    definitions.add(cfaedge);
                    continue;
                }
                successors.addAll(this.getAbstractSuccessors0(pState, cfaedge));
            }
        }
        for (CFAEdge edge : definitions) {
            successors.addAll(this.getAbstractSuccessors0(pState, edge));
        }
        return successors;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)pCfaEdge);
        return this.getAbstractSuccessors0(pState, pCfaEdge);
    }

    private Collection<? extends AbstractState> getAbstractSuccessors0(AbstractState pState, CFAEdge pCfaEdge) throws CPATransferException {
        ReachingDefState result;
        this.logger.log(Level.FINE, new Object[]{"Compute successor for ", pState, "along edge", pCfaEdge});
        if (this.localVariablesPerFunction == null) {
            throw new CPATransferException("Incorrect initialization of reaching definition transfer relation.");
        }
        if (!(pState instanceof ReachingDefState)) {
            throw new CPATransferException("Unexpected type of abstract state. The transfer relation is not defined for this type");
        }
        if (pCfaEdge == null) {
            throw new CPATransferException("Expected an edge along which the successors should be computed");
        }
        if (pState == ReachingDefState.topElement) {
            return Collections.singleton(pState);
        }
        switch (pCfaEdge.getEdgeType()) {
            case StatementEdge: {
                result = this.handleStatementEdge((ReachingDefState)pState, (CStatementEdge)pCfaEdge);
                break;
            }
            case DeclarationEdge: {
                result = this.handleDeclarationEdge((ReachingDefState)pState, (CDeclarationEdge)pCfaEdge);
                break;
            }
            case FunctionCallEdge: {
                result = this.handleCallEdge((ReachingDefState)pState, (CFunctionCallEdge)pCfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                result = this.handleReturnEdge((ReachingDefState)pState, (CFunctionReturnEdge)pCfaEdge);
                break;
            }
            case ReturnStatementEdge: {
                result = this.handleReturnStatement((CReturnStatementEdge)pCfaEdge, (ReachingDefState)pState);
                break;
            }
            case AssumeEdge: {
                result = this.handleAssumption((ReachingDefState)pState, (CAssumeEdge)pCfaEdge);
                break;
            }
            case BlankEdge: {
                this.logger.log(Level.FINE, new Object[]{"Start of main function. ", "Add undefined position for local variables of main function. ", "Add definition of parameters of main function."});
                if (Objects.equals(pCfaEdge.getPredecessor(), this.main) && ((ReachingDefState)pState).getLocalReachingDefinitions().size() == 0) {
                    result = ((ReachingDefState)pState).initVariables(this.localVariablesPerFunction.get(pCfaEdge.getPredecessor()), (Set<MemoryLocation>)this.getParameters((CFunctionEntryNode)pCfaEdge.getPredecessor()), pCfaEdge.getPredecessor(), pCfaEdge.getSuccessor());
                    break;
                }
            }
            case CallToReturnEdge: {
                this.logger.log(Level.FINE, new Object[]{"Reaching definition not affected by edge. ", "Keep reaching definition unchanged."});
                result = (ReachingDefState)pState;
                break;
            }
            default: {
                throw new CPATransferException("Unknown CFA edge type.");
            }
        }
        return Collections.singleton(result);
    }

    private ReachingDefState handleAssumption(ReachingDefState pState, CAssumeEdge pCfaEdge) {
        if (!this.considerConstraintAsDef) {
            return pState;
        }
        Collection<CLeftHandSide> lhsExps = pCfaEdge.getExpression().accept(new DefaultCExpressionVisitor<Collection<CLeftHandSide>, NoException>(){

            @Override
            protected Collection<CLeftHandSide> visitDefault(CExpression pExp) throws NoException {
                if (pExp instanceof CLeftHandSide) {
                    return ImmutableList.of((Object)((CLeftHandSide)pExp));
                }
                if (pExp instanceof CLiteralExpression) {
                    return ImmutableList.of();
                }
                if (pExp instanceof CBinaryExpression) {
                    CBinaryExpression binExp = (CBinaryExpression)pExp;
                    Collection<CLeftHandSide> firstRes = binExp.getOperand1().accept(this);
                    Collection<CLeftHandSide> sndRes = binExp.getOperand2().accept(this);
                    HashSet<CLeftHandSide> res = new HashSet<CLeftHandSide>(firstRes);
                    res.addAll(sndRes);
                    return res;
                }
                if (pExp instanceof CUnaryExpression) {
                    return ((CUnaryExpression)pExp).getOperand().accept(this);
                }
                throw new AssertionError((Object)("Unhandled operation: " + pExp));
            }

            @Override
            public Collection<CLeftHandSide> visit(CCastExpression pExp) throws NoException {
                return pExp.getOperand().accept(this);
            }

            @Override
            public Collection<CLeftHandSide> visit(CAddressOfLabelExpression pExp) throws NoException {
                return ImmutableList.of();
            }

            @Override
            public Collection<CLeftHandSide> visit(CTypeIdExpression pExp) throws NoException {
                return ImmutableList.of();
            }
        });
        ReachingDefState newState = pState;
        for (CLeftHandSide lhs : lhsExps) {
            newState = this.handleOperation(pCfaEdge, lhs, newState);
        }
        return newState;
    }

    private ImmutableSet<MemoryLocation> getParameters(CFunctionEntryNode pNode) {
        return Collections3.transformedImmutableSetCopy(pNode.getFunctionParameters(), x -> MemoryLocation.forDeclaration(x));
    }

    private ReachingDefState handleReturnStatement(CReturnStatementEdge pCfaEdge, ReachingDefState pState) {
        Optional<CAssignment> asAssignment = pCfaEdge.asAssignment();
        if (asAssignment.isPresent()) {
            CAssignment assignment = asAssignment.orElseThrow();
            return this.handleStatement(pState, pCfaEdge, assignment);
        }
        return pState;
    }

    private ReachingDefState handleStatement(ReachingDefState pState, CFAEdge pEdge, CStatement pStatement) {
        CLeftHandSide left;
        if (pStatement instanceof CExpressionAssignmentStatement) {
            left = ((CExpressionAssignmentStatement)pStatement).getLeftHandSide();
        } else if (pStatement instanceof CFunctionCallAssignmentStatement) {
            left = ((CFunctionCallAssignmentStatement)pStatement).getLeftHandSide();
            this.logger.logOnce(Level.WARNING, new Object[]{"Analysis may be unsound if external method redefines global variables", "or considers extra global variables."});
        } else {
            return pState;
        }
        return this.handleOperation(pEdge, left, pState);
    }

    private ReachingDefState handleOperation(CFAEdge pEdge, CLeftHandSide pLeft, ReachingDefState pState) {
        MemoryLocation var = this.getVarName(pEdge, pLeft);
        if (var == null) {
            pState.addUnhandled(pLeft, pEdge.getPredecessor(), pEdge.getSuccessor());
            return pState;
        }
        if (pLeft instanceof CArraySubscriptExpression) {
            ReachingDefState newState = this.addReachDef(pState, var, pEdge.getPredecessor(), pEdge.getSuccessor());
            return pState.join(newState);
        }
        this.logger.log(Level.FINE, new Object[]{"Edge provided a new definition of variable ", var, ". Update reaching definition."});
        return this.addReachDef(pState, var, pEdge.getPredecessor(), pEdge.getSuccessor());
    }

    private ReachingDefState handleStatementEdge(ReachingDefState pState, CStatementEdge edge) {
        CStatement statement = edge.getStatement();
        return this.handleStatement(pState, edge, statement);
    }

    private ReachingDefState addReachDef(ReachingDefState pOld, MemoryLocation pVarName, CFANode pDefStart, CFANode pDefEnd) {
        if (pOld.getGlobalReachingDefinitions().containsKey(pVarName)) {
            return pOld.addGlobalReachDef(pVarName, pDefStart, pDefEnd);
        }
        assert (pOld.getLocalReachingDefinitions().containsKey(pVarName));
        return pOld.addLocalReachDef(pVarName, pDefStart, pDefEnd);
    }

    private MemoryLocation getVarName(CFAEdge pEdge, CExpression pLhs) {
        ReachingDefUtils.VariableExtractor varExtractor = new ReachingDefUtils.VariableExtractor(pEdge);
        varExtractor.resetWarning();
        try {
            MemoryLocation var = pLhs.accept(varExtractor);
            if (varExtractor.getWarning() != null) {
                this.logger.logOnce(Level.WARNING, new Object[]{varExtractor.getWarning()});
            }
            return var;
        }
        catch (UnsupportedCodeException e) {
            return null;
        }
    }

    private ReachingDefState handleDeclarationEdge(ReachingDefState pState, CDeclarationEdge edge) {
        if (edge.getDeclaration() instanceof CVariableDeclaration) {
            CVariableDeclaration dec = (CVariableDeclaration)edge.getDeclaration();
            MemoryLocation var = MemoryLocation.forDeclaration(dec);
            if (dec.isGlobal()) {
                return pState.addGlobalReachDef(var, edge.getPredecessor(), edge.getSuccessor());
            }
            return pState.addLocalReachDef(var, edge.getPredecessor(), edge.getSuccessor());
        }
        return pState;
    }

    private ReachingDefState handleCallEdge(ReachingDefState pState, CFunctionCallEdge pCfaEdge) {
        this.logger.log(Level.FINE, new Object[]{"New internal function called. ", "Add undefined position for local variables and return variable, if it exists. ", "Add definition of parameters."});
        return pState.initVariables(this.localVariablesPerFunction.get(pCfaEdge.getSuccessor()), (Set<MemoryLocation>)this.getParameters(pCfaEdge.getSuccessor()), pCfaEdge.getPredecessor(), pCfaEdge.getSuccessor());
    }

    private ReachingDefState handleReturnEdge(ReachingDefState pState, CFunctionReturnEdge pReturnEdge) {
        this.logger.log(Level.FINE, new Object[]{"Return from internal function call. ", "Remove local variables and parameters of function from reaching definition."});
        ReachingDefState newState = pState.pop(pReturnEdge.getPredecessor().getFunctionName());
        CFunctionCall callExpression = pReturnEdge.getSummaryEdge().getExpression();
        CFunctionCallExpression functionCall = callExpression.getFunctionCallExpression();
        List<CExpression> outFunctionParams = functionCall.getParameterExpressions();
        List<CParameterDeclaration> inFunctionParams = functionCall.getDeclaration().getParameters();
        FunctionExitNode defStart = pReturnEdge.getPredecessor();
        CFANode defEnd = pReturnEdge.getSuccessor();
        for (int i = 0; i < inFunctionParams.size(); ++i) {
            CParameterDeclaration inParam = inFunctionParams.get(i);
            CExpression outParam = outFunctionParams.get(i);
            CType parameterType = inParam.getType();
            if (parameterType instanceof CArrayType) {
                MemoryLocation var = this.getVarName(pReturnEdge, outParam);
                assert (var != null);
                newState = this.addReachDef(newState, var, defStart, defEnd);
                continue;
            }
            if (!(parameterType instanceof CPointerType)) continue;
            pState.addUnhandled(outParam, defStart, defEnd);
        }
        newState = this.handleStatement(newState, pReturnEdge, callExpression);
        return newState;
    }

    @Override
    public @Nullable Collection<? extends AbstractState> strengthen(AbstractState state, Iterable<AbstractState> otherStates, CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        for (AbstractState o : otherStates) {
            if (!(o instanceof PointerState)) continue;
            return this.strengthen((ReachingDefState)state, (PointerState)o);
        }
        return Collections.singleton(state);
    }

    private Collection<? extends AbstractState> strengthen(ReachingDefState pState, PointerState pO) {
        Map<CExpression, ReachingDefState.ProgramDefinitionPoint> unhandledExps = pState.getAndResetUnhandled();
        ReachingDefState nextState = pState;
        for (Map.Entry<CExpression, ReachingDefState.ProgramDefinitionPoint> e : unhandledExps.entrySet()) {
            CExpression exp = e.getKey();
            CFANode entry = e.getValue().getDefinitionEntryLocation();
            CFANode exit = e.getValue().getDefinitionExitLocation();
            Set<MemoryLocation> pointees = ReachingDefUtils.possiblePointees(exp, pO);
            if (pointees == null) {
                for (MemoryLocation localVar : pState.getLocalReachingDefinitions().keySet()) {
                    nextState = pState.addLocalReachDef(localVar, entry, exit).join(nextState);
                }
                for (MemoryLocation globalVar : pState.getGlobalReachingDefinitions().keySet()) {
                    nextState = pState.addGlobalReachDef(globalVar, entry, exit).join(nextState);
                }
                continue;
            }
            boolean ambiguous = pointees.size() != 1;
            for (MemoryLocation p : pointees) {
                ReachingDefState intermediateState = p.isOnFunctionStack() ? nextState.addLocalReachDef(p, entry, exit) : nextState.addGlobalReachDef(p, entry, exit);
                if (ambiguous) {
                    nextState = nextState.join(intermediateState);
                    continue;
                }
                nextState = intermediateState;
            }
        }
        return ImmutableSet.of((Object)nextState);
    }
}

