/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.rtt;

import org.sosy_lab.cpachecker.cfa.ast.java.JFieldAccess;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cpa.rtt.RTTState;

public class NameProvider {
    private static final NameProvider SINGLETON = new NameProvider();
    private static final String VARIABLE_DELIMITER = "::";
    private static final String INSTANCE_DELIMITER = "_";

    private NameProvider() {
    }

    public static NameProvider getInstance() {
        return SINGLETON;
    }

    public String getObjectScope(RTTState rttState, String methodName, JIdExpression notScopedField) {
        if (notScopedField.getDeclaration() == null) {
            return null;
        }
        if (notScopedField instanceof JFieldAccess) {
            if (((JFieldAccess)notScopedField).getDeclaration().isStatic() && ((JFieldAccess)notScopedField).getDeclaration().getVisibility().equals((Object)VisibilityModifier.PUBLIC) && ((JFieldAccess)notScopedField).getReferencedVariable().getDeclaration() == null) {
                return null;
            }
            String scopedFieldName = this.getScopedFieldName((JFieldAccess)notScopedField, methodName, rttState);
            if (rttState.contains(scopedFieldName)) {
                return rttState.getUniqueObjectFor(scopedFieldName);
            }
            return null;
        }
        if (rttState.contains("this")) {
            return rttState.getUniqueObjectFor("this");
        }
        return null;
    }

    private String getScopedFieldName(JFieldAccess pFieldAccess, String pMethodName, RTTState pRttState) {
        JIdExpression qualifier = pFieldAccess.getReferencedVariable();
        JSimpleDeclaration declaration = qualifier.getDeclaration();
        String qualifierScope = this.getObjectScope(pRttState, pMethodName, qualifier);
        return this.getScopedVariableName(declaration, pMethodName, qualifierScope);
    }

    public String getScopedVariableName(String pVariableName, String pFunctionName, String pUniqueObject, RTTState pState) {
        if (pVariableName.equals("this")) {
            return pVariableName;
        }
        if (pState.isKnownAsStatic(pVariableName)) {
            return pVariableName;
        }
        if (pState.isKnownAsDynamic(pVariableName)) {
            return pUniqueObject + VARIABLE_DELIMITER + pVariableName;
        }
        return pFunctionName + VARIABLE_DELIMITER + pVariableName;
    }

    public String getScopedVariableName(JSimpleDeclaration pDeclaration, String functionName, String uniqueObject) {
        String variableName = pDeclaration.getName();
        if (pDeclaration instanceof JFieldDeclaration && ((JFieldDeclaration)pDeclaration).isStatic()) {
            return variableName;
        }
        if (pDeclaration instanceof JFieldDeclaration) {
            return uniqueObject + VARIABLE_DELIMITER + variableName;
        }
        return functionName + VARIABLE_DELIMITER + variableName;
    }

    public String getUniqueObjectName(String pJavaRunTimeClassName, String pId) {
        return pJavaRunTimeClassName + INSTANCE_DELIMITER + pId;
    }
}

