/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.rtt;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.cpa.rtt.NameProvider;
import org.sosy_lab.cpachecker.cpa.rtt.RTTTransferRelation;

public class RTTState
extends Appenders.AbstractAppender
implements LatticeAbstractState<RTTState> {
    public static final String KEYWORD_THIS = "this";
    public static final String NULL_REFERENCE = "null";
    private final Map<String, String> constantsMap;
    private final Map<String, String> identificationMap;
    private final Map<String, String> classTypeMap;
    private final Set<String> staticFieldVariables = new HashSet<String>();
    private final Set<String> nonStaticFieldVariables = new HashSet<String>();
    private String classObjectScope;
    private final Deque<String> classObjectStack;

    public RTTState() {
        this.constantsMap = new HashMap<String, String>();
        this.identificationMap = new HashMap<String, String>();
        this.classTypeMap = new HashMap<String, String>();
        this.classObjectStack = new ArrayDeque<String>();
        this.classObjectScope = NULL_REFERENCE;
        this.constantsMap.put(KEYWORD_THIS, NULL_REFERENCE);
    }

    private RTTState(Map<String, String> pConstantsMap, Map<String, String> pIdentificationMap, Map<String, String> pClassTypeMap, String pClassObjectScope, Deque<String> pClassObjectStack) {
        this.constantsMap = pConstantsMap;
        this.identificationMap = pIdentificationMap;
        this.classTypeMap = pClassTypeMap;
        this.classObjectStack = pClassObjectStack;
        this.classObjectScope = pClassObjectScope;
    }

    void assignObject(String variableName, String object) {
        Preconditions.checkNotNull((Object)variableName);
        Preconditions.checkNotNull((Object)object);
        if (this.constantsMap.containsValue(object)) {
            this.constantsMap.put(variableName, object);
        } else {
            this.assignNewUniqueObject(variableName, object);
        }
    }

    private void forgetObject(String value) {
        this.identificationMap.remove(value);
        this.classTypeMap.remove(value);
    }

    void addFieldVariable(JFieldDeclaration pFieldDeclaration) {
        String name = pFieldDeclaration.getName();
        if (pFieldDeclaration.isStatic()) {
            this.staticFieldVariables.add(name);
        } else {
            this.nonStaticFieldVariables.add(name);
        }
    }

    public boolean isKnown(String pFieldName) {
        return this.staticFieldVariables.contains(pFieldName) || this.nonStaticFieldVariables.contains(pFieldName);
    }

    public boolean isKnownAsStatic(String pFieldName) {
        return this.staticFieldVariables.contains(pFieldName);
    }

    public boolean isKnownAsDynamic(String pFieldName) {
        return this.nonStaticFieldVariables.contains(pFieldName);
    }

    private void assignNewUniqueObject(String variableName, String javaRunTimeClassName) {
        String uniqueObject;
        String iD;
        Preconditions.checkNotNull((Object)variableName);
        Preconditions.checkNotNull((Object)javaRunTimeClassName);
        if (javaRunTimeClassName.equals(NULL_REFERENCE)) {
            iD = "";
            uniqueObject = javaRunTimeClassName;
        } else {
            iD = Integer.toString(RTTTransferRelation.nextId());
            uniqueObject = NameProvider.getInstance().getUniqueObjectName(javaRunTimeClassName, iD);
        }
        this.identificationMap.put(uniqueObject, iD);
        this.classTypeMap.put(uniqueObject, javaRunTimeClassName);
        this.constantsMap.put(variableName, uniqueObject);
    }

    void forget(String variableName) {
        String oldValue = this.constantsMap.get(variableName);
        if (oldValue != null && !oldValue.equals(NULL_REFERENCE) && !this.constantsMap.containsValue(oldValue)) {
            this.forgetObject(oldValue);
        }
        this.constantsMap.remove(variableName);
    }

    void dropFrame(String functionName) {
        ArrayList<String> toDropAll = new ArrayList<String>();
        for (String variableName : this.constantsMap.keySet()) {
            if (!variableName.startsWith(functionName + "::")) continue;
            toDropAll.add(variableName);
        }
        for (String variableNameToDrop : toDropAll) {
            this.constantsMap.remove(variableNameToDrop);
        }
        this.retrieveObjectScope();
    }

    private void retrieveObjectScope() {
        this.classObjectScope = this.classObjectStack.pop();
        this.constantsMap.put(KEYWORD_THIS, this.classObjectScope);
    }

    public String getUniqueObjectFor(String variableName) {
        return (String)Preconditions.checkNotNull((Object)this.constantsMap.get(variableName));
    }

    String getRunTimeClassFor(String variableName) {
        Preconditions.checkNotNull((Object)variableName);
        String uniqueObject = this.getUniqueObjectFor(variableName);
        return this.classTypeMap.get(uniqueObject);
    }

    String getObjectIDFor(String uniqueObject) {
        Preconditions.checkNotNull((Object)uniqueObject);
        String iD = this.classTypeMap.get(uniqueObject);
        Preconditions.checkNotNull((Object)iD);
        return iD;
    }

    public boolean contains(String variableName) {
        return this.constantsMap.containsKey(variableName);
    }

    int getSize() {
        return this.constantsMap.size();
    }

    @Override
    public RTTState join(RTTState other) {
        String key;
        int size = Math.min(this.constantsMap.size(), other.constantsMap.size());
        HashMap newConstantsMap = Maps.newHashMapWithExpectedSize((int)size);
        HashMap<String, String> newIdentificationMap = new HashMap<String, String>(0);
        HashMap<String, String> newClassTypeMap = new HashMap<String, String>(0);
        for (Map.Entry<String, String> otherEntry : other.constantsMap.entrySet()) {
            key = otherEntry.getKey();
            if (!Objects.equals(otherEntry.getValue(), this.constantsMap.get(key))) continue;
            newConstantsMap.put(key, otherEntry.getValue());
        }
        for (Map.Entry<String, String> otherEntry : other.identificationMap.entrySet()) {
            key = otherEntry.getKey();
            if (!Objects.equals(otherEntry.getValue(), this.identificationMap.get(key))) continue;
            newConstantsMap.put(key, otherEntry.getValue());
        }
        for (Map.Entry<String, String> otherEntry : other.classTypeMap.entrySet()) {
            key = otherEntry.getKey();
            if (!Objects.equals(otherEntry.getValue(), this.classTypeMap.get(key))) continue;
            newConstantsMap.put(key, otherEntry.getValue());
        }
        return new RTTState(newConstantsMap, newIdentificationMap, newClassTypeMap, this.classObjectScope, this.classObjectStack);
    }

    @Override
    public boolean isLessOrEqual(RTTState other) {
        if (this.constantsMap.size() < other.constantsMap.size()) {
            return false;
        }
        for (Map.Entry<String, String> otherEntry : other.constantsMap.entrySet()) {
            String key = otherEntry.getKey();
            if (otherEntry.getValue().equals(this.constantsMap.get(key))) continue;
            return false;
        }
        if (!this.classObjectScope.equals(other.getClassObjectScope())) {
            return false;
        }
        return this.getClassObjectStack().equals(other.getClassObjectStack());
    }

    public static RTTState copyOf(RTTState old) {
        ArrayDeque<String> newClassObjectStack = new ArrayDeque<String>(old.classObjectStack);
        return new RTTState(new HashMap<String, String>(old.constantsMap), new HashMap<String, String>(old.identificationMap), new HashMap<String, String>(old.classTypeMap), old.classObjectScope, newClassObjectStack);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RTTState)) {
            return false;
        }
        RTTState otherElement = (RTTState)other;
        return otherElement.constantsMap.equals(this.constantsMap);
    }

    @Override
    public int hashCode() {
        return this.constantsMap.hashCode();
    }

    public String getCPAName() {
        return "JavaObjectRuntimeTracker";
    }

    void deleteValue(String varName) {
        this.constantsMap.remove(varName);
    }

    Set<String> getTrackedVariableNames() {
        return this.constantsMap.keySet();
    }

    public Map<String, String> getConstantsMap() {
        return this.constantsMap;
    }

    String getClassObjectScope() {
        return this.classObjectScope;
    }

    void setClassObjectScope(String classObjectScope) {
        this.classObjectScope = classObjectScope;
    }

    Deque<String> getClassObjectStack() {
        return this.classObjectStack;
    }

    void assignThisAndNewObjectScope(String scope) {
        this.classObjectStack.push(this.classObjectScope);
        this.assignObject(KEYWORD_THIS, scope);
        this.classObjectScope = this.getKeywordThisUniqueObject();
    }

    public String getKeywordThisUniqueObject() {
        return this.getUniqueObjectFor(KEYWORD_THIS);
    }

    public String getRunTimeClassOfUniqueObject(String uniqueObject) {
        return this.classTypeMap.get(uniqueObject);
    }

    public void appendTo(Appendable a) throws IOException {
        a.append("[");
        Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(a, this.constantsMap);
        a.append("]");
    }

    void assignAssumptionType(String pReferenz, JClassOrInterfaceType pAssignableType) {
        this.assignNewUniqueObject(pReferenz, pAssignableType.getName());
    }
}

