/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.rtt;

import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.DefaultJExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayCreationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JAssignment;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JEnumConstantExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldAccess;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodOrConstructorInvocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JNullLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JObjectReferenceReturn;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JReferencedMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JSuperConstructorInvocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JThisExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableRunTimeType;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodCallEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JReferenceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.rtt.NameProvider;
import org.sosy_lab.cpachecker.cpa.rtt.RTTState;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class RTTTransferRelation
extends ForwardingTransferRelation<RTTState, RTTState, Precision> {
    private static final String NOT_IN_OBJECT_SCOPE = "null";
    private static final int RETURN_EDGE = 0;
    private static final String TEMP_VAR_NAME = "___cpa_temp_result_var_";
    private static final String JAVA_ENUM_OBJECT_NAME = "java.lang.Enum";
    private static int nextFreeId = 0;
    private static final NameProvider nameProvider = NameProvider.getInstance();

    @Override
    protected RTTState handleDeclarationEdge(JDeclarationEdge cfaEdge, JDeclaration declaration) throws UnrecognizedCodeException {
        AInitializer init;
        if (!(declaration instanceof JVariableDeclaration)) {
            return (RTTState)this.state;
        }
        JVariableDeclaration decl = (JVariableDeclaration)declaration;
        if (decl.getType() instanceof JSimpleType) {
            JBasicType simpleType = ((JSimpleType)decl.getType()).getType();
            switch (simpleType) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case FLOAT: 
                case DOUBLE: 
                case INT: 
                case LONG: 
                case SHORT: 
                case UNSPECIFIED: {
                    return (RTTState)this.state;
                }
            }
        }
        RTTState newState = RTTState.copyOf((RTTState)this.state);
        String initialValue = NOT_IN_OBJECT_SCOPE;
        if (decl instanceof JFieldDeclaration) {
            JFieldDeclaration fieldVariable = (JFieldDeclaration)decl;
            newState.addFieldVariable(fieldVariable);
        }
        if ((init = decl.getInitializer()) instanceof JInitializerExpression) {
            JExpression exp = ((JInitializerExpression)init).getExpression();
            initialValue = this.getExpressionValue(newState, exp, this.functionName, cfaEdge);
        }
        String scopedVarName = nameProvider.getScopedVariableName(decl, this.functionName, newState.getClassObjectScope());
        if (initialValue == null) {
            newState.forget(scopedVarName);
        } else {
            newState.assignObject(scopedVarName, initialValue);
        }
        return newState;
    }

    private String getExpressionValue(RTTState pState, JExpression expression, String methodName, CFAEdge edge) throws UnrecognizedCodeException {
        return expression.accept(new ExpressionValueVisitor(edge, pState, methodName));
    }

    @Override
    protected RTTState handleReturnStatementEdge(JReturnStatementEdge cfaEdge) throws UnrecognizedCodeException {
        if (cfaEdge.getExpression().isPresent()) {
            JExpression expression = cfaEdge.getExpression().orElseThrow();
            RTTState newState = RTTState.copyOf((RTTState)this.state);
            String value = cfaEdge.getReturnStatement() instanceof JObjectReferenceReturn ? ((RTTState)this.state).getClassObjectScope() : this.getExpressionValue((RTTState)this.state, expression, this.functionName, cfaEdge);
            String assignedVar = nameProvider.getScopedVariableName(TEMP_VAR_NAME, this.functionName, ((RTTState)this.state).getClassObjectScope(), (RTTState)this.state);
            if (value == null) {
                newState.forget(assignedVar);
            } else {
                newState.assignObject(assignedVar, value);
            }
            return newState;
        }
        return (RTTState)this.state;
    }

    @Override
    protected RTTState handleStatementEdge(JStatementEdge cfaEdge, JStatement statement) throws UnrecognizedCodeException {
        if (statement instanceof JAssignment) {
            return this.handleAssignment((JAssignment)statement, cfaEdge);
        }
        if (!(statement instanceof JMethodOrConstructorInvocation) && !(statement instanceof JExpressionStatement)) {
            throw new UnrecognizedCodeException("unknown statement", cfaEdge, statement);
        }
        return (RTTState)this.state;
    }

    private RTTState handleAssignment(JAssignment assignExpression, CFAEdge edge) throws UnrecognizedCodeException {
        JLeftHandSide op1 = assignExpression.getLeftHandSide();
        JRightHandSide op2 = assignExpression.getRightHandSide();
        if (op1 instanceof JIdExpression) {
            JSimpleDeclaration declaration = ((JIdExpression)op1).getDeclaration();
            if (declaration == null) {
                String scopedName = nameProvider.getScopedVariableName(((JIdExpression)op1).getName(), this.functionName, ((RTTState)this.state).getClassObjectScope(), (RTTState)this.state);
                RTTState newState = RTTState.copyOf((RTTState)this.state);
                newState.forget(scopedName);
                return newState;
            }
            return this.handleAssignmentToVariable((JIdExpression)op1, op2, edge);
        }
        return (RTTState)this.state;
    }

    private RTTState handleAssignmentToVariable(JIdExpression lParam, JRightHandSide exp, CFAEdge edge) throws UnrecognizedCodeException {
        String lParamObjectScope = nameProvider.getObjectScope((RTTState)this.state, this.functionName, lParam);
        String value = exp.accept(new ExpressionValueVisitor(edge, (RTTState)this.state, this.functionName));
        RTTState newState = RTTState.copyOf((RTTState)this.state);
        if (!newState.isKnownAsStatic(lParam.getName()) && lParamObjectScope == null) {
            return (RTTState)this.state;
        }
        String assignedVar = nameProvider.getScopedVariableName(lParam.getDeclaration(), this.functionName, lParamObjectScope);
        if (value != null && lParam.getExpressionType() instanceof JReferenceType) {
            newState.assignObject(assignedVar, value);
        } else {
            newState.forget(assignedVar);
        }
        return newState;
    }

    @Override
    protected RTTState handleFunctionReturnEdge(JMethodReturnEdge cfaEdge, JMethodSummaryEdge fnkCall, JMethodOrConstructorInvocation summaryExpr, String callerFunctionName) throws UnrecognizedCodeException {
        RTTState newState = RTTState.copyOf((RTTState)this.state);
        if (summaryExpr instanceof JMethodInvocationAssignmentStatement) {
            JMethodInvocationAssignmentStatement assignExp = (JMethodInvocationAssignmentStatement)summaryExpr;
            JLeftHandSide op1 = assignExp.getLeftHandSide();
            if (op1 instanceof JIdExpression) {
                String returnVarName = nameProvider.getScopedVariableName(TEMP_VAR_NAME, this.functionName, newState.getClassObjectScope(), newState);
                String assignedVarName = nameProvider.getScopedVariableName(((JIdExpression)op1).getDeclaration(), callerFunctionName, newState.getClassObjectStack().peek());
                JSimpleDeclaration decl = ((JIdExpression)op1).getDeclaration();
                if (((RTTState)this.state).contains(returnVarName) && decl.getType() instanceof JReferenceType) {
                    newState.assignObject(assignedVarName, ((RTTState)this.state).getUniqueObjectFor(returnVarName));
                } else {
                    newState.forget(assignedVarName);
                }
            } else if (!(op1 instanceof JArraySubscriptExpression)) {
                throw new UnrecognizedCodeException("on function return", fnkCall, op1);
            }
        }
        newState.dropFrame(this.functionName);
        return newState;
    }

    @Override
    protected RTTState handleFunctionCallEdge(JMethodCallEdge cfaEdge, List<JExpression> arguments, List<JParameterDeclaration> parameters, String calledFunctionName) throws UnrecognizedCodeException {
        RTTState newState = RTTState.copyOf((RTTState)this.state);
        JMethodEntryNode functionEntryNode = cfaEdge.getSuccessor();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        if (!cfaEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs()) assert (paramNames.size() == arguments.size());
        for (int i = 0; i < paramNames.size(); ++i) {
            JExpression exp = arguments.get(i);
            String value = this.getExpressionValue((RTTState)this.state, exp, this.functionName, cfaEdge);
            String formalParamName = nameProvider.getScopedVariableName(paramNames.get(i), calledFunctionName, newState.getClassObjectScope(), newState);
            if (value == null || !(exp.getExpressionType() instanceof JReferenceType)) {
                newState.forget(formalParamName);
                continue;
            }
            newState.assignObject(formalParamName, value);
        }
        JMethodInvocationExpression functionCall = cfaEdge.getSummaryEdge().getExpression().getFunctionCallExpression();
        if (functionCall instanceof JSuperConstructorInvocation) {
            newState.assignThisAndNewObjectScope(((RTTState)this.state).getUniqueObjectFor("this"));
        } else if (functionCall instanceof JClassInstanceCreation) {
            JReturnStatementEdge returnEdge = (JReturnStatementEdge)functionEntryNode.getExitNode().getEnteringEdge(0);
            String uniqueObject = returnEdge.getExpression().orElseThrow().accept(new FunctionExitValueVisitor(returnEdge, newState, calledFunctionName));
            newState.assignThisAndNewObjectScope(uniqueObject);
        } else if (functionCall instanceof JReferencedMethodInvocationExpression) {
            JReferencedMethodInvocationExpression objectMethodInvocation = (JReferencedMethodInvocationExpression)functionCall;
            JSimpleDeclaration variableReference = objectMethodInvocation.getReferencedVariable().getDeclaration();
            String variableName = nameProvider.getScopedVariableName(variableReference, this.functionName, newState.getClassObjectScope());
            if (newState.contains(variableName)) {
                newState.assignThisAndNewObjectScope(newState.getUniqueObjectFor(variableName));
            } else {
                newState.assignThisAndNewObjectScope(NOT_IN_OBJECT_SCOPE);
            }
        } else {
            JMethodDeclaration decl = functionCall.getDeclaration();
            if (decl.isStatic()) {
                newState.assignThisAndNewObjectScope(NOT_IN_OBJECT_SCOPE);
            } else {
                newState.assignThisAndNewObjectScope(newState.getUniqueObjectFor("this"));
            }
        }
        return newState;
    }

    @Override
    protected RTTState handleAssumption(JAssumeEdge cfaEdge, JExpression expression, boolean truthAssumption) throws UnrecognizedCodeException {
        String valueString = this.getExpressionValue((RTTState)this.state, expression, this.functionName, cfaEdge);
        boolean value = Boolean.parseBoolean(valueString);
        RTTState newState = RTTState.copyOf((RTTState)this.state);
        if (valueString == null) {
            AssigningValueVisitor visitor = new AssigningValueVisitor(newState, truthAssumption, this.functionName);
            expression.accept(visitor);
            return newState;
        }
        if (truthAssumption == value) {
            return (RTTState)this.state;
        }
        return null;
    }

    public static int nextId() {
        return ++nextFreeId;
    }

    private static class ExpressionValueVisitor
    extends DefaultJExpressionVisitor<String, UnrecognizedCodeException>
    implements JRightHandSideVisitor<String, UnrecognizedCodeException> {
        protected final CFAEdge edge;
        protected final RTTState state;
        protected final String functionName;

        public ExpressionValueVisitor(CFAEdge pEdge, RTTState pState, String pFunctionName) {
            this.edge = pEdge;
            this.state = pState;
            this.functionName = pFunctionName;
        }

        @Override
        protected String visitDefault(JExpression pE) {
            return null;
        }

        @Override
        public String visit(JCastExpression pE) throws UnrecognizedCodeException {
            return pE.getOperand().accept(this);
        }

        @Override
        public String visit(JCharLiteralExpression pPaCharLiteralExpression) throws UnrecognizedCodeException {
            return "Character";
        }

        @Override
        public String visit(JStringLiteralExpression pPaStringLiteralExpression) throws UnrecognizedCodeException {
            return "String";
        }

        @Override
        public String visit(JBinaryExpression binaryExpression) throws UnrecognizedCodeException {
            JExpression leftOperand = binaryExpression.getOperand1();
            JExpression rightOperand = binaryExpression.getOperand2();
            if (this.isObjectComparison(binaryExpression)) {
                if (this.isEnum((JClassType)leftOperand.getExpressionType()) || this.isEnum((JClassType)rightOperand.getExpressionType())) {
                    return this.handleEnumComparison(leftOperand, rightOperand, binaryExpression.getOperator());
                }
                return this.handleObjectComparison(leftOperand, rightOperand, binaryExpression.getOperator());
            }
            return null;
        }

        private boolean isObjectComparison(JBinaryExpression pExpression) {
            JBinaryExpression.BinaryOperator operator = pExpression.getOperator();
            boolean isComparison = operator == JBinaryExpression.BinaryOperator.EQUALS || operator == JBinaryExpression.BinaryOperator.NOT_EQUALS;
            JExpression leftOperand = pExpression.getOperand1();
            JExpression rightOperand = pExpression.getOperand2();
            boolean isObject = leftOperand.getExpressionType() instanceof JClassType && rightOperand.getExpressionType() instanceof JClassType;
            return isComparison && isObject;
        }

        private boolean isEnum(JClassType pClassType) {
            for (JClassOrInterfaceType jClassOrInterfaceType : pClassType.getAllSuperTypesOfType()) {
                if (!jClassOrInterfaceType.getName().equals(RTTTransferRelation.JAVA_ENUM_OBJECT_NAME)) continue;
                return false;
            }
            return true;
        }

        private String handleEnumComparison(JExpression operand1, JExpression operand2, JBinaryExpression.BinaryOperator operator) throws UnrecognizedCodeException {
            String value1 = operand1.accept(this);
            String value2 = operand2.accept(this);
            if (this.state.getConstantsMap().containsValue(value1)) {
                value1 = this.state.getRunTimeClassOfUniqueObject(value1);
            }
            if (this.state.getConstantsMap().containsValue(value2)) {
                value2 = this.state.getRunTimeClassOfUniqueObject(value2);
            }
            if (value1 == null || value2 == null) {
                return null;
            }
            boolean result = value1.equals(value2);
            switch (operator) {
                case EQUALS: {
                    break;
                }
                case NOT_EQUALS: {
                    result = !result;
                    break;
                }
                default: {
                    throw new UnrecognizedCodeException("unexpected enum comparison", this.edge);
                }
            }
            return Boolean.toString(result);
        }

        private String handleObjectComparison(JExpression pLeftOperand, JExpression pRightOperand, JBinaryExpression.BinaryOperator pOperator) throws UnrecognizedCodeException {
            String value1 = pLeftOperand.accept(this);
            String value2 = pRightOperand.accept(this);
            boolean result = pOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS ^ value1.equals(value2);
            return Boolean.toString(result);
        }

        @Override
        public String visit(JArrayCreationExpression pJArrayCreationExpression) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public String visit(JArraySubscriptExpression pAArraySubscriptExpression) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public String visit(JVariableRunTimeType vrtT) throws UnrecognizedCodeException {
            JIdExpression expr = vrtT.getReferencedVariable();
            String uniqueObject = expr.accept(this);
            String runTimeClass = this.state.getRunTimeClassOfUniqueObject(uniqueObject);
            return runTimeClass;
        }

        @Override
        public String visit(JIdExpression idExpression) throws UnrecognizedCodeException {
            if (idExpression.getDeclaration() == null) {
                return null;
            }
            JSimpleDeclaration declaration = idExpression.getDeclaration();
            if (idExpression instanceof JFieldAccess) {
                JFieldAccess fiExpr = (JFieldAccess)idExpression;
                JType type = fiExpr.getExpressionType();
                JIdExpression qualifier = fiExpr.getReferencedVariable();
                String uniqueQualifierObject = qualifier.accept(this);
                String variableName = nameProvider.getScopedVariableName(declaration, this.functionName, uniqueQualifierObject);
                if (type instanceof JClassOrInterfaceType && this.state.contains(variableName)) {
                    return this.state.getUniqueObjectFor(variableName);
                }
                return null;
            }
            JType type = idExpression.getExpressionType();
            String variableName = nameProvider.getScopedVariableName(declaration, this.functionName, this.state.getClassObjectScope());
            if (type instanceof JClassOrInterfaceType && this.state.contains(variableName)) {
                return this.state.getUniqueObjectFor(variableName);
            }
            return null;
        }

        @Override
        public String visit(JRunTimeTypeEqualsType jRunTimeTypeEqualsType) throws UnrecognizedCodeException {
            String jrunTimeType = jRunTimeTypeEqualsType.getRunTimeTypeExpression().accept(this);
            if (jrunTimeType == null) {
                return null;
            }
            JReferenceType typeDef = jRunTimeTypeEqualsType.getTypeDef();
            String name = typeDef instanceof JClassOrInterfaceType ? ((JClassOrInterfaceType)typeDef).getName() : ((JArrayType)typeDef).toString();
            return Boolean.toString(name.equals(jrunTimeType));
        }

        @Override
        public String visit(JClassInstanceCreation jClassInstanzeCreation) throws UnrecognizedCodeException {
            return jClassInstanzeCreation.getExpressionType().getName();
        }

        @Override
        public String visit(JMethodInvocationExpression pAFunctionCallExpression) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public String visit(JThisExpression thisExpression) throws UnrecognizedCodeException {
            if (this.state.contains("this")) {
                return this.state.getUniqueObjectFor("this");
            }
            return null;
        }

        @Override
        public String visit(JClassLiteralExpression pJClassLiteralExpression) throws UnrecognizedCodeException {
            JType jType = pJClassLiteralExpression.getExpressionType();
            return jType.toASTString("");
        }

        @Override
        public String visit(JNullLiteralExpression pJNullLiteralExpression) throws UnrecognizedCodeException {
            return RTTTransferRelation.NOT_IN_OBJECT_SCOPE;
        }

        @Override
        public String visit(JEnumConstantExpression e) throws UnrecognizedCodeException {
            return e.getConstantName();
        }
    }

    private static class AssigningValueVisitor
    extends DefaultJExpressionVisitor<String, UnrecognizedCodeException> {
        private final boolean truthAssumption;
        private final RTTState newState;
        private final String methodName;

        public AssigningValueVisitor(RTTState pNewState, boolean pTruthAssumption, String pMethodName) {
            this.truthAssumption = pTruthAssumption;
            this.newState = pNewState;
            this.methodName = pMethodName;
        }

        @Override
        public String visit(JVariableRunTimeType pE) throws UnrecognizedCodeException {
            return nameProvider.getScopedVariableName(pE.getReferencedVariable().getDeclaration(), this.methodName, this.newState.getKeywordThisUniqueObject());
        }

        @Override
        protected String visitDefault(JExpression pE) {
            return null;
        }

        @Override
        public String visit(JThisExpression thisExpression) throws UnrecognizedCodeException {
            return "this";
        }

        @Override
        public String visit(JRunTimeTypeEqualsType pE) throws UnrecognizedCodeException {
            JReferenceType assignableType = pE.getTypeDef();
            String reference = pE.getRunTimeTypeExpression().accept(this);
            if (reference == null) {
                return null;
            }
            if (this.truthAssumption && assignableType instanceof JClassOrInterfaceType) {
                this.newState.assignAssumptionType(reference, (JClassOrInterfaceType)assignableType);
            }
            return null;
        }
    }

    private static class FunctionExitValueVisitor
    extends ExpressionValueVisitor {
        public FunctionExitValueVisitor(CFAEdge pEdge, RTTState pState, String pFunctionName) {
            super(pEdge, pState, pFunctionName);
        }

        @Override
        public String visit(JThisExpression thisExp) throws UnrecognizedCodeException {
            return thisExp.getExpressionType().getName();
        }
    }
}

