/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.sign;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.cpa.sign.SignTransferRelation;

@Options(prefix="cpa.sign")
public class SignCPA
extends AbstractCPA
implements ProofChecker.ProofCheckerCPA {
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for SignCPA")
    private String mergeType = "JOIN";
    @Option(secure=true, name="stop", toUppercase=true, values={"SEP", "JOIN"}, description="which stop operator to use for SignCPA")
    private String stopType = "SEP";

    public SignCPA(LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        super(DelegateAbstractDomain.getInstance(), new SignTransferRelation(pLogger));
        config.inject((Object)this);
    }

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(SignCPA.class);
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.buildMergeOperator(this.mergeType);
    }

    @Override
    public StopOperator getStopOperator() {
        return this.buildStopOperator(this.stopType);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return SignState.TOP;
    }
}

