/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SSCPath;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SSCReachedSet;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SingleSuccessorCompactorCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CPAs;

public class SSCBasedRefiner
extends AbstractARGBasedRefiner {
    private final SingleSuccessorCompactorCPA sscCpa;

    private SSCBasedRefiner(ARGBasedRefiner pRefiner, ARGCPA pArgCpa, SingleSuccessorCompactorCPA pSscCpa, LogManager pLogger) {
        super(pRefiner, pArgCpa, pLogger);
        this.sscCpa = pSscCpa;
    }

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        return SSCBasedRefiner.forARGBasedRefiner((rs, path) -> CounterexampleInfo.feasibleImprecise(path), pCpa);
    }

    public static Refiner forARGBasedRefiner(ARGBasedRefiner pRefiner, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        Preconditions.checkArgument((!(pRefiner instanceof Refiner) ? 1 : 0) != 0, (Object)"ARGBasedRefiners may not implement Refiner, choose between these two!");
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, SSCBasedRefiner.class);
        SingleSuccessorCompactorCPA sscCpa = CPAs.retrieveCPAOrFail(pCpa, SingleSuccessorCompactorCPA.class, SSCBasedRefiner.class);
        return new SSCBasedRefiner(pRefiner, argCpa, sscCpa, argCpa.getLogger());
    }

    @Override
    protected final CounterexampleInfo performRefinementForPath(ARGReachedSet pReached, ARGPath pPath) throws CPAException, InterruptedException {
        Preconditions.checkArgument((!(pReached instanceof SSCReachedSet) ? 1 : 0) != 0, (Object)"Wrapping of SSC-based refiners inside SSC-based refiners is not allowed.");
        Preconditions.checkArgument((boolean)(pPath instanceof SSCPath), (Object)"SSCPath required for SSCReachedSet.");
        assert (pPath.size() > 0);
        return super.performRefinementForPath(new SSCReachedSet(pReached, (SSCPath)pPath), pPath);
    }

    @Override
    protected final ARGPath computePath(ARGState pLastElement, ARGReachedSet pMainReachedSet) throws InterruptedException, CPATransferException {
        assert (pMainReachedSet.asReachedSet().contains(pLastElement)) : "targetState must be in mainReachedSet.";
        ARGPath shortPath = ARGUtils.getOnePathTo(pLastElement);
        return new SSCPath(this.sscCpa, pMainReachedSet, shortPath.asStatesList());
    }
}

