/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SingleSuccessorCompactorCPA;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SingleSuccessorCompactorTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class SSCPath
extends ARGPath {
    private final ARGReachedSet reachedSet;
    private final SingleSuccessorCompactorTransferRelation transfer;

    public SSCPath(SingleSuccessorCompactorCPA pSscCpa, ARGReachedSet pMainReachedSet, ImmutableList<ARGState> pStates) {
        super((List<ARGState>)pStates);
        this.reachedSet = pMainReachedSet;
        this.transfer = pSscCpa.getTransferRelation();
    }

    @Override
    protected List<CFAEdge> buildFullPath() {
        ArrayList<CFAEdge> newFullPath = new ArrayList<CFAEdge>();
        PathIterator it = this.pathIterator();
        while (it.hasNext()) {
            this.getInnerEdgesFromTo(newFullPath, it.getAbstractState(), it.getNextAbstractState());
            it.advance();
        }
        assert (this.checkFullPath(newFullPath)) : Joiner.on((String)"\n").join(Iterables.skip(newFullPath, (int)0));
        return newFullPath;
    }

    private boolean checkFullPath(List<CFAEdge> pFullPath) {
        if (pFullPath.isEmpty()) {
            return true;
        }
        Iterator<CFAEdge> it = pFullPath.iterator();
        CFAEdge previous = it.next();
        while (it.hasNext()) {
            CFAEdge current = it.next();
            if (!Objects.equals(previous.getSuccessor(), current.getPredecessor())) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    private void getInnerEdgesFromTo(List<CFAEdge> newFullPath, ARGState prev, ARGState succ) {
        ArrayList<AbstractState> innerStates = new ArrayList<AbstractState>();
        try {
            Collection<? extends AbstractState> collection = this.transfer.getAbstractSuccessorsWithList(prev.getWrappedState(), this.reachedSet.asReachedSet().getPrecision(prev), innerStates);
        }
        catch (InterruptedException | CPATransferException e) {
            throw new AssertionError((Object)"should not happen");
        }
        assert (!innerStates.isEmpty());
        Iterator innerIt = innerStates.iterator();
        AbstractState parent = (AbstractState)innerIt.next();
        while (innerIt.hasNext()) {
            AbstractState child = (AbstractState)innerIt.next();
            this.getEdgesFromTo(newFullPath, parent, child);
            parent = child;
        }
        this.getEdgesFromTo(newFullPath, parent, succ);
    }

    private void getEdgesFromTo(List<CFAEdge> newFullPath, AbstractState parent, AbstractState child) {
        CFANode parentLoc = AbstractStates.extractLocation(parent);
        CFANode childLoc = AbstractStates.extractLocation(child);
        while (parentLoc.getNumLeavingEdges() == 1) {
            CFAEdge nextEdge = parentLoc.getLeavingEdge(0);
            CFANode nextLoc = nextEdge.getSuccessor();
            newFullPath.add(nextEdge);
            if (Objects.equals(nextLoc, childLoc)) {
                return;
            }
            parentLoc = nextLoc;
        }
        for (CFAEdge leavingEdge : CFAUtils.leavingEdges(parentLoc)) {
            if (!Objects.equals(leavingEdge.getSuccessor(), childLoc)) continue;
            newFullPath.add(leavingEdge);
            return;
        }
        throw new AssertionError((Object)"unexpected CFA locations");
    }

    private List<CFANode> getLocations() {
        return Lists.transform(this.asStatesList(), AbstractStates::extractLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.reachedSet, this.getLocations());
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof SSCPath)) {
            return false;
        }
        return super.equals(pOther) && Objects.equals(this.getLocations(), ((SSCPath)((Object)pOther)).getLocations());
    }

    public String toString() {
        return "SCCPath {" + Joiner.on((String)"\n").join(this.asStatesList()) + "}";
    }
}

