/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableSubgraphReachedSetView;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SSCARGState;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SSCPath;

class SSCReachedSet
extends ARGReachedSet.ForwardingARGReachedSet {
    private final SSCPath path;

    SSCReachedSet(ARGReachedSet pReached, SSCPath pPath) {
        super(pReached);
        this.path = pPath;
        assert (this.path.getFirstState().getSubgraph().toSet().containsAll(this.path.asStatesList())) : "path should traverse reachable states";
    }

    @Override
    public UnmodifiableReachedSet asReachedSet() {
        return new UnmodifiableSubgraphReachedSetView(this.path, (Function<AbstractState, Precision>)((Function)s -> super.asReachedSet().getPrecision(((SSCARGState)s).getSSCState())));
    }

    @Override
    public void removeSubtree(ARGState state) throws InterruptedException {
        this.removeSubtree(state, (List<Precision>)ImmutableList.of(), (List<Predicate<? super Precision>>)ImmutableList.of());
    }

    @Override
    public void removeSubtree(ARGState element, Precision newPrecision, Predicate<? super Precision> pPrecisionType) throws InterruptedException {
        this.removeSubtree(element, (List<Precision>)ImmutableList.of((Object)newPrecision), (List<Predicate<? super Precision>>)ImmutableList.of(pPrecisionType));
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void removeSubtree(ARGState cutState, List<Precision> newPrecisions, List<Predicate<? super Precision>> pPrecisionTypes) throws InterruptedException {
        Preconditions.checkArgument((newPrecisions.size() == pPrecisionTypes.size() ? 1 : 0) != 0);
        assert (this.path.getFirstState().getSubgraph().contains((Object)cutState));
        SSCARGState sccState = (SSCARGState)cutState;
        while (sccState.getSSCState().getWrappedState() != sccState.getWrappedState()) {
            sccState = (SSCARGState)Iterables.getOnlyElement(sccState.getParents());
        }
        assert (sccState.getSSCState().equals(((SSCARGState)cutState).getSSCState()));
        super.removeSubtree(sccState.getSSCState(), newPrecisions, pPrecisionTypes);
        for (ARGState state : sccState.getSubgraph()) {
            state.removeFromARG();
        }
    }

    public String toString() {
        return "SSCReachedSet {{" + this.asReachedSet().asCollection() + "}}";
    }
}

