/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor;

import java.io.PrintStream;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SingleSuccessorCompactorTransferRelation;
import org.sosy_lab.cpachecker.util.statistics.StatHist;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="cpa.singleSuccessorCompactor")
public class SingleSuccessorCompactorCPA
extends AbstractSingleWrapperCPA
implements ConfigurableProgramAnalysisWithBAM {
    @Option(description="max length of a chain of states, -1 for infinity")
    private int maxChainLength = -1;
    private @Nullable BlockPartitioning partitioning = null;
    private final StatHist chainSizes = new StatHist("Avg length of skipped chains"){

        @Override
        public String toString() {
            return String.format("%.2f", this.getAvg());
        }
    };
    private final LogManager logger;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(SingleSuccessorCompactorCPA.class);
    }

    private SingleSuccessorCompactorCPA(ConfigurableProgramAnalysis pCpa, LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        super(pCpa);
        config.inject((Object)this, SingleSuccessorCompactorCPA.class);
        this.logger = pLogger;
    }

    @Override
    public SingleSuccessorCompactorTransferRelation getTransferRelation() {
        return new SingleSuccessorCompactorTransferRelation(this.getWrappedCpa().getTransferRelation(), this.partitioning, this.chainSizes, this.maxChainLength);
    }

    @Override
    public void setPartitioning(BlockPartitioning pPartitioning) {
        ((ConfigurableProgramAnalysisWithBAM)this.getWrappedCpa()).setPartitioning(pPartitioning);
        this.partitioning = pPartitioning;
    }

    @Override
    public Reducer getReducer() throws InvalidConfigurationException {
        return ((ConfigurableProgramAnalysisWithBAM)this.getWrappedCpa()).getReducer();
    }

    LogManager getLogger() {
        return this.logger;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        super.collectStatistics(pStatsCollection);
        pStatsCollection.add(new Statistics(){

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                StatisticsUtils.write(pOut, 0, 50, SingleSuccessorCompactorCPA.this.chainSizes);
            }

            @Override
            public @Nullable String getName() {
                return "SSC-CPA";
            }
        });
    }
}

