/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatHist;

public class SingleSuccessorCompactorTransferRelation
extends AbstractSingleWrapperTransferRelation {
    private final @Nullable BlockPartitioning partitioning;
    private final StatHist chainSizes;
    private final int maxChainLength;

    SingleSuccessorCompactorTransferRelation(TransferRelation pDelegate, BlockPartitioning pPartitioning, StatHist pChainSizes, int pMaxChainLength) {
        super(pDelegate);
        this.partitioning = pPartitioning;
        this.chainSizes = pChainSizes;
        this.maxChainLength = pMaxChainLength;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState state, Precision precision) throws CPATransferException, InterruptedException {
        return this.getAbstractSuccessorsWithList(state, precision, null);
    }

    Collection<? extends AbstractState> getAbstractSuccessorsWithList(AbstractState state, Precision precision, @Nullable List<AbstractState> lst) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> states;
        int chainSize = 0;
        do {
            ++chainSize;
            if (lst == null) continue;
            lst.add(state);
        } while (this.canExpandChain(state = (AbstractState)Iterables.getFirst(states = this.transferRelation.getAbstractSuccessors(state, precision), null), states, chainSize));
        this.chainSizes.insertValue(chainSize);
        return states;
    }

    private boolean canExpandChain(AbstractState state, Collection<? extends AbstractState> states, int chainSize) {
        return states.size() == 1 && (this.maxChainLength == -1 || chainSize <= this.maxChainLength) && !AbstractStates.isTargetState(state) && !this.isAtBlockBorder(state);
    }

    private boolean isAtBlockBorder(AbstractState pState) {
        if (this.partitioning == null) {
            return false;
        }
        CFANode node = AbstractStates.extractLocation(pState);
        return this.partitioning.isCallNode(node) || this.partitioning.isReturnNode(node);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) {
        throw new UnsupportedOperationException();
    }
}

