/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slab;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;

public class EdgeSet
implements Serializable,
Iterable<CFAEdge> {
    private static final long serialVersionUID = 1L;
    private Set<CFAEdge> edges;
    private CFAEdge selected;

    public EdgeSet(Collection<CFAEdge> edges) {
        Preconditions.checkArgument((!edges.isEmpty() ? 1 : 0) != 0);
        this.edges = new LinkedHashSet<CFAEdge>(edges);
        this.selected = null;
    }

    public EdgeSet(EdgeSet other) {
        Preconditions.checkArgument((!other.edges.isEmpty() ? 1 : 0) != 0);
        this.edges = new LinkedHashSet<CFAEdge>(other.edges);
    }

    @Override
    public Iterator<CFAEdge> iterator() {
        return this.edges.iterator();
    }

    public void removeEdge(CFAEdge pEdge) {
        this.edges.remove(pEdge);
        if (this.selected == pEdge) {
            this.selected = null;
        }
    }

    public void select(CFAEdge pEdge) {
        this.selected = pEdge;
    }

    public CFAEdge choose() {
        if (!this.edges.isEmpty()) {
            if (this.selected == null || !this.edges.contains(this.selected)) {
                return this.edges.iterator().next();
            }
            return this.selected;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.edges.isEmpty();
    }

    public int size() {
        return this.edges.size();
    }

    public void clear() {
        this.edges.clear();
    }

    public boolean contains(CFAEdge edge) {
        return this.edges.contains(edge);
    }
}

