/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slab;

import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.SymbolicLocationsUtility;
import org.sosy_lab.cpachecker.cpa.slab.SLABDomain;
import org.sosy_lab.cpachecker.cpa.slab.SLABMergeOperator;
import org.sosy_lab.cpachecker.cpa.slab.SLABStopOperator;
import org.sosy_lab.cpachecker.cpa.slab.SLABTransferRelation;
import org.sosy_lab.cpachecker.cpa.slab.SLARGState;
import org.sosy_lab.cpachecker.util.CPAs;

public class SLABCPA
extends AbstractSingleWrapperCPA {
    private SLABDomain domain;
    private Configuration config;
    private LogManager logger;
    private ShutdownNotifier shutdownNotifier;
    private PredicateCPA predicateCpa;
    private CFA cfa;
    private Specification specification;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(SLABCPA.class);
    }

    private SLABCPA(ConfigurableProgramAnalysis pWrappedCpa, Configuration pConfig, LogManager pLogger, CFA pCfa, ShutdownNotifier pShutdownNotifier, Specification pSpecification) throws InvalidConfigurationException {
        super(pWrappedCpa);
        this.domain = new SLABDomain(pWrappedCpa.getAbstractDomain());
        this.predicateCpa = CPAs.retrieveCPAOrFail(this.getWrappedCpa(), PredicateCPA.class, SLABCPA.class);
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.specification = pSpecification;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new SLABTransferRelation(this.getWrappedCpa().getTransferRelation(), this.cfa, new SymbolicLocationsUtility(this.getPredicateCpa(), this.specification));
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return new SLARGState(null, null, true, false, this.getWrappedCpa().getInitialState(pNode, pPartition));
    }

    public CFA getCfa() {
        return this.cfa;
    }

    @Override
    public StopOperator getStopOperator() {
        return new SLABStopOperator(this.getAbstractDomain());
    }

    public PredicateCPA getPredicateCpa() {
        return this.predicateCpa;
    }

    LogManager getLogger() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return new SLABMergeOperator(this.domain);
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }
}

