/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slab;

import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGLogger;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefinerFactory;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsUtils;
import org.sosy_lab.cpachecker.cpa.slab.EdgeSet;
import org.sosy_lab.cpachecker.cpa.slab.SLABCPA;
import org.sosy_lab.cpachecker.cpa.slab.SLARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class SLABRefiner
implements Refiner,
StatisticsProvider {
    private final ARGBasedRefiner refiner;
    private SLABCPA slabCpa;
    private Solver solver;
    private ARGLogger argLogger;
    private boolean initialSliceDone = false;

    public SLABRefiner(ARGBasedRefiner pRefiner, SLABCPA pSlabCpa, Configuration config) throws InvalidConfigurationException {
        this.refiner = pRefiner;
        this.slabCpa = pSlabCpa;
        this.argLogger = new ARGLogger(config, this.slabCpa.getLogger());
        this.solver = this.slabCpa.getPredicateCpa().getSolver();
    }

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        PredicateCPA predicateCpa = CPAs.retrieveCPA(pCpa, PredicateCPA.class);
        SLABCPA argCpa = CPAs.retrieveCPA(pCpa, SLABCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(SlicingAbstractionsRefiner.class.getSimpleName() + " needs a PredicateCPA");
        }
        SlicingAbstractionsStrategy strategy = new SlicingAbstractionsStrategy(predicateCpa, predicateCpa.getConfiguration());
        PredicateCPARefinerFactory factory = new PredicateCPARefinerFactory(pCpa);
        ARGBasedRefiner refiner = factory.create(strategy);
        return new SLABRefiner(refiner, argCpa, predicateCpa.getConfiguration());
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        Optional<AbstractState> optionalTargetState;
        CounterexampleInfo counterexample = null;
        if (!this.initialSliceDone) {
            this.removeInfeasibleStates(pReached);
            this.argLogger.log("in refinement after removeInfeasibleStates", pReached.asCollection());
            this.sliceEdges((List<SLARGState>)FluentIterable.from((Iterable)pReached).transform(x -> (SLARGState)x).toList());
            this.argLogger.log("in refinement after sliceEdges", pReached.asCollection());
            this.initialSliceDone = true;
        }
        while ((optionalTargetState = pReached.stream().filter(x -> ((SLARGState)x).isTarget()).findFirst()).isPresent()) {
            AbstractState targetState = optionalTargetState.orElseThrow();
            ARGPath errorPath = ARGUtils.getShortestPathTo((ARGState)targetState);
            ARGReachedSet reached = new ARGReachedSet(pReached, this.slabCpa);
            assert (errorPath != null);
            counterexample = this.refiner.performRefinementForPath(reached, errorPath);
            this.argLogger.log("in refinement after sliceEdges", pReached.asCollection());
            if (counterexample.isSpurious()) continue;
            ((ARGState)targetState).addCounterexampleInformation(counterexample);
            return false;
        }
        this.argLogger.log("after successful refinement", pReached.asCollection());
        return true;
    }

    private void sliceEdges(List<SLARGState> allStates) throws InterruptedException, CPAException {
        for (SLARGState parent : allStates) {
            ArrayList<SLARGState> toSlice = new ArrayList<SLARGState>();
            for (ARGState argChild : parent.getChildren()) {
                SLARGState child = (SLARGState)argChild;
                boolean infeasible = this.checkEdge(parent, child);
                if (!infeasible) continue;
                toSlice.add(child);
            }
            for (SLARGState child : toSlice) {
                child.removeParent(parent);
            }
        }
    }

    private boolean checkEdge(SLARGState startState, SLARGState endState) throws InterruptedException, CPAException {
        assert (startState.getChildren().contains(endState));
        EdgeSet edgeSet = startState.getEdgeSetToChild(endState);
        if (startState.isTarget()) {
            edgeSet.clear();
            return true;
        }
        boolean infeasible = true;
        Iterator<CFAEdge> it = edgeSet.iterator();
        while (it.hasNext()) {
            CFAEdge cfaEdge = it.next();
            edgeSet.select(cfaEdge);
            if (this.isInfeasibleEdge(startState, endState)) {
                it.remove();
                continue;
            }
            infeasible = false;
        }
        return infeasible;
    }

    private boolean isInfeasibleEdge(SLARGState startState, SLARGState endState) throws InterruptedException, CPAException {
        SSAMap startSSAMap = SSAMap.emptySSAMap().withDefault(1);
        PointerTargetSet startPts = PointerTargetSet.emptyPointerTargetSet();
        PathFormulaManager pfmgr = this.slabCpa.getPredicateCpa().getPathFormulaManager();
        BooleanFormula formula = SlicingAbstractionsUtils.buildPathFormula((ARGState)startState, (ARGState)endState, startSSAMap, startPts, this.solver.getFormulaManager(), pfmgr, SlicingAbstractionsUtils.AbstractionPosition.BOTH).getFormula();
        boolean infeasible = false;
        try (ProverEnvironment thmProver = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            thmProver.push(formula);
            infeasible = thmProver.isUnsat();
        }
        catch (SolverException e) {
            throw new CPAException("Solver Failure", e);
        }
        return infeasible;
    }

    private void removeInfeasibleStates(ReachedSet pReached) throws InterruptedException, CPAException {
        ArrayList<SLARGState> toRemove = new ArrayList<SLARGState>();
        for (AbstractState state : pReached) {
            SLARGState slabState = AbstractStates.extractStateByType(state, SLARGState.class);
            BooleanFormula stateFormula = PredicateAbstractState.getPredicateState(slabState).getAbstractionFormula().asFormula();
            try {
                ProverEnvironment thmProver = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);
                try {
                    thmProver.push(stateFormula);
                    if (!thmProver.isUnsat()) continue;
                    slabState.removeFromARG();
                    toRemove.add(slabState);
                }
                finally {
                    if (thmProver == null) continue;
                    thmProver.close();
                }
            }
            catch (SolverException e) {
                throw new CPAException("Solver Failure", e);
            }
        }
        pReached.removeAll(toRemove);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.refiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.refiner)).collectStatistics(pStatsCollection);
        }
    }
}

