/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slab;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.SymbolicLocationsUtility;
import org.sosy_lab.cpachecker.cpa.slab.EdgeSet;
import org.sosy_lab.cpachecker.cpa.slab.SLARGState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.java_smt.api.SolverException;

public class SLABTransferRelation
implements TransferRelation {
    private final TransferRelation transferRelation;
    private final ImmutableSet<CFAEdge> allTransitions;
    private final SymbolicLocationsUtility symbolicLocationsUtility;

    public SLABTransferRelation(TransferRelation pTransferRelation, CFA pCfa, SymbolicLocationsUtility pSymbolicLocationseUtility) {
        this.transferRelation = pTransferRelation;
        this.allTransitions = SLABTransferRelation.makeTotalTransitionEdgeSet(pCfa);
        this.symbolicLocationsUtility = pSymbolicLocationseUtility;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        ARGState element = (ARGState)pState;
        AbstractState wrappedState = element.getWrappedState();
        Collection<? extends AbstractState> successors = this.transferRelation.getAbstractSuccessors(wrappedState, pPrecision);
        ArrayList<SLARGState> wrappedSuccessors = new ArrayList<SLARGState>();
        for (AbstractState abstractState : successors) {
            boolean isError;
            boolean isInit;
            try {
                isInit = this.symbolicLocationsUtility.isInit(abstractState);
                isError = this.symbolicLocationsUtility.isError(abstractState);
            }
            catch (SolverException e) {
                throw new CPATransferException("Could not determine successor due to SolverException", e);
            }
            SLARGState successorElem = new SLARGState((SLARGState)pState, new EdgeSet((Collection<CFAEdge>)this.allTransitions), isInit, isError, abstractState);
            wrappedSuccessors.add(successorElem);
        }
        ((SLARGState)pState).markExpanded();
        return wrappedSuccessors;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    private static ImmutableSet<CFAEdge> makeTotalTransitionEdgeSet(CFA pCfa) {
        return FluentIterable.from(pCfa.getAllNodes()).transformAndConcat(CFAUtils::leavingEdges).toSet();
    }
}

