/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.SimpleTargetInformation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocations;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.Splitable;
import org.sosy_lab.cpachecker.cpa.slab.EdgeSet;

public class SLARGState
extends ARGState
implements AbstractState,
Targetable,
AbstractStateWithLocations {
    private static final long serialVersionUID = -1008999926741613988L;
    private Map<SLARGState, EdgeSet> parentsToEdgeSets = new HashMap<SLARGState, EdgeSet>();
    private Map<SLARGState, EdgeSet> childrenToEdgeSets = new HashMap<SLARGState, EdgeSet>();
    private boolean isInit;
    private boolean isError;
    private boolean isAbstractionState = true;

    public SLARGState(SLARGState parent, EdgeSet edgeFromParent, boolean isInit, boolean isError, AbstractState wrappedState) {
        super(wrappedState, null);
        if (parent != null) {
            assert (edgeFromParent != null);
            this.addParent(parent, edgeFromParent);
        }
        this.isInit = isInit;
        this.isError = isError;
    }

    public SLARGState(SLARGState pState) {
        this(null, null, pState.isInit, pState.isError, pState.getWrappedState());
    }

    public void useAsReplacement(SLARGState pState1, SLARGState pState2) {
        EdgeSet newEdge;
        EdgeSet edgeToCopy;
        for (ARGState argParent : pState2.getParents()) {
            edgeToCopy = pState2.parentsToEdgeSets.get(argParent);
            assert (edgeToCopy != null);
            newEdge = new EdgeSet(edgeToCopy);
            if (!Objects.equals(argParent, pState2)) {
                this.addParent((SLARGState)argParent, newEdge);
                continue;
            }
            this.addParent(this, newEdge);
        }
        for (ARGState argChild : pState2.getChildren()) {
            edgeToCopy = pState2.getEdgeSetToChild(argChild);
            assert (edgeToCopy != null);
            newEdge = new EdgeSet(edgeToCopy);
            if (Objects.equals(argChild, pState2)) continue;
            ((SLARGState)argChild).addParent(this, newEdge);
        }
        pState2.removeFromARG();
        for (ARGState argParent : pState1.getParents()) {
            SLARGState parent = (SLARGState)argParent;
            this.addParent(parent, new EdgeSet(pState1.parentsToEdgeSets.get(parent)));
        }
    }

    @Override
    public CFAEdge getEdgeToChild(ARGState argChild) {
        EdgeSet edgeSet = this.getEdgeSetToChild(argChild);
        return edgeSet != null ? this.getEdgeSetToChild(argChild).choose() : null;
    }

    @Override
    public List<CFAEdge> getEdgesToChild(ARGState argChild) {
        CFAEdge edge = this.getEdgeToChild(argChild);
        if (edge != null) {
            return ImmutableList.of((Object)edge);
        }
        return ImmutableList.of();
    }

    public @Nullable EdgeSet getEdgeSetToChild(ARGState child) {
        return this.childrenToEdgeSets.get(child);
    }

    @Override
    public boolean isTarget() {
        return this.isError;
    }

    public boolean isInit() {
        return this.isInit;
    }

    @Override
    public @NonNull Set<Targetable.TargetInformation> getTargetInformation() throws IllegalStateException {
        return SimpleTargetInformation.singleton("Error state reached");
    }

    public boolean isAbstractionState() {
        return this.isAbstractionState;
    }

    @Override
    public String toString() {
        String result = super.toString();
        return result.replace("ARG State", "SLARG State");
    }

    public void addParent(SLARGState pParent, EdgeSet pEdgeSet) {
        super.addParent(pParent);
        assert (pEdgeSet != null);
        assert (!this.parentsToEdgeSets.containsKey(pParent));
        assert (!this.parentsToEdgeSets.containsValue(pEdgeSet));
        this.parentsToEdgeSets.put(pParent, pEdgeSet);
        pParent.childrenToEdgeSets.put(this, pEdgeSet);
    }

    @Override
    public void addParent(ARGState s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeParent(ARGState argParent) {
        SLARGState parent = (SLARGState)argParent;
        super.removeParent(parent);
        assert (this.parentsToEdgeSets.containsKey(parent));
        this.parentsToEdgeSets.remove(parent);
        parent.childrenToEdgeSets.remove(this);
    }

    @Override
    public void removeFromARG() {
        assert (!this.isDestroyed()) : "Don't use destroyed ARGState " + this;
        for (ARGState argParent : new ArrayList<ARGState>(this.getParents())) {
            if (Objects.equals(argParent, this)) continue;
            SLARGState parent = (SLARGState)argParent;
            this.removeParent(parent);
        }
        for (ARGState argChild : new ArrayList<ARGState>(this.getChildren())) {
            if (Objects.equals(argChild, this)) continue;
            SLARGState child = (SLARGState)argChild;
            child.removeParent(this);
        }
        super.removeFromARG();
    }

    @Override
    public ARGState forkWithReplacements(Collection<AbstractState> pReplacementStates) {
        AbstractState wrappedState = this.getWrappedState();
        AbstractState newWrappedState = null;
        newWrappedState = wrappedState instanceof Splitable ? ((Splitable)((Object)wrappedState)).forkWithReplacements(pReplacementStates) : wrappedState;
        SLARGState newState = new SLARGState(null, null, this.isInit(), this.isTarget(), newWrappedState);
        newState.makeTwinOf(this);
        return newState;
    }

    @Override
    public void replaceInARGWith(ARGState replacement) {
        assert (!this.isDestroyed()) : "Don't use destroyed ARGState " + this;
        assert (!replacement.isDestroyed()) : "Don't use destroyed ARGState " + replacement;
        assert (!this.isCovered()) : "Not implemented: Replacement of covered element " + this;
        assert (!replacement.isCovered()) : "Cannot replace with covered element " + replacement;
        assert (!this.equals(replacement)) : "Don't replace ARGState " + this + " with itself";
        for (ARGState child : new ArrayList<ARGState>(this.getChildren())) {
            assert (child.getParents().contains(this)) : "Inconsistent ARG at " + this;
            ((SLARGState)child).addParent((SLARGState)replacement, new EdgeSet(this.getEdgeSetToChild(child)));
            child.removeParent(this);
        }
        for (ARGState parent : new ArrayList<ARGState>(this.getParents())) {
            assert (parent.getChildren().contains(this)) : "Inconsistent ARG at " + this;
            ((SLARGState)replacement).addParent((SLARGState)parent, new EdgeSet(((SLARGState)parent).getEdgeSetToChild(this)));
            this.removeParent(parent);
        }
        super.replaceInARGWith(replacement);
    }

    @Override
    public Iterable<CFANode> getLocationNodes() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        for (EdgeSet value : this.parentsToEdgeSets.values()) {
            for (CFAEdge edge : value) {
                locations.add((Object)edge.getSuccessor());
            }
        }
        for (EdgeSet value : this.childrenToEdgeSets.values()) {
            for (CFAEdge edge : value) {
                locations.add((Object)edge.getPredecessor());
            }
        }
        return locations.build();
    }

    @Override
    public Iterable<CFAEdge> getOutgoingEdges() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<CFAEdge> getIngoingEdges() {
        throw new UnsupportedOperationException();
    }
}

