/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slab;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsUtils;
import org.sosy_lab.cpachecker.cpa.slab.EdgeSet;
import org.sosy_lab.cpachecker.cpa.slab.SLARGState;

public class SLARGToDotWriter {
    public static void write(Appendable sb, Collection<SLARGState> states, String label) throws IOException {
        ARGToDotWriter toDotWriter = new ARGToDotWriter(sb);
        for (SLARGState state : states) {
            if (state.isDestroyed()) continue;
            sb.append(SLARGToDotWriter.determineNode(state));
            for (ARGState child : state.getChildren()) {
                sb.append(SLARGToDotWriter.determineEdge(state, child));
            }
        }
        label = String.format("label=\"%s\";%nlabelloc=top;%nlabeljust=left;%n", label);
        sb.append(label);
        toDotWriter.finish();
    }

    private static CharSequence determineEdge(ARGState state, ARGState successorState) {
        StringBuilder builder = new StringBuilder();
        builder.append(state.getStateId()).append(" -> ").append(successorState.getStateId());
        builder.append(" [");
        assert (state instanceof SLARGState);
        EdgeSet edgeSet = ((SLARGState)state).getEdgeSetToChild(successorState);
        String label = edgeSet == null ? "-1" : (edgeSet.size() == 1 ? edgeSet.choose().toString() : String.valueOf(edgeSet.size()));
        if (state.getChildren().contains(successorState)) {
            builder.append(String.format("style=\"bold\" color=\"blue\" label=\"%s\"", label));
            builder.append(" id=\"");
            builder.append(state.getStateId());
            builder.append(" -> ");
            builder.append(successorState.getStateId());
            builder.append("\"");
        }
        builder.append("]").append(System.lineSeparator());
        return builder.toString();
    }

    private static CharSequence determineNode(SLARGState pState) {
        StringBuilder builder = new StringBuilder();
        builder.append(pState.getStateId());
        builder.append(" [");
        String color = SLARGToDotWriter.determineColor(pState);
        if (color != null) {
            builder.append("fillcolor=\"").append(color).append("\" ");
        }
        builder.append("label=\"").append(SLARGToDotWriter.determineLabel(pState));
        Iterable<CFANode> locations = pState.getLocationNodes();
        ImmutableList locationNumbers = FluentIterable.from(locations).transform(CFANode::getNodeNumber).toList();
        builder.append("@N");
        builder.append((CharSequence)SLARGToDotWriter.generateLocationString((Collection<Integer>)locationNumbers));
        builder.append("\" ");
        builder.append("id=\"").append(pState.getStateId());
        builder.append("\"]").append(System.lineSeparator());
        return builder.toString();
    }

    private static Object determineLabel(SLARGState pState) {
        return pState.getStateId();
    }

    private static String determineColor(SLARGState pState) {
        if (pState.isTarget()) {
            return "red";
        }
        if (pState.isInit()) {
            return "yellow";
        }
        if (!PredicateAbstractState.getPredicateState(pState).isAbstractionState()) {
            return "white";
        }
        if (pState.wasExpanded()) {
            return "cornflowerblue";
        }
        return "orange";
    }

    public static void writeRankedAbstractions(Appendable sb, Collection<SLARGState> states, String label) throws IOException {
        ARGState root = (ARGState)FluentIterable.from(states).filter(x -> x.isInit()).toList().get(0);
        int maxrank = 0;
        ARGToDotWriter toDotWriter = new ARGToDotWriter(sb);
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> reached = new HashSet<ARGState>();
        HashMap<ARGState, Integer> rank = new HashMap<ARGState, Integer>();
        waitlist.add(root);
        reached.add(root);
        rank.put(root, maxrank);
        while (!waitlist.isEmpty()) {
            ARGState currentState = (ARGState)waitlist.pop();
            if (currentState.isDestroyed() || !PredicateAbstractState.getPredicateState(currentState).isAbstractionState()) continue;
            sb.append(SLARGToDotWriter.determineNode((SLARGState)currentState));
            for (ARGState child : SlicingAbstractionsUtils.calculateOutgoingSegments(currentState).keySet()) {
                if (!reached.contains(child)) {
                    waitlist.add(child);
                    reached.add(child);
                }
                sb.append(SLARGToDotWriter.determineEdge(currentState, child));
                if (rank.containsKey(child)) continue;
                int currentRank = (Integer)rank.get(currentState) + 1;
                if (currentRank > maxrank) {
                    ++maxrank;
                }
                rank.put(child, (Integer)rank.get(currentState) + 1);
            }
            sb.append(SLARGToDotWriter.addrank(currentState, (Integer)rank.get(currentState)));
        }
        for (ARGState state : FluentIterable.from(states).filter(x -> !reached.contains(x)).toList()) {
            if (state.isDestroyed() || !PredicateAbstractState.getPredicateState(state).isAbstractionState()) continue;
            sb.append(SLARGToDotWriter.determineNode((SLARGState)state));
            for (ARGState child : SlicingAbstractionsUtils.calculateOutgoingSegments(state).keySet()) {
                sb.append(SLARGToDotWriter.determineEdge(state, child));
            }
        }
        for (int i = 0; i < maxrank; ++i) {
            sb.append(String.format("invisiblenode_%d->invisiblenode_%d[style=invis]%n", i, i + 1));
        }
        label = String.format("label=\"%s\";%nlabelloc=top;%nlabeljust=left;%n", label);
        sb.append(label);
        toDotWriter.finish();
    }

    private static String addrank(ARGState state, Integer pInteger) {
        return String.format("invisiblenode_%d[style=invis label = \"\"];%n{rank=same;invisiblenode_%d;%d};%n", pInteger, pInteger, state.getStateId());
    }

    public static StringBuilder generateLocationString(Collection<Integer> pLocationNumbers) {
        ImmutableSortedSet locationNumbers = FluentIterable.from(pLocationNumbers).toSortedSet(Comparator.naturalOrder());
        StringBuilder builder = new StringBuilder();
        int state = 0;
        int lastNumber = -1;
        String separator = ",";
        for (Integer currentLocation : locationNumbers) {
            switch (state) {
                case 0: {
                    builder.append(currentLocation);
                    state = 1;
                    break;
                }
                case 1: {
                    if (currentLocation != lastNumber + 1 || currentLocation.equals(locationNumbers.last())) {
                        builder.append(",").append(currentLocation);
                        break;
                    }
                    state = 2;
                    break;
                }
                case 2: {
                    if (currentLocation != lastNumber + 1) {
                        builder.append(separator).append(lastNumber).append(",").append(currentLocation);
                        separator = ",";
                        state = 1;
                        break;
                    }
                    if (currentLocation.equals(locationNumbers.last())) {
                        builder.append(separator).append(currentLocation);
                        state = -1;
                        break;
                    }
                    separator = "-";
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected state in location string generation automaton");
                }
            }
            lastNumber = currentLocation;
        }
        return builder;
    }
}

