/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slicing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingPrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class PrecisionDelegatingPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment delegate;

    public PrecisionDelegatingPrecisionAdjustment(PrecisionAdjustment pDelegateAdjustment) {
        this.delegate = pDelegateAdjustment;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException, InterruptedException {
        Preconditions.checkState((boolean)(pPrecision instanceof SlicingPrecision), (String)"Precision not of type %s, but %s", (Object)SlicingPrecision.class.getSimpleName(), (Object)pPrecision.getClass().getSimpleName());
        AbstractState wrappedState = pState;
        Precision wrappedPrecision = ((SlicingPrecision)pPrecision).getWrappedPrec();
        Optional<PrecisionAdjustmentResult> delegateResult = this.delegate.prec(wrappedState, wrappedPrecision, pStates, pStateProjection, pFullState);
        if (delegateResult.isPresent()) {
            PrecisionAdjustmentResult adjustmentResult = delegateResult.orElseThrow();
            AbstractState state = adjustmentResult.abstractState();
            Precision precision = adjustmentResult.precision();
            PrecisionAdjustmentResult finalResult = state != wrappedState || precision != wrappedPrecision ? PrecisionAdjustmentResult.create(state, ((SlicingPrecision)pPrecision).getNew(precision), adjustmentResult.action()) : PrecisionAdjustmentResult.create(pState, pPrecision, adjustmentResult.action());
            return Optional.of(finalResult);
        }
        return delegateResult;
    }
}

