/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slicing;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.slicing.PrecisionDelegatingMerge;
import org.sosy_lab.cpachecker.cpa.slicing.PrecisionDelegatingPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.slicing.PrecisionDelegatingStop;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingPrecision;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.slicing.Slice;
import org.sosy_lab.cpachecker.util.slicing.Slicer;
import org.sosy_lab.cpachecker.util.slicing.SlicerFactory;

@Options(prefix="cpa.slicing")
public class SlicingCPA
extends AbstractSingleWrapperCPA
implements StatisticsProvider {
    @Option(secure=true, name="refinableSlice", description="Whether to use a refinable slicing precision that starts with an empty slice, or a statically computed, fixed slicing precision")
    private boolean useRefinableSlice = false;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final CFA cfa;
    private final Specification spec;
    private final SlicerFactory slicerFactory;
    private final Slicer slicer;
    private TransferRelation transferRelation;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;
    private PrecisionAdjustment precisionAdjustment;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(SlicingCPA.class);
    }

    public SlicingCPA(ConfigurableProgramAnalysis pCpa, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Configuration pConfig, CFA pCfa, Specification pSpec) throws CPAException, InvalidConfigurationException, InterruptedException {
        super(pCpa);
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.config = pConfig;
        this.cfa = pCfa;
        this.spec = pSpec;
        this.transferRelation = new SlicingTransferRelation(pCpa.getTransferRelation());
        this.mergeOperator = new PrecisionDelegatingMerge(pCpa.getMergeOperator());
        this.stopOperator = new PrecisionDelegatingStop(pCpa.getStopOperator());
        this.precisionAdjustment = new PrecisionDelegatingPrecisionAdjustment(pCpa.getPrecisionAdjustment());
        this.slicerFactory = new SlicerFactory();
        this.slicer = this.slicerFactory.create(this.logger, this.shutdownNotifier, this.config, pCfa);
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return super.getInitialState(node, partition);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        Precision wrappedPrec = this.getWrappedCpa().getInitialPrecision(pNode, pPartition);
        ImmutableSet<CFAEdge> relevantEdges = this.useRefinableSlice ? ImmutableSet.of() : this.computeSlice(this.cfa, this.spec).getRelevantEdges();
        return new SlicingPrecision(wrappedPrec, (Set<CFAEdge>)relevantEdges);
    }

    Slicer getSlicer() {
        return this.slicer;
    }

    private Slice computeSlice(CFA pCfa, Specification pSpec) throws InterruptedException {
        return this.slicer.getSlice(pCfa, pSpec);
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public CFA getCfa() {
        return this.cfa;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.slicerFactory.collectStatistics(pStatsCollection);
        if (this.slicer instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.slicer)).collectStatistics(pStatsCollection);
        }
        super.collectStatistics(pStatsCollection);
    }
}

