/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slicing;

import java.util.Collection;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingCPA;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CPAs;

public class SlicingDelegatingRefiner
implements Refiner,
StatisticsProvider {
    private final Refiner delegate;
    private final SlicingRefiner slicingRefiner;

    public static SlicingDelegatingRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        SlicingCPA slicingCPA = CPAs.retrieveCPAOrFail(pCpa, SlicingCPA.class, SlicingDelegatingRefiner.class);
        Configuration config = slicingCPA.getConfig();
        SlicingDelegatingRefinerOptions options = new SlicingDelegatingRefinerOptions();
        config.inject((Object)options);
        if (options.delegate == null) {
            throw new InvalidConfigurationException("Option SlicingDelegatingRefiner.refiner not set");
        }
        Refiner delegate = options.delegate.create(pCpa, slicingCPA.getLogger(), slicingCPA.getShutdownNotifier());
        SlicingRefiner slicingRefiner = SlicingRefiner.create(pCpa);
        return new SlicingDelegatingRefiner(delegate, slicingRefiner);
    }

    private SlicingDelegatingRefiner(Refiner pDelegateRefiner, SlicingRefiner pSlicingRefiner) {
        this.delegate = pDelegateRefiner;
        this.slicingRefiner = pSlicingRefiner;
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        boolean sliceRefinementSuccessful = this.slicingRefiner.updatePrecisionAndRemoveSubtree(pReached);
        if (sliceRefinementSuccessful) {
            return true;
        }
        boolean refinementResult = this.delegate.performRefinement(pReached);
        if (!refinementResult) {
            for (ARGPath targetPath : this.slicingRefiner.getTargetPaths(pReached)) {
                if (!this.slicingRefiner.isFeasible(targetPath)) continue;
                CounterexampleInfo cex = this.slicingRefiner.getCounterexample(targetPath);
                targetPath.getLastState().replaceCounterexampleInformation(cex);
            }
        }
        return refinementResult;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        if (this.delegate instanceof Statistics) {
            statsCollection.add((Statistics)((Object)this.delegate));
        } else if (this.delegate instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.delegate)).collectStatistics(statsCollection);
        }
    }

    @Options(prefix="SlicingDelegatingRefiner")
    private static class SlicingDelegatingRefinerOptions {
        @Option(secure=true, name="refiner", required=true, description="Refiner that SlicingDelegatingRefiner should delegate to")
        @ClassOption(packagePrefix={"org.sosy_lab.cpachecker"})
        private Refiner.Factory delegate = null;

        private SlicingDelegatingRefinerOptions() {
        }
    }
}

