/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slicing;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;

public class SlicingPrecision
implements WrapperPrecision {
    private final Precision wrappedPrec;
    private final Set<CFAEdge> relevantEdges;

    public SlicingPrecision(Precision pWrappedPrec, Set<CFAEdge> pRelevantEdges) {
        this.wrappedPrec = pWrappedPrec;
        this.relevantEdges = pRelevantEdges;
    }

    public SlicingPrecision getNew(Precision pWrappedPrec) {
        return new SlicingPrecision(pWrappedPrec, this.relevantEdges);
    }

    public SlicingPrecision getNew(Precision pWrappedPrec, Set<CFAEdge> pIncrement) {
        HashSet<CFAEdge> newRelevantEdges = new HashSet<CFAEdge>(this.relevantEdges);
        newRelevantEdges.addAll(pIncrement);
        return new SlicingPrecision(pWrappedPrec, newRelevantEdges);
    }

    public boolean isRelevant(CFAEdge pEdge) {
        return this.relevantEdges.contains(pEdge);
    }

    public Set<CFAEdge> getRelevant() {
        return this.relevantEdges;
    }

    public Precision getWrappedPrec() {
        return this.wrappedPrec;
    }

    @Override
    public <T extends Precision> T retrieveWrappedPrecision(Class<T> pType) {
        if (this.wrappedPrec.getClass().equals(pType)) {
            return (T)this.wrappedPrec;
        }
        if (this.wrappedPrec instanceof WrapperPrecision) {
            return ((WrapperPrecision)this.wrappedPrec).retrieveWrappedPrecision(pType);
        }
        return null;
    }

    @Override
    public Precision replaceWrappedPrecision(Precision pNewPrecision, Predicate<? super Precision> pReplaceType) {
        Precision newPrecision = null;
        if (pReplaceType.apply((Object)this.wrappedPrec)) {
            newPrecision = pNewPrecision;
        } else if (this.wrappedPrec instanceof WrapperPrecision) {
            newPrecision = ((WrapperPrecision)this.wrappedPrec).replaceWrappedPrecision(pNewPrecision, pReplaceType);
        }
        if (newPrecision == null) {
            return null;
        }
        return new SlicingPrecision(newPrecision, this.relevantEdges);
    }

    @Override
    public Iterable<Precision> getWrappedPrecisions() {
        return Collections.singleton(this.wrappedPrec);
    }

    public final boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        SlicingPrecision that = (SlicingPrecision)pO;
        return Objects.equals(this.wrappedPrec, that.wrappedPrec) && Objects.equals(this.relevantEdges, that.relevantEdges);
    }

    public final int hashCode() {
        return Objects.hash(this.wrappedPrec, this.relevantEdges);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{\n\twrapped precisions: " + this.wrappedPrec + ",\n\trelevant edges: " + this.relevantEdges + "}";
    }

    public static class FullPrecision
    extends SlicingPrecision {
        public FullPrecision(Precision pWrappedPrec) {
            super(pWrappedPrec, (Set<CFAEdge>)ImmutableSet.of());
        }

        @Override
        public boolean isRelevant(CFAEdge pEdge) {
            return true;
        }

        @Override
        public SlicingPrecision getNew(Precision pWrappedPrec) {
            return new FullPrecision(pWrappedPrec);
        }

        @Override
        public SlicingPrecision getNew(Precision pWrappedPrec, Set<CFAEdge> pIncrement) {
            return this.getNew(pWrappedPrec);
        }
    }
}

