/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slicing;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeTransferRelation;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingCPA;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingPrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.cpachecker.util.refinement.PrefixProvider;
import org.sosy_lab.cpachecker.util.slicing.Slicer;

@Options(prefix="cpa.slicing.refinement")
public class SlicingRefiner
implements Refiner {
    @Option(secure=true, description="Allow counterexamples that are valid only on the program slice. If you set this to `false`, you may have to set takeEagerSlice=true to avoid failed refinements. If this is set to true, the counterexample check won't work (in general), so you have to turn it off.")
    private boolean counterexampleCheckOnSlice = false;
    @Option(secure=true, description="Use all assumptions of a target path as slicing criteria, not just the edge to the target location.")
    private boolean takeEagerSlice = false;
    @Option(secure=true, description="What kind of restart to do after a successful refinement")
    private RestartStrategy restartStrategy = RestartStrategy.PIVOT;
    @Option(secure=true, description="How to refine the slice:\n- CEX_ASSUME_DEPS: Add the dependencies of all counterexample assume edges to the slice.\n- INFEASIBLE_PREFIX_ASSUME_DEPS: Find an infeasible prefix and add the dependencies of all assume edges that are part of the infeasible prefix to the slice. Requires a prefix provider ('cpa.slicing.refinement.prefixProvider').\n- CEX_FIRST_ASSUME_DEPS: Add the dependencies of the first counterexample assume edges, that is not already part of the slice, to the slice.\n- CEX_LAST_ASSUME_DEPS: Add the dependencies of the last counterexample assume edges, that is not already part of the slice, to the slice.\n")
    private RefineStrategy refineStrategy = RefineStrategy.CEX_ASSUME_DEPS;
    @Option(secure=true, name="prefixProvider", description="Which prefix provider to use? (give class name) If the package name starts with 'org.sosy_lab.cpachecker.', this prefix can be omitted.")
    @ClassOption(packagePrefix={"org.sosy_lab.cpachecker"})
    private PrefixProvider.Factory prefixProviderFactory;
    private Slicer slicer;
    private CFA cfa;
    private final PathExtractor pathExtractor;
    private final ARGCPA argCpa;
    private final TransferRelation transfer;
    private final WrapperPrecision currentPrecision;
    private final Precision fullPrecision;
    private final AbstractState initialState;
    private final PrefixProvider prefixProvider;
    private Set<Integer> previousTargetPaths = new HashSet<Integer>();
    private int refinementCount = 0;

    public static SlicingRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        SlicingCPA slicingCPA = CPAs.retrieveCPAOrFail(pCpa, SlicingCPA.class, SlicingRefiner.class);
        LogManager logger = slicingCPA.getLogger();
        Configuration config = slicingCPA.getConfig();
        CFA cfa = slicingCPA.getCfa();
        Slicer slicer = slicingCPA.getSlicer();
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, SlicingRefiner.class);
        PathExtractor pathExtractor = new PathExtractor(logger, config);
        FunctionEntryNode initialCfaNode = cfa.getMainFunction();
        StateSpacePartition partition = StateSpacePartition.getDefaultPartition();
        ConfigurableProgramAnalysis delegateCpa = (ConfigurableProgramAnalysis)Iterables.getOnlyElement(slicingCPA.getWrappedCPAs());
        CompositeCPA parentCompositeCpa = (CompositeCPA)Iterables.getOnlyElement(argCpa.getWrappedCPAs());
        CompositeTransferRelation transferRelation = parentCompositeCpa.getTransferRelation();
        try {
            AbstractState initialCompositeState = parentCompositeCpa.getInitialState(initialCfaNode, partition);
            Precision delegatePrecision = delegateCpa.getInitialPrecision(initialCfaNode, partition);
            WrapperPrecision parentPrecision = (WrapperPrecision)parentCompositeCpa.getInitialPrecision(initialCfaNode, partition);
            SlicingPrecision.FullPrecision slicingFullPrecision = new SlicingPrecision.FullPrecision(delegatePrecision);
            Precision parentFullPrecision = parentPrecision.replaceWrappedPrecision(slicingFullPrecision, (Predicate<? super Precision>)Predicates.instanceOf(SlicingPrecision.class));
            return new SlicingRefiner(pathExtractor, argCpa, slicer, cfa, transferRelation, initialCompositeState, parentPrecision, parentFullPrecision, config);
        }
        catch (InterruptedException pE) {
            throw new AssertionError((Object)pE);
        }
    }

    private SlicingRefiner(PathExtractor pPathExtractor, ARGCPA pArgCpa, Slicer pSlicer, CFA pCfa, TransferRelation pTransferRelation, AbstractState pInitialState, WrapperPrecision pCurrentArgPrecision, Precision pFullPrecision, Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.pathExtractor = pPathExtractor;
        this.argCpa = pArgCpa;
        this.slicer = pSlicer;
        this.cfa = pCfa;
        this.currentPrecision = pCurrentArgPrecision;
        this.fullPrecision = pFullPrecision;
        this.transfer = pTransferRelation;
        this.initialState = pInitialState;
        if (this.prefixProviderFactory != null) {
            this.prefixProvider = this.prefixProviderFactory.create(pArgCpa);
        } else {
            this.prefixProvider = null;
            if (this.refineStrategy == RefineStrategy.INFEASIBLE_PREFIX_ASSUME_DEPS) {
                throw new InvalidConfigurationException("Refinement strategy " + RefineStrategy.INFEASIBLE_PREFIX_ASSUME_DEPS + " requires a prefix provider ('cpa.slicing.refinement.prefixProvider')");
            }
        }
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        boolean anyFeasible = false;
        for (ARGPath tp : this.getTargetPaths(pReached)) {
            int targetPathId = this.obtainTargetPathId(tp);
            if (this.previousTargetPaths.contains(targetPathId)) {
                throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, tp);
            }
            if (this.isFeasible(tp)) {
                CounterexampleInfo cex = this.getCounterexample(tp);
                tp.getLastState().addCounterexampleInformation(cex);
                anyFeasible = true;
                continue;
            }
            this.previousTargetPaths.add(targetPathId);
        }
        if (anyFeasible) {
            return false;
        }
        return this.updatePrecisionAndRemoveSubtree(pReached);
    }

    CounterexampleInfo getCounterexample(ARGPath pTargetPath) {
        return CounterexampleInfo.feasibleImprecise(pTargetPath);
    }

    Collection<ARGPath> getTargetPaths(ReachedSet pReached) throws RefinementFailedException, InterruptedException {
        ARGReachedSet argReached = new ARGReachedSet(pReached, this.argCpa, this.refinementCount);
        Collection<ARGState> targetStates = this.pathExtractor.getTargetStates(argReached);
        List<ARGPath> targetPaths = this.pathExtractor.getTargetPaths(targetStates);
        return targetPaths;
    }

    private int obtainTargetPathId(ARGPath pTargetPath) {
        return pTargetPath.toString().hashCode();
    }

    private static Collection<? extends AbstractState> computeSuccessors(TransferRelation pTransferRelation, AbstractState pState, Precision pPrecision, CFAEdge pEdge) throws CPAException, InterruptedException {
        try {
            return pTransferRelation.getAbstractSuccessorsForEdge(pState, pPrecision, pEdge);
        }
        catch (CPATransferException ex) {
            throw new CPAException("Computation of successor failed for checking path: " + ex.getMessage(), ex);
        }
    }

    private static boolean isFeasible(ARGPath pTargetPath, AbstractState pInitialState, TransferRelation pTransferRelation, Precision pPrecision) throws CPAException, InterruptedException {
        AbstractState state = pInitialState;
        PathIterator iterator = pTargetPath.fullPathIterator();
        while (iterator.hasNext()) {
            do {
                CFAEdge outgoingEdge;
                Collection<? extends AbstractState> successorSet;
                if ((successorSet = SlicingRefiner.computeSuccessors(pTransferRelation, state, pPrecision, outgoingEdge = iterator.getOutgoingEdge())).isEmpty()) {
                    return false;
                }
                state = (AbstractState)Iterables.get(successorSet, (int)0);
                iterator.advance();
            } while (!iterator.isPositionWithState());
        }
        return true;
    }

    boolean isFeasible(ARGPath pTargetPath) throws CPAException, InterruptedException {
        Precision precision;
        if (this.counterexampleCheckOnSlice) {
            Set<CFAEdge> sliceForTargetPath = this.getSlice(pTargetPath);
            SlicingPrecision fullSlicingPrecision = Precisions.extractPrecisionByType(this.fullPrecision, SlicingPrecision.class);
            assert (fullSlicingPrecision != null) : "No " + SlicingPrecision.class.getSimpleName() + " in precision: " + this.fullPrecision;
            SlicingPrecision targetPathSlice = new SlicingPrecision(fullSlicingPrecision.getWrappedPrec(), sliceForTargetPath);
            precision = this.currentPrecision.replaceWrappedPrecision(targetPathSlice, (Predicate<? super Precision>)Predicates.instanceOf(SlicingPrecision.class));
        } else {
            precision = this.fullPrecision;
        }
        return SlicingRefiner.isFeasible(pTargetPath, this.initialState, this.transfer, precision);
    }

    private RefinedSlicingPrecision computeNewPrecision(ReachedSet pReached) throws InterruptedException, CPAException {
        RefinedSlicingPrecision refinementRootsAndPrecision = this.getNewPrecision(pReached);
        ++this.refinementCount;
        return refinementRootsAndPrecision;
    }

    private RefinedSlicingPrecision getNewPrecision(ReachedSet pReached) throws InterruptedException, CPAException {
        ARGReachedSet argReached = new ARGReachedSet(pReached, this.argCpa, this.refinementCount);
        Collection<ARGState> targetStates = this.pathExtractor.getTargetStates(argReached);
        List<ARGPath> targetPaths = this.pathExtractor.getTargetPaths(targetStates);
        HashSet<StateSlicingPrecision> newPrecs = new HashSet<StateSlicingPrecision>();
        boolean changed = false;
        for (ARGPath tp : targetPaths) {
            Set<CFAEdge> relevantEdges = this.getSlice(tp);
            ARGState refinementRoot = this.getRefinementRoot(tp, relevantEdges);
            SlicingPrecision oldPrec = this.mergeOnSubgraph(refinementRoot, pReached);
            SlicingPrecision newPrec = oldPrec.getNew(oldPrec.getWrappedPrec(), relevantEdges);
            newPrecs.add(new StateSlicingPrecision(refinementRoot, newPrec));
            if (oldPrec.equals(newPrec)) continue;
            changed = true;
        }
        return new RefinedSlicingPrecision(changed, newPrecs);
    }

    private Set<CFAEdge> getSlice(ARGPath pPath) throws InterruptedException, CPAException {
        List<CFAEdge> innerEdges = pPath.getInnerEdges();
        ArrayList<CFAEdge> criteriaEdges = new ArrayList<CFAEdge>(1);
        HashSet<CFAEdge> relevantEdges = new HashSet<CFAEdge>();
        ImmutableList cexConstraints = FluentIterable.from(innerEdges).filter(CAssumeEdge.class).toList();
        if (this.takeEagerSlice) {
            criteriaEdges.addAll((Collection<CFAEdge>)cexConstraints);
        } else if (this.refineStrategy == RefineStrategy.INFEASIBLE_PREFIX_ASSUME_DEPS) {
            List<InfeasiblePrefix> prefixes = this.prefixProvider.extractInfeasiblePrefixes(pPath);
            if (!prefixes.isEmpty()) {
                Set prefixAssumeEdges = (Set)prefixes.get(0).getPath().getInnerEdges().stream().filter(edge -> edge.getEdgeType() == CFAEdgeType.AssumeEdge).collect(ImmutableSet.toImmutableSet());
                criteriaEdges.addAll(prefixAssumeEdges);
            }
        } else if (!this.isFeasible(pPath)) {
            if (this.refineStrategy == RefineStrategy.CEX_ASSUME_DEPS) {
                criteriaEdges.addAll((Collection<CFAEdge>)cexConstraints);
            } else if (this.refineStrategy == RefineStrategy.CEX_FIRST_ASSUME_DEPS || this.refineStrategy == RefineStrategy.CEX_LAST_ASSUME_DEPS) {
                SlicingPrecision slicingPrecision = Precisions.extractPrecisionByType(this.currentPrecision, SlicingPrecision.class);
                CFAEdge criteriaEdge = null;
                for (CFAEdge assumeEdge : cexConstraints) {
                    if (slicingPrecision.isRelevant(assumeEdge)) continue;
                    criteriaEdge = assumeEdge;
                    if (this.refineStrategy != RefineStrategy.CEX_FIRST_ASSUME_DEPS) continue;
                    break;
                }
                if (criteriaEdge != null) {
                    criteriaEdges.add(criteriaEdge);
                }
            }
        }
        CFANode finalNode = AbstractStates.extractLocation(pPath.getLastState());
        ImmutableList edgesToTarget = CFAUtils.enteringEdges(finalNode).filter(innerEdges::contains).toList();
        criteriaEdges.addAll((Collection<CFAEdge>)edgesToTarget);
        relevantEdges.addAll((Collection<CFAEdge>)this.slicer.getSlice(this.cfa, criteriaEdges).getRelevantEdges());
        return ImmutableSet.copyOf(relevantEdges);
    }

    private SlicingPrecision mergeOnSubgraph(ARGState pRefinementRoot, ReachedSet pReached) {
        Set uniquePrecisions = Sets.newIdentityHashSet();
        for (ARGState descendant : ARGUtils.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            uniquePrecisions.add(SlicingRefiner.extractSlicingPrecision(pReached, descendant));
        }
        SlicingPrecision start = (SlicingPrecision)Iterables.getLast((Iterable)uniquePrecisions);
        HashSet<CFAEdge> allRelevant = new HashSet<CFAEdge>(start.getRelevant());
        for (SlicingPrecision precision : uniquePrecisions) {
            allRelevant.addAll(precision.getRelevant());
        }
        return new SlicingPrecision(start.getWrappedPrec(), allRelevant);
    }

    boolean updatePrecisionAndRemoveSubtree(ReachedSet pReached) throws InterruptedException, CPAException {
        ARGReachedSet argReached = new ARGReachedSet(pReached, this.argCpa, this.refinementCount);
        RefinedSlicingPrecision refRootsAndPrecision = this.computeNewPrecision(pReached);
        if (refRootsAndPrecision.hasSliceChanged()) {
            this.updatePrecision(argReached, refRootsAndPrecision);
            return true;
        }
        return false;
    }

    private void updatePrecision(ARGReachedSet argReached, RefinedSlicingPrecision refRootsAndPrecision) throws InterruptedException {
        for (StateSlicingPrecision prec : refRootsAndPrecision.getStatePrecisions()) {
            ARGState state = prec.getState();
            if (state.isDestroyed()) continue;
            argReached.removeSubtree(state, prec.getPrecision(), (Predicate<? super Precision>)Predicates.instanceOf(SlicingPrecision.class));
        }
    }

    private ARGState getRefinementRoot(ARGPath pPath, Collection<CFAEdge> relevantEdges) {
        switch (this.restartStrategy) {
            case PIVOT: {
                PathIterator iterator = pPath.fullPathIterator();
                while (iterator.hasNext()) {
                    if (relevantEdges.contains(iterator.getOutgoingEdge())) {
                        return iterator.getNextAbstractState();
                    }
                    iterator.advance();
                }
                throw new AssertionError((Object)"Infeasible target path has empty program slice");
            }
            case ROOT: {
                return (ARGState)pPath.asStatesList().get(1);
            }
        }
        throw new AssertionError((Object)("Unhandled restart strategy: " + this.restartStrategy));
    }

    private static SlicingPrecision extractSlicingPrecision(ReachedSet pReached, AbstractState pState) {
        return (SlicingPrecision)Precisions.asIterable(pReached.getPrecision(pState)).filter(SlicingPrecision.class).first().orNull();
    }

    private static final class RefinedSlicingPrecision {
        private final boolean sliceChanged;
        private final Set<StateSlicingPrecision> precisions;

        private RefinedSlicingPrecision(boolean pSliceChanged, Set<StateSlicingPrecision> pPrecisions) {
            this.sliceChanged = pSliceChanged;
            this.precisions = pPrecisions;
        }

        public boolean hasSliceChanged() {
            return this.sliceChanged;
        }

        public Set<StateSlicingPrecision> getStatePrecisions() {
            return this.precisions;
        }
    }

    private static final class StateSlicingPrecision {
        private final ARGState state;
        private final SlicingPrecision precision;

        private StateSlicingPrecision(ARGState pState, SlicingPrecision pPrecision) {
            this.state = pState;
            this.precision = pPrecision;
        }

        public ARGState getState() {
            return this.state;
        }

        public SlicingPrecision getPrecision() {
            return this.precision;
        }
    }

    private static enum RestartStrategy {
        PIVOT,
        ROOT;

    }

    private static enum RefineStrategy {
        CEX_ASSUME_DEPS,
        INFEASIBLE_PREFIX_ASSUME_DEPS,
        CEX_FIRST_ASSUME_DEPS,
        CEX_LAST_ASSUME_DEPS;

    }
}

