/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.slicing;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingPrecision;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class SlicingTransferRelation
extends SingleEdgeTransferRelation {
    private final TransferRelation delegate;

    public SlicingTransferRelation(TransferRelation pDelegateTransferRelation) {
        this.delegate = pDelegateTransferRelation;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        Preconditions.checkState((boolean)(pPrecision instanceof SlicingPrecision), (String)"Precision not of type %s, but %s", (Object)SlicingPrecision.class.getSimpleName(), (Object)pPrecision.getClass().getSimpleName());
        SlicingPrecision slicingPrecision = (SlicingPrecision)pPrecision;
        CFAEdge adjustedEdge = pCfaEdge;
        if (!slicingPrecision.isRelevant(pCfaEdge) && !this.isFunctionControlEdge(pCfaEdge)) {
            adjustedEdge = this.replaceWithNoop(pCfaEdge);
        }
        AbstractState wrappedState = pState;
        Precision wrappedPrecision = slicingPrecision.getWrappedPrec();
        return this.delegate.getAbstractSuccessorsForEdge(wrappedState, wrappedPrecision, adjustedEdge);
    }

    private boolean isFunctionControlEdge(CFAEdge pCfaEdge) {
        if (pCfaEdge instanceof CFunctionSummaryEdge || pCfaEdge instanceof CFunctionSummaryStatementEdge) {
            return true;
        }
        switch (pCfaEdge.getEdgeType()) {
            case FunctionCallEdge: 
            case FunctionReturnEdge: 
            case CallToReturnEdge: {
                return true;
            }
        }
        return false;
    }

    private CFAEdge replaceWithNoop(CFAEdge pCfaEdge) {
        CFANode succ = pCfaEdge.getSuccessor();
        CFANode pred = pCfaEdge.getPredecessor();
        return new BlankEdge(pCfaEdge.getRawStatement(), pCfaEdge.getFileLocation(), pred, succ, pCfaEdge.getDescription());
    }
}

