/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAdditionalInfo;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGAdditionalInfo;
import org.sosy_lab.cpachecker.cpa.smg.SMGConvertingTags;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class AdditionalInfoExtractor {
    public CFAPathWithAdditionalInfo createExtendedInfo(ARGPath pPath) {
        PathIterator rIterator = pPath.reverseFullPathIterator();
        ARGState lastArgState = rIterator.getAbstractState();
        UnmodifiableSMGState state = AbstractStates.extractStateByType(lastArgState, SMGState.class);
        Set<Object> invalidChain = new LinkedHashSet<Object>(state.getInvalidChain());
        String description = state.getErrorDescription();
        boolean isMemoryLeakError = state.hasMemoryLeaks();
        UnmodifiableSMGState prevSMGState = state;
        HashSet<Object> visitedElems = new HashSet<Object>();
        ArrayList<CFAEdgeWithAdditionalInfo> pathWithExtendedInfo = new ArrayList<CFAEdgeWithAdditionalInfo>();
        while (rIterator.hasNext()) {
            rIterator.advance();
            ARGState argState = rIterator.getAbstractState();
            UnmodifiableSMGState smgState = AbstractStates.extractStateByType(argState, SMGState.class);
            CFAEdgeWithAdditionalInfo edgeWithAdditionalInfo = CFAEdgeWithAdditionalInfo.of(rIterator.getOutgoingEdge());
            if (!isMemoryLeakError && description != null && !description.isEmpty()) {
                edgeWithAdditionalInfo.addInfo(SMGConvertingTags.NOTE, SMGAdditionalInfo.of(description, SMGAdditionalInfo.Level.ERROR));
                description = null;
            }
            isMemoryLeakError = false;
            Set<Object> toCheck = this.extractAdditionalInfoFromInvalidChain(invalidChain, prevSMGState, visitedElems, smgState, edgeWithAdditionalInfo);
            invalidChain = toCheck;
            prevSMGState = smgState;
            pathWithExtendedInfo.add(edgeWithAdditionalInfo);
        }
        return CFAPathWithAdditionalInfo.of(Lists.reverse(pathWithExtendedInfo));
    }

    private Set<Object> extractAdditionalInfoFromInvalidChain(Collection<Object> invalidChain, UnmodifiableSMGState prevSMGState, Collection<Object> visitedElems, UnmodifiableSMGState smgState, CFAEdgeWithAdditionalInfo edgeWithAdditionalInfo) {
        LinkedHashSet<Object> toCheck = new LinkedHashSet<Object>();
        for (Object elem : invalidChain) {
            if (visitedElems.contains(elem)) continue;
            if (!this.containsInvalidElement(smgState.getHeap(), elem)) {
                visitedElems.add(elem);
                for (Object additionalElem : prevSMGState.getCurrentChain()) {
                    if (visitedElems.contains(additionalElem) || invalidChain.contains(additionalElem)) continue;
                    toCheck.add(additionalElem);
                }
                edgeWithAdditionalInfo.addInfo(SMGConvertingTags.NOTE, SMGAdditionalInfo.of(this.getNoteMessageOnElement(prevSMGState.getHeap(), elem), SMGAdditionalInfo.Level.NOTE));
                continue;
            }
            toCheck.add(elem);
        }
        return toCheck;
    }

    private boolean containsInvalidElement(UnmodifiableCLangSMG smg, Object elem) {
        if (elem instanceof SMGObject) {
            SMGObject smgObject = (SMGObject)elem;
            return smg.isHeapObject(smgObject) || smg.getGlobalObjects().containsValue((Object)smgObject) || this.isStackObject(smg, smgObject);
        }
        if (elem instanceof SMGEdgeHasValue) {
            SMGEdgeHasValue edgeHasValue = (SMGEdgeHasValue)elem;
            SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(edgeHasValue.getObject()).filterAtOffset(edgeHasValue.getOffset()).filterHavingValue(edgeHasValue.getValue()).filterBySize(edgeHasValue.getSizeInBits());
            Iterable<SMGEdgeHasValue> edges = smg.getHVEdges(filter);
            return edges.iterator().hasNext();
        }
        if (elem instanceof SMGEdgePointsTo) {
            SMGEdgePointsTo edgePointsTo = (SMGEdgePointsTo)elem;
            SMGEdgePointsToFilter filter = SMGEdgePointsToFilter.targetObjectFilter(edgePointsTo.getObject()).filterAtTargetOffset(edgePointsTo.getOffset()).filterHavingValue(edgePointsTo.getValue());
            Set<SMGEdgePointsTo> edges = smg.getPtEdges(filter);
            return !edges.isEmpty();
        }
        if (elem instanceof SMGValue) {
            SMGValue smgValue = (SMGValue)elem;
            return smg.getValues().contains(smgValue);
        }
        return false;
    }

    private boolean isStackObject(UnmodifiableCLangSMG smg, SMGObject pObject) {
        String regionLabel = pObject.getLabel();
        for (CLangStackFrame frame : smg.getStackFrames()) {
            if ((!frame.containsVariable(regionLabel) || frame.getVariable(regionLabel) != pObject) && pObject != frame.getReturnObject()) continue;
            return true;
        }
        return false;
    }

    private String getNoteMessageOnElement(UnmodifiableCLangSMG smg, Object elem) {
        if (elem instanceof SMGEdge) {
            return "Assign edge";
        }
        if (elem instanceof Integer || elem instanceof SMGValue) {
            return "Assign value";
        }
        if (elem instanceof SMGObject) {
            SMGObject smgObject = (SMGObject)elem;
            if (this.isFunctionParameter(smg, smgObject)) {
                return "Function parameter";
            }
            return "Object creation";
        }
        return null;
    }

    private boolean isFunctionParameter(UnmodifiableCLangSMG smg, SMGObject pObject) {
        String regionLabel = pObject.getLabel();
        for (CLangStackFrame frame : smg.getStackFrames()) {
            for (CParameterDeclaration parameter : frame.getFunctionDeclaration().getParameters()) {
                if (!parameter.getName().equals(regionLabel) || frame.getVariable(regionLabel) != pObject) continue;
                return true;
            }
        }
        return false;
    }
}

